unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellAPI,
  mdMailSlot, ExtCtrls, Buttons, agrpbox, acommon, asplit, ToolWin, ComCtrls, StdCtrls,
  Menus, RegistrA, RxCombos, RXSpin, Spin, RXCtrls;

const
  wm_IconNotification = wm_User + 1909;
  wm_ShutDownQuery = wm_User + 1969;

  RegLMF   = 'SOFTWARE\LMF\MessageBox';
  RegStart = 'SOFTWARE\Microsoft\Windows\CurrentVersion\Run';
  ic_mbox=7;
  ic_full=10;

type
  TSettings = packed record
    AppPath: array[0..255] of ANSIChar;
    motd:array[0..255] of ANSIChar;
    TypoName: array[0..63] of ANSIChar;
    TypoSize: Integer;
    AutoPop, AutoMin, AutoStart, AutoSend, AutoTypo:Boolean;

//    IconId: UINT;
  end;

type
  TLMF_PopMe = class(TForm)
    wpop: TmdWinPopup;
    ToolBar1: TToolBar;
    aaSplitter1: TaaSplitter;
    ms: TMemo;
    SendTo: TaaGroupBox;
    Recipient: TEdit;
    Browse: TSpeedButton;
    msgbook: TTabControl;
    Broadcast: TCheckBox;
    Splitter1: TSplitter;
    pop: TPopupMenu;
    popExit: TMenuItem;
    popShow: TMenuItem;
    iconz: TImageList;
    ooClose: TToolButton;
    ClearReg: TToolButton;
    FontType: TFontComboBox;
    FontSize: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Pack: TSpeedButton;
    Send: TSpeedButton;
    Save: TSpeedButton;
    SaveDialog1: TSaveDialog;
    ClearMessages: TSpeedButton;
    Update: TToolButton;
    BCFilter: TCheckBox;
    SaveFontSetting: TSpeedButton;
    oohelp: TToolButton;
    cmd: TPopupMenu;
    ping1: TMenuItem;
    time1: TMenuItem;
    echo1: TMenuItem;
    motd1: TMenuItem;
    command: TRxSpeedButton;
    mm: TMemo;
    version1: TMenuItem;
    Reply: TSpeedButton;
    ToolButton4: TToolButton;
    oooptions: TToolButton;
    popauto: TPopupMenu;
    AutoMinimize1: TMenuItem;
    AutoPopUp1: TMenuItem;
    AutoStart1: TMenuItem;
    AutoSend1: TMenuItem;
    SetMyPrivateMOTD1: TMenuItem;
    N2: TMenuItem;
    AutoTypo1: TMenuItem;
    ToggleSplitMode1: TMenuItem;
    SaveFontSetting1: TMenuItem;
    procedure mdMailSlot1MessageAvail(Sender: TObject; Msg: String);
    procedure popopen(Sender: TObject);
    procedure popmsg(Sender: TObject; AReciever, ASender,
      AMsg: String);
    procedure BrowseClick(Sender: TObject);
    procedure ToggleSplitMode1Click(Sender: TObject);
    procedure ToolBar1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ooCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure msgbookChange(Sender: TObject);
    procedure SendClick(Sender: TObject);
    procedure TAXESNetworkClick(Sender: TObject);
    procedure BroadcastClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure popShowClick(Sender: TObject);
    procedure popExitClick(Sender: TObject);
    procedure ClearMessagesClick(Sender: TObject);
    procedure AutoSend1Click(Sender: TObject);
    procedure AutoTypo1Click(Sender: TObject);
    procedure AutoPopUp1Click(Sender: TObject);
    procedure AutoStart1Click(Sender: TObject);
    procedure AutoMinimize1Click(Sender: TObject);
    procedure SaveRegClick(Sender: TObject);
    procedure ClearRegClick(Sender: TObject);
    procedure FontTypeChange(Sender: TObject);
    procedure FontSizeChange(Sender: TObject);
    procedure PackClick(Sender: TObject);
    procedure Label2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SaveClick(Sender: TObject);
    procedure UpdateClick(Sender: TObject);
    procedure SaveFontSettingClick(Sender: TObject);
    procedure ping1Click(Sender: TObject);
    procedure RecipientChange(Sender: TObject);
    procedure oohelpClick(Sender: TObject);
    procedure SetMyPrivateMOTD1Click(Sender: TObject);
    procedure ReplyClick(Sender: TObject);
    procedure mmDblClick(Sender: TObject);
  private
    CanExit:Boolean;
    msgList:TStringList;
    MyDomain, MyComputer:String;
    function _getDomainName:String;
    function _getComputerName:String;
    property ThisDomain:String read _getDomainName;
    property ThisComputer:String read _getComputerName;
    procedure doMinimize(Sender:TObject);
//    procedure GetPropInfoz(ClassInfo:Pointer);
    procedure FormReCreate(Sender: TObject);
  private //TrayIcon
    nid: TNOTIFYICONDATA;
    R: TRegistry;
    Settings: TSettings;
    ICO:TIcon;
    TrayIconId: UINT;
    TrayIcon: HICON;
//    edtTipText:String;
    AppStartPath:String;
    nomagic:boolean;
    procedure GetDefaultData;
    function AddTrayIconId(iconId: UINT; icon: THandle; tip: PChar): boolean;
    function ModifyTrayIconId(iconId: UINT; icon: THandle; tip: PChar): boolean;
    procedure AddAutoStart;
    procedure DeleteAutoStart;
    procedure AddAppKey;
    procedure DelAppKey;
    function DeleteTrayIconId(iconId: UINT): boolean;
    function updatebox(Silent:Boolean):WORD;
    procedure checkmm(const operation:String);
  public
    procedure ShowMessagC(const S:String);
  protected
    procedure WMIconNotification(var Msg: TMessage); message wm_IconNotification;
    procedure WMQueryEndSession(var Msg: TMessage); message wm_QueryEndSession;

  end;

var
  LMF_PopMe: TLMF_PopMe;

implementation

{$R *.DFM}

uses FileUti2, RegStr, TypInfo, RXVerInf, infocode;//, VerInfo;//, StrUtils;

const
  CR=#13#10;
  CR2=CR+CR;
  unreadmark='+';
  BroadCasted:integer=0;

var
  MSGBoxVersionInfo:TVersionInfo;
  MSGBoxVer:String;

procedure TLMF_PopMe.checkmm(const operation:String);
begin
  if trim(mm.Lines.text) = '' then
    raise exception.Create('nothing to '+operation)
end;

function ErrStr(ErrNo:WORD):String;
const
  nomessage='(message not available)';
begin
  // Set the length of the string variable.
  SetLength(Result, 255);
  // Clean up
  FillChar(Result[1], length(Result), 0);
  // Get System Error Message
  FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, nil,
    ErrNo, 0, pChar(Result), 255, nil);
  //formatting quirk, C & Pascal string conversion
  Result:=pChar(Result);
  if Result='' then
    Result:=nomessage;
  Result:= inttohex(ErrNo, 2) + 'H (' +inttostr(ErrNo) + ')' + CR + (Result);
end;


procedure TLMF_PopMe.ShowMessagC(const S:String);
begin
  with tinfo.Create(Self) do begin
    Label1.Caption:=S;
    ShowModal;
  end;
end;

procedure TLMF_PopMe.WMQueryEndSession(var Msg: TMessage); begin
  CanExit:=TRUE;
  Inherited;
end;

procedure TLMF_PopMe.mdMailSlot1MessageAvail(Sender: TObject; Msg: String);
begin
  mm.Lines.Add(msg);
end;

procedure TLMF_PopMe.popopen(Sender: TObject);
begin
  mm.Lines.Add('-Welcome to LMF MessageBox-');
end;

function TLMF_PopMe.updatebox(Silent:Boolean):WORD;
const
  ORIGINPATH='\\AA\PROJECTS\MSGBOX';
  WININIT:String='WININIT.INI';
var fSrc, fn, dn:string; L:TStringList;
  function cmpVer(const newfile, oldfile:string):dWord;
  var vold,vnew:TVersionInfo;
  begin
    vold:=TVersionInfo.Create(oldfile);
    vnew:=TVerSionInfo.Create(newfile);
    Result:=vnew.FileLongVersion.MS-vold.FileLongVersion.MS;
    if Result=0 then
    Result:=vnew.FileLongVersion.LS-vold.FileLongVersion.LS;
    vold.Destroy; vnew.Destroy;
  end;
  function chgext(const fn, ext:String):String; var i:integer;
  begin Result:='';
    for i:=length(fn) downto 1 do
      if fn[i]='.' then begin
        Result:=copy(fn, 1, i);
        break;
      end;
    Result:=Result+ext;
  end;
  var extn:string; i:integer;
begin
  AppStartPath := Application.ExeName;
  fn:=ExtractFileName(AppStartPath);
  fSrc:=ORIGINPATH + '\' + fn;
  if not FileExists(fsrc) then
    if not Silent then
      raise exception.create('Origin file not found'+ CR +
        'Check your network connection please')
      else exit;
    if cmpVer(ORIGINPATH + '\' + fn, AppStartPath) < 1 then
      if not Silent then 
        if Application.MessageBox('Update not needed'+CR+
          'Force update anyway?', '', 4) = ID_NO then exit;
  try
    CopyFile(fSrc, chgext(AppStartPath, 'NEW'), nil);
  except
    if not Silent then raise
    else exit;
  end;

  dn:=ExtractFileDir(AppStartPath);
  dn:=LongToShortPath(dn);
  if dn[length(dn)]='\' then delete(dn, length(dn), 1);

  fn:=LongToShortFileName(AppStartPath);
  fn:=dn+'\'+fn;

  for i:=100 downto 0 do begin
    extn:=inttohex(i,3);
    if fileexists(chgext(fn, extn)) then begin
      extn:=inttohex(i+1,3);
      break
    end;
  end;

  WININIT:=GetWindowsDir+'\'+'WININIT.INI';
  try
    try
      L:=TStringList.Create;
      if FileExists(WININIT) then L.LoadFromFile(WININIT);
      L.Add('');
      L.Add('[Rename]');
      L.Add(chgext(fn,extn)+'='+fn);
      L.Add(fn+'='+chgext(fn,'NEW'));
      L.SaveToFile(WININIT);
    except
      if not Silent then raise
    end;
  finally L.Free; end;
  if not Silent then
    ShowMessage('Done.'+CR+'Update applied after Windows restarted');
end;

const
  stdmagic='\\.';
  supmagic='#!/.';
  
procedure TLMF_PopMe.popmsg(Sender: TObject; AReciever, ASender, AMsg: String);
const
  cmdfont='.font';
  cmdping='ping';
  cmdecho='echo';
  cmdtime='time';
  cmdmotd='motd';
  cmdver='vers';
  cmdclose='close';
  cmdopen='open';
  cmdexec='exec';
  //cmdexec='execmin';
  cmdshell='shell';
  cmdrestart='restart';
  cmdreboot='reboot';
  cmdscan='scan';
  cmdupdate='update';
  cmdsynctime='synctime';
  cmdauto='auto';
  cmdautostart='autostart';
  cmdautopop='autopop';
  cmdautotypo='autotypo';
  cmdautosend='autosend';
  cmdautominimize='automin';
var
  retcode:integer;
  function magicsend:Boolean; var param:String;   i:integer;
  begin //Result:=FALSE;
    retcode:=0;
    if pos(stdmagic, amsg) = 1 then begin
      Result:=TRUE;
      amsg:=trim(amsg); delete(amsg, 1, length(stdmagic));
    end
    else if pos(supmagic, amsg) = 1 then begin
      Result:=TRUE;
      amsg:=trim(amsg); delete(amsg, 1, length(supmagic));
    end
    else begin
      Result:=FALSE;
      exit;
    end;
    //begin std command check
    if FALSE then begin end
    else if pos(cmdping, amsg) = 1 then
      wpop.Send(ASender, MyComputer, ASender, MyComputer+': PONG!')
    else if pos(cmdtime, amsg) = 1 then
      wpop.Send(ASender, MyComputer, ASender, formatDateTime('dd-mm-yyyy hh:mm:ss',NOW))
    else if pos(cmdecho, amsg) = 1 then begin
      delete(amsg, 1, length(cmdecho));
      wpop.Send(ASender, MyComputer, ASender, amsg);
    end
    else if pos(cmdmotd, amsg) = 1 then begin
      amsg:=Settings.motd;
      for i:=1 to length(amsg) do
        if amsg[i]=';' then begin
          amsg[i]:=#13;
          insert(#10, amsg, i+1);
        end;
      if length(amsg)<1 then amsg:=MyComputer+' has no message today';
      wpop.Send(ASender, MyComputer, ASender, amsg);
    end
    else if pos(cmdver, amsg) = 1 then begin
      amsg:=aReciever+'''s LMF MessageBox Version is: '+ MSGBoxVer;
      wpop.Send(ASender, MyComputer, ASender, amsg);
    end
    else if pos(cmdscan, amsg) = 1 then begin
      delete(amsg, 1, length(cmdscan));
      retcode:=winexec(pChar('C:\SCAN\scanpm.exe '+amsg+
       ' C: /unzip /report c:\scan001.rpt /append'), SW_SHOWMINIMIZED);
    end
    //end std command check
    else if nomagic then exit;
    if FALSE then begin end
    else if pos(cmdshell, amsg) = 1 then begin
      delete(amsg, 1, length(cmdshell));
      retcode:=ShellExecute(handle,'open', pChar(amsg), '', '', SW_SHOWNORMAL);
    end
    else if pos(cmdopen, amsg) = 1 then begin
      delete(amsg, 1, length(cmdopen));
      param:=trim(copy(amsg, pos(' ', amsg), length(amsg)));
      retcode:=ShellExecute(handle,'open', pChar(amsg), pChar(param), '', SW_SHOWNORMAL);
    end
    else if pos(cmdexec, amsg) = 1 then begin
      delete(amsg, 1, length(cmdexec));
      if amsg[1]<>'0' then
        retcode:=WinExec(pChar(amsg), SW_SHOW)
      else
        retcode:=WinExec(pChar(@amsg[2]), SW_SHOWMINIMIZED);
    end
    else if pos(cmdclose, amsg)=1 then begin
      CanExit:=TRUE;
      Close;
    end
    else if pos(cmdrestart, amsg) = 1 then begin
      CanExit:=TRUE;
      ExitWindows(EW_RESTARTWINDOWS, 0);
      Close;
    end
    else if pos(cmdreboot, amsg) = 1 then begin
      ExitWindowsEx(EWX_FORCE or EWX_REBOOT, 0);
    end
    else if pos(cmdupdate, amsg) = 1 then begin
      updatebox(TRUE);
    end
    else if pos(cmdauto, amsg) = 1 then begin
      i:=ord(amsg[length(amsg)])-ord('0');
      if pos(cmdautopop, amsg)=1 then
        with AutoPopUp1 do if Checked<> Boolean(i) then Click;
      if pos(cmdautominimize, amsg)=1 then
        with AutoMinimize1 do if Checked<> Boolean(i) then Click;
      if pos(cmdautostart, amsg)=1 then
        with AutoStart1 do if Checked<> Boolean(i) then Click;
      if pos(cmdautosend, amsg)=1 then
        with AutoSend1 do if Checked<> Boolean(i) then Click;
      if pos(cmdautotypo, amsg)=1 then
        with AutoTypo1 do if Checked<> Boolean(i) then Click;
    end
    //else Result:=FALSE;
  end;
var BCM:String; const nmsg:integer=0;
var i,j:integer; fon,siz:String;
begin
  BCM:='';
  if (AReciever=MyDomain) then begin
    if BCFilter.Checked then exit
    else BCM:='-BROADCAST MESSAGE FROM '+aSender+'-'+CR;
  end
  else if (AReciever<>MyComputer) then exit;
  if (amsg[1] in ['#','\']) and magicsend then exit;
  i:=pos(#28, amsg);
  if i>0 then begin
    j:=pos(#29, amsg);
    fon:=copy(amsg, 1, i-1);
    siz:=copy(amsg, i+1, j-i-1);
    delete(amsg, 1, j);
    if AutoTypo1.Checked then begin
      with FontType do if FontName<>fon then begin
        Fontname:=fon;
        FontTypeChange(FontType);
      end;
      with FontSize do if Text<>siz then begin
        ItemIndex:=items.IndexOf(siz);
        FontSizeChange(FontSize);
      end;
    end;
  end;
  msglist.Add(BCM+'(Received at: '+formatDateTime('dd-mm-yyyy hh:mm:ss',NOW)+') :'+inttostr(length(AMsg))+ ' chars'+ CR +AMsg);

  msgbook.Tabs.Add(unreadmark+lowerCase(ASender));
  msgbook.TabIndex:=msgList.Count-1;
  if not Visible then begin
    inc(nmsg);
    iconz.GetIcon(ic_full, ICO);
    ModifyTrayIconId(ic_mbox, ICO.handle, pChar('You have '+inttostr(nmsg)+' new message(s)'));
    if AutoPopUp1.Checked then
       popShow.Click;
  end else begin
    msgbookChange(msgBook);
    nmsg:=0;
    if AutoPopUp1.Checked then begin
      if not Active then begin
        Application.BringToFront;
        //Application.NormalizeTopMosts;
        //Show;
      end;
    end;
  end;
  MessageBeep(mb_OK); FlashWindow(handle, TRUE);
end;

procedure TLMF_PopMe.BrowseClick(Sender: TObject);
var C:String;
begin
  C:=Recipient.Text;
  if not BrowseComputer(C,'Please pick a WorkStation',0) then exit;
  Recipient.Text:=upperCase(C);
  BroadCast.Checked:=FALSE;
end;

procedure TLMF_PopMe.ToggleSplitMode1Click(Sender: TObject);
begin
  with aaSplitter1 do SplitterOrientation:=
    TaaOrientation(1-ord(SplitterOrientation));
end;

procedure TLMF_PopMe.ToolBar1Click(Sender: TObject); begin
  with TToolBar(Sender) do Flat:=not Flat;
  TToolBar(Sender).height:=0;
end;

procedure TLMF_PopMe.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:=CanExit;
  if not CanClose then doMinimize(Self)
  else DeleteTrayIconId(TrayIconID);
end;

procedure TLMF_PopMe.ooCloseClick(Sender: TObject);
begin
  CanExit:=TRUE;
  Close;
end;

procedure TLMF_PopMe.doMinimize(Sender:TObject);
begin
  iconz.GetIcon(ic_mbox, ICO);
  AddTrayIconId(TrayIconID, ICO.Handle, 'LMF MessageBox');
  Hide;
end;

function TLMF_PopMe._getComputerName:String;
var c:integer;
begin  c:=255; setLength(Result, c);
  if not getComputerName(pChar(Result), c) then
    Raise exception.Create('Can not get computer name')
  else Result:=String(pChar(Result));
end;

function TLMF_PopMe._getDomainName:String;
begin
  if R.OpenKey(REGSTR_PATH_VNETSUP, FALSE, KEY_R) then begin
    try try Result:=uppercase(R.ReadString('WorkGroup'));
    except Result:=''; raise end;
    finally R.CloseKey; end;
  end;
end;

procedure TLMF_PopMe.FormCreate(Sender: TObject);
  procedure disevent; begin //justincase
    AutoPopUp1.OnClick:=nil;
    AutoMinimize1.OnClick:=nil;
    AutoStart1.OnClick:=nil;
    AutoSend1.OnClick:=nil;
    AutoTypo1.OnClick:=nil;
    FontType.OnChange:=nil;
    FontSize.OnChange:=nil;
  end;
  procedure setevent; begin
    FontType.OnChange:=FontTypeChange;
    FontSize.OnChange:=FontSizeChange;
    AutoSend1.OnClick:=AutoSend1Click;
    AutoTypo1.OnClick:=AutoTypo1Click;
    AutoStart1.OnClick:=AutoStart1Click;
    AutoPopUp1.OnClick:=AutoPopUp1Click;
    AutoMinimize1.OnClick:=AutoMinimize1Click;;
    Application.OnMinimize:=doMinimize;
  end;
begin
  //GetPropInfoz(wpop.ClassInfo)
  MSGBoxVersionInfo:=TVersionInfo.Create(Application.ExeName);
  MSGBoxVer:=MSGBoxVersionInfo.FileVersion;
  Caption:=Caption+' - Version '+MSGBoxVer;
  Position:=poScreenCenter;
  R:=TRegistry.Create;
  R.RootKey:=HKEY_LOCAL_MACHINE;
  msgList:=TStringList.Create;
  MyDomain:=ThisDomain;
  MyComputer:=ThisComputer;
  disevent; FormReCreate(Self); setevent;
  FontSizeChange(FontSize); //workaround improperly set
//  with AutoStart1 do if not Checked then Click;
  WPop.Active:=TRUE;
  if AutoMinimize1.Checked then begin
    Application.ShowMainForm:=FALSE;
    doMinimize(Self);
  end;  
end;

procedure TLMF_PopMe.FormDestroy(Sender: TObject);
begin
  ICO.Free;  msgList.Free;  R.Free;
  DeleteTrayIconId(TrayIconId);
  MSGBoxVersionInfo.Destroy;
end;

procedure TLMF_PopMe.GetDefaultData;
begin
  AppStartPath := Application.ExeName;
  FontType.FontName:=Font.Name;
  FontSize.ItemIndex:=FontSize.Items.IndexOf(inttoStr(Font.Size));
  TrayIconId := ic_mbox;
  try
    if R.OpenKey(RegLMF, False, KEY_R) then begin
      try
        if R.ReadBinaryData('Options', Settings, SizeOf(TSettings)) > 0 then
          with Settings do begin
            if StrPas(TypoName)<>'' then
              FontType.FontName:=TypoName;
            if TypoSize >= 0 then
              FontSize.ItemIndex:= TypoSize;
            AutoPopUp1.Checked:=AutoPop;
            AutoMinimize1.Checked:=AutoMin;
            AutoStart1.Checked:=AutoStart;
            AutoSend1.Checked:=AutoSend;
            AutoTypo1.Checked:=AutoTypo;
        end
        else begin
        end;
      finally
        R.CloseKey;
      end;
    end
    else begin
      AutoStart1Click(AutoStart1);
    end;
    //try
    //  AutoStart.Checked:=
    //    R.OpenKey(RegStart, FALSE, KEY_R) and
    //      R.ValueExists('LMF_MessageBox') and
    //        (R.ReadString('LMF_MessageBox')=AppStartPath);
    //finally
    //  R.CloseKey;
    //end;
  except
    on E:Exception do
      if not (E is ERegistryException) then
        raise;
  end
end;

procedure TLMF_PopMe.FormReCreate(Sender: TObject);
var
  SystemMenu: HMENU;
begin
  ICO:=TIcon.Create;
  nid.cbSize := SizeOf(TNOTIFYICONDATA);
  nid.Wnd := Handle;
  nid.uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
  nid.uCallbackMessage := wm_IconNotification;

  GetDefaultData;

  iconz.GetIcon(ic_mbox, ICO);
  TrayIcon:=ICO.Handle;

  SystemMenu := GetSystemMenu(Handle, False);
  DeleteMenu(SystemMenu, SC_TASKLIST, MF_BYCOMMAND);
  DeleteMenu(SystemMenu, 7, MF_BYPOSITION);
  DeleteMenu(SystemMenu, 5, MF_BYPOSITION);
  DeleteMenu(SystemMenu, SC_MAXIMIzE, MF_BYCOMMAND);
  DeleteMenu(SystemMenu, SC_MINIMIzE, MF_BYCOMMAND);
  //DeleteMenu(SystemMenu, SC_SIzE, MF_BYCOMMAND);
  DeleteMenu(SystemMenu, SC_RESTORE, MF_BYCOMMAND);
end;


procedure TLMF_PopMe.msgbookChange(Sender: TObject);
var S:String;
begin
  with Sender as TTabControl do
    if Tabs.Count<1 then exit
  else begin
    S:=Tabs[TabIndex];
    if S[1]=unreadmark then begin
      delete(S,1,1);
      Tabs[TabIndex]:=S;
    end;
    mm.Text:=msgList[TabIndex];
  end;
end;

procedure TLMF_PopMe.SendClick(Sender: TObject);
function aCommand(const msg:string):Boolean; begin
  Result:=(pos(stdmagic, msg)=1) or (pos(supmagic, msg)=1)
end;
var sz:String;
begin
  if trim(Recipient.Text)='' then
    raise exception.Create('send to nothing');
  if trim(ms.Lines.Text)='' then
    raise exception.Create('nothing to send')
  else begin
    if not aCommand(ms.Lines.Text) then begin
      if BroadCast.Checked then begin
        inc(BroadCasted);
        if BroadCasted>5 then
        raise exception.Create('BANNED: no more broadcast allowed in this session!')
        else if BroadCasted>3 then
        ShowMessage('warning: you have brodcasted more than 3 consecutive messages')
      end
      else if Broadcasted<5 then Broadcasted:=0;
    end;
    sz:='';
    if AutoTypo1.Checked then
      if ((pos(stdmagic, ms.lines[0])<>1) and (pos(supmagic, ms.lines[0])<>1)) then
        if (FontType.FontName<>'') and (FontSize.ItemIndex>=0) then
          sz:=FontType.FontName+#28+FontSize.Text+#29;
    if wpop.Send(MyDomain, MyComputer, Recipient.Text, pChar(sz+ms.Lines.Text)) then
      ShowMessage('message has been sent out');
  end;
end;

{
procedure TLMF_MessageBox.GetPropInfoz(ClassInfo:Pointer);//(Sender: TObject);
var PropList: PPropList; i: integer;
begin
  PropList:= AllocMem(SizeOf(PropList^));
  i := 0;
  try
    GetPropList(TMdWinPopup.ClassInfo, tkProperties + [tkMethod], PropList);
    while (PropList^[i] <> Nil) and (i < High(PropList^)) do begin
      mm.lines.Add(PropList^[i].Name + ': '  +
        PropList^[i].PropType^.Name);
      Inc(i);
    end;
  finally FreeMem(PropList);
  end;
end;
}

procedure TLMF_PopMe.TAXESNetworkClick(Sender: TObject);
begin
  Recipient.Text:=MyDomain;
end;

procedure TLMF_PopMe.BroadcastClick(Sender: TObject); begin
  with TCheckBox(Sender), Recipient do begin
    Enabled:=not Checked;
    if not Enabled then Text:=MyDomain
    else if Text=MyDomain then Text:='';
  end;
end;

function TLMF_PopMe.AddTrayIconId(iconId: UINT; icon: THandle; tip: PChar): boolean;
begin
  nid.uID := iconId;
  nid.hIcon := icon;

  if tip <> nil then
    StrLCopy(nid.szTip, tip, SizeOf(nid.szTip))
  else
    nid.szTip[0] := #0;

  Result := Shell_NotifyIcon(NIM_ADD, @nid);
end;

function TLMF_PopMe.DeleteTrayIconId(iconId: UINT): boolean;
begin
  nid.uId := iconId;
  Result := Shell_NotifyIcon(NIM_DELETE, @nid);
  nid.hIcon:=0;
end;

function TLMF_PopMe.ModifyTrayIconId(iconId: UINT; icon: THandle; tip: PChar): boolean;
begin
  nid.uID := iconId;
  nid.hIcon := icon;

  if tip <> nil then
    StrLCopy(nid.szTip, tip, SizeOf(nid.szTip))
  else
    nid.szTip[0] := #0;
    
  Result := Shell_NotifyIcon(NIM_MODIFY, @nid);
end;

procedure TLMF_PopMe.WMIconNotification(var Msg: TMessage);
var
  MouseMsg: longint;
  Pt: TPoint;
begin
  MouseMsg := Msg.LParam;
  case MouseMsg of
    //wm_LButtonDown: popShow.Click;
    wm_LButtonUp: popShow.Click;
    wm_RButtonUp: begin
      GetCursorPos(Pt);
      pop.PopUp(Pt.X,Pt.Y);
    end;
    //wm_LButtonDblClk:;
      //popShowClick(Self);
  end;
end;

procedure TLMF_PopMe.popShowClick(Sender: TObject);
begin
  BringToFront;
  if not Visible then begin
    Visible := True;
    DeleteTrayIconId(TrayIconID);
    iconz.GetIcon(ic_mbox, ICO);
    msgbookChange(msgbook);
  end;
end;

procedure TLMF_PopMe.popExitClick(Sender: TObject);
begin
  CanExit:=TRUE;
  Close
end;

procedure TLMF_PopMe.ClearMessagesClick(Sender: TObject);
begin
  checkmm('clear');
  msgbook.Tabs.Clear;
  msgList.Clear;
  mm.Lines.Clear;
  //ShowMessage('messages cleared');
end;

procedure TLMF_PopMe.AddAutoStart; begin
  if R.OpenKey(RegStart, True, KEY_RW) then
     R.WriteString('LMF_MessageBox', AppStartPath);
   R.CloseKey;
end;

procedure TLMF_PopMe.DeleteAutoStart; begin
  if R.OpenKey(RegStart, False, KEY_R) then
    R.DeleteValue('LMF_MessageBox');
  R.CloseKey;
end;

procedure TLMF_PopMe.AutoPopUp1Click(Sender: TObject);
begin
  with TMenuItem(Sender) do Checked:=not Checked;
  Settings.AutoPop:=TMenuItem(Sender).Checked;
  SaveRegClick(Self);
end;

procedure TLMF_PopMe.AutoMinimize1Click(Sender: TObject);
begin
  with TMenuItem(Sender) do Checked:=not Checked;
  Settings.AutoMin:=TMenuItem(Sender).Checked;
  SaveRegClick(Self);
end;

procedure TLMF_PopMe.AutoTypo1Click(Sender: TObject);
begin
  with TMenuItem(Sender) do begin
    Checked:=not Checked;
    Settings.AutoTypo:=Checked;
  end;
  SaveRegClick(Self);
end;

procedure TLMF_PopMe.AutoSend1Click(Sender: TObject);
begin
  with TMenuItem(Sender) do Checked:=not Checked;
  Settings.AutoSend:=TMenuItem(Sender).Checked;
  SaveRegClick(Self);
end;

procedure TLMF_PopMe.AutoStart1Click(Sender: TObject); begin
  with TMenuItem(Sender) do Checked:=not Checked;
  Settings.AutoStart:=TMenuItem(Sender).Checked;
  with TMenuItem(Sender) do if Checked then
    AddAutoStart
  else
    DeleteAutoStart;
  SaveRegClick(Self);
end;

procedure TLMF_PopMe.AddAppKey; begin
  if R.OpenKey(RegLMF, True, KEY_RW) then
    R.WriteBinaryData('Options', Settings, SizeOf(TSettings));
  R.CloseKey;
end;

procedure TLMF_PopMe.DelAppKey; begin
  if R.OpenKey('SOFTWARE\LMF', False, KEY_R) then
    R.DeleteKey('MessageBox');
  R.CloseKey;
end;

procedure TLMF_PopMe.SaveRegClick(Sender: TObject);
begin
//  FillChar(Settings, SizeOf(TSettings), 0);
  StrCopy(Settings.AppPath, PChar(AppStartPath));
  AddAppKey;
end;

procedure TLMF_PopMe.SaveFontSettingClick(Sender: TObject);
begin
  StrCopy(Settings.TypoName, PChar(FontType.FontName));
  Settings.TypoSize:=FontSize.ItemIndex;
  SaveRegClick(Self);
end;

procedure TLMF_PopMe.ClearRegClick(Sender: TObject);
begin
  if Application.MessageBox('Are you sure want to remove all stored settings',
    'Delete all settings', 4356) = ID_NO then exit;
  with AutoStart1 do if Checked then Click;
  with AutoPopup1 do Checked:=FALSE;
  with AutoMinimize1 do Checked:=FALSE;
  with AutoSend1 do Checked:=FALSE;
  with AutoTypo1 do Checked:=FALSE;
  DelAppKey;
end;

procedure TLMF_PopMe.FontTypeChange(Sender: TObject);
begin
  mm.Font.Name:=TFontComboBox(Sender).FontName;
  ms.Font:=mm.Font;
end;

procedure TLMF_PopMe.FontSizeChange(Sender: TObject);
var i:integer;
begin
  with TComboBox(Sender) do
    if ItemIndex<0 then exit
    else i:=StrToInt(Items[ItemIndex]);
  mm.Font.Size:=i;
  ms.Font:=mm.Font;
end;

procedure TLMF_PopMe.PackClick(Sender: TObject);
const separator='|'; sep=separator; footer=CR2;
var i,x :integer; L, P:TStringList; S:string;
begin
  checkmm('pack');
  L:=TStringList.Create; //List Of title/sender
  P:=TStringList.Create;
  for i:=0 to msgbook.Tabs.Count-1 do begin
    S:= msgbook.Tabs[i];
    x:= L.IndexOf(S);
    if x < 0 then begin
      L.Add(S); P.Add(S + sep + msgList[i]);
    end
    else
      P[x]:=P[x] + CR2 + msgList[i];
  end;

  msgBook.Tabs.Clear; msgList.Clear;
  for x:=0 to P.Count-1 do begin
    S:= P[x]; i:= pos(sep, S);
    msgbook.Tabs.Add(copy(S, 1, i-1));
    msgList.Add(copy(S, i+1, length(S)));
  end;
  L.Free; P.Free;
  msgbookChange(msgbook);
  //ShowMessage('messages packed');
end;

procedure TLMF_PopMe.Label2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Shift=[ssCtrl, ssShift, ssRight] then nomagic:=not nomagic;
  with TLabel(Sender) do if nomagic then Caption:='-' else Caption:='*';
  ToolBar1.Flat:=nomagic=FALSE;
  ToolBar1.ButtonHeight:=0;
end;

procedure TLMF_PopMe.SaveClick(Sender: TObject);
var L:TStringList; i:integer;
begin
  checkmm('save');
  if SaveDialog1.Execute then begin
    L:=TStringList.Create;
    for i:=0 to msgbook.Tabs.Count-1 do begin
      L.Add('MessageBox-'+inttoStr(i+1)+': '+msgbook.tabs[i]);
      L.Add(msgList[i]);
    end;
    L.SaveToFile(SaveDialog1.FileName);
    ShowMessage('message saved in :' + SaveDialog1.FileName);
    L.Free;
  end;
end;

procedure TLMF_PopMe.UpdateClick(Sender: TObject);
begin
  updatebox(FALSE);
end;

procedure TLMF_PopMe.ping1Click(Sender: TObject);
var m:TmenuItem;
begin
  m:=Sender as TMenuItem;
  ms.Lines.Clear;
  ms.lines.Add('\\.'+m.Caption);
  if m.caption='echo' then
    with ms do
      lines[0]:= lines[0] + inputBox('echo message', 'enter string to be echoed:', '');
  if AutoSend1.Checked then Send.Click;
end;

procedure TLMF_PopMe.RecipientChange(Sender: TObject);
begin
  if not BroadCast.Checked and (TEdit(Sender).Text=MyDomain) then
    BroadCast.Checked:=TRUE;

end;

procedure TLMF_PopMe.oohelpClick(Sender: TObject);
begin
  ShowMessage('sorry, help not available yet');
end;
procedure TLMF_PopMe.SetMyPrivateMOTD1Click(Sender: TObject);
var msg:string;
begin
  msg:=Settings.motd;
  if inputQuery('Set your private Message Of The Day (MOTD)',
    'max.255 chars, use semicolon [;] as a line separator', msg) then begin
    StrLCopy(Settings.motd, PChar(msg), 255);
    SaveRegClick(Self);
  end;
end;

procedure TLMF_PopMe.ReplyClick(Sender: TObject);
var rcpt:String;
begin
  if msgbook.Tabs.Count<1 then exit;
  rcpt:=msgbook.Tabs[msgbook.tabindex];
  with Broadcast do if Checked then Checked:=FALSE;
  recipient.Text:=rcpt;
  ms.SetFocus;
end;



procedure TLMF_PopMe.mmDblClick(Sender: TObject);
begin
  with TMemo(Sender) do Wordwrap:=not wordwrap
end;

initialization
Finalization

end.



