//------------------------------------------------------------------------
// I saw M$ Money 98 beta and liked the interface.  These component is a simpe
// encapsulation of the active controls used in that program.  The idea is that
// as the user places the cursor over the control it becomes a pointing hand
// as in a Hyper Link and changes colour.  As it they are descendents of standard
// controls you can use the OnClick event etc to handle any processing required.
//  Plus all the regular cursors are exposed via the Object Inspector.
// So you don't have to use the default hand.
//
// This components are freeware.  Use them at you're own risk.
// However I retain the copyright and request that if you change anything
// you let me know (ie; send me the modified source).  Otherwise use to your
// hearts content.  I hope it helps someone.  It's simple stuff like this that
// makes Delphi such a great tool.
// Copyright 1997/1998 Scott Kane.  MicroNexus Software Australia.  Qld.
// Version 1.0.0.0

//This is the first release of this control collection.
//Planned improvements include:
// *Add cell highlighting on grids instead of the whole control
// *Add cell highlighting on calendar instead of whole control
// *Add Listboxes etc (These require additional handling due to the mouse calls
//Scott Kane.  November 1997

unit HyperRadioButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  THyperRadioButton = class(TRadioButton)
  private
    { Private declarations}

  protected

    { Protected declarations}
    FColorLeaveLabel: TColor; //Color when cursor is off label
    FColorEnterLabel: TColor;  //Color when curosr is over label
    procedure SetColorLeaveLabel(aVal: TColor);

  public
    {Public declarations}
    constructor Create(AOwner: TComponent); override;
    procedure CMMouseEnter(var Msg: TMessage); message CM_MOUSEENTER; //Detect Mouse
    procedure CMMouseLeave(var Msg: TMessage); message CM_MOUSELEAVE; //Detect Mouse
  published
    { Published declarations}
    property ColorLeave: TColor read FColorLeaveLabel write SetColorLeaveLabel;
    property ColorEnter: TColor read FColorEnterLabel write FColorEnterLabel;
    // Not much else needed
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MSA Hyper Controls', [THyperRadioButton]); //Wack it on the pallette
end;


constructor THyperRadioButton.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  Cursor := crHandPoint; //Set default cursor to pointing hand
end;

procedure THyperRadioButton.CMMouseEnter(var Msg: TMessage);

begin
  font.color := FColorEnterLabel; //Change color when mouse is over label
end;


procedure THyperRadioButton.CMMouseLeave(var Msg: TMessage);

begin
  font.color := FColorLeaveLabel; //Change color when mouse leaves label (default color)
end;


procedure THyperRadioButton.SetColorLeaveLabel(aVal: TColor);
begin
  FColorLeaveLabel := aVal;
  font.color := aVal;
end;

end.
