unit rExport;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, DsgnIntf;

type
  TAboutRichExporter = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TRichExporter = class(TRichEdit)
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure ExportToUNIX(DestFile: string);
    procedure ExportToMac(DestFile: string);
  end;

procedure Register;

implementation

procedure TAboutRichExporter.Edit;
begin
  Application.MessageBox('TRichExporter component v1.00 for Delphi 2.0. Copyright (C) 1997 Ivan Azic.',
                         'About TRichExporter Component', MB_OK + MB_ICONINFORMATION);
end;

function TAboutRichExporter.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutRichExporter.GetValue: string;
begin
  Result:= '(about)';
end;

constructor TRichExporter.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TRichExporter.Destroy;
begin
  inherited Destroy;
end;

procedure TRichExporter.ExportToUNIX(DestFile: string);
const
  LF : byte = $0A;
var
  f: file of byte;
  i, j: integer;
  s: string;
begin
  if GetTextLen = 0 then begin
    Application.MessageBox('The document is empty. There is nothing to save.', 'Information', MB_OK + MB_ICONINFORMATION);
    Exit;
  end;
  AssignFile(f, DestFile);
  Rewrite(f);
  for i:= 0 to Lines.Count - 1 do begin
    s:= Lines[i];
    for j:= 1 to length(s) do
      Write(f, byte(s[j]));
    Write(f, LF);
  end;
  CloseFile(f);
end;

procedure TRichExporter.ExportToMac(DestFile: string);
const
  CR : byte = $0D;
var
  f: file of byte;
  i, j: integer;
  s: string;
begin
  if GetTextLen = 0 then begin
    Application.MessageBox('The document is empty. There is nothing to save.', 'Information', MB_OK + MB_ICONINFORMATION);
    Exit;
  end;
  AssignFile(f, DestFile);
  Rewrite(f);
  for i:= 0 to Lines.Count - 1 do begin
    s:= Lines[i];
    for j:= 1 to length(s) do
      Write(f, byte(s[j]));
    Write(f, CR);
  end;
  CloseFile(f);
end;

procedure Register;
begin
  RegisterComponents('Samples', [TRichExporter]);
  RegisterPropertyEditor(TypeInfo(TAboutRichExporter), TRichExporter, 'ABOUT', TAboutRichExporter);
end;

end.
