unit mExport;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DsgnIntf;

type
  TAboutMemoExporter = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TMemoExporter = class(TMemo)
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure ExportToUNIX(DestFile: string);
    procedure ExportToMac(DestFile: string);
  end;

procedure Register;

implementation

procedure TAboutMemoExporter.Edit;
begin
  Application.MessageBox('TMemoExporter component v1.00 for Delphi 2.0. Copyright (C) 1997 Ivan Azic.',
                         'About TMemoExporter Component', MB_OK + MB_ICONINFORMATION);
end;

function TAboutMemoExporter.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutMemoExporter.GetValue: string;
begin
  Result:= '(about)';
end;

constructor TMemoExporter.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TMemoExporter.Destroy;
begin
  inherited Destroy;
end;

procedure TMemoExporter.ExportToUNIX(DestFile: string);
const
  LF : byte = $0A;
var
  f: file of byte;
  i, j: integer;
  s: string;
begin
  if GetTextLen = 0 then begin
    Application.MessageBox('The document is empty. There is nothing to save.', 'Information', MB_OK + MB_ICONINFORMATION);
    Exit;
  end;
  AssignFile(f, DestFile);
  Rewrite(f);
  for i:= 0 to Lines.Count - 1 do begin
    s:= Lines[i];
    for j:= 1 to length(s) do
      Write(f, byte(s[j]));
    Write(f, LF);
  end;
  CloseFile(f);
end;

procedure TMemoExporter.ExportToMac(DestFile: string);
const
  CR : byte = $0D;
var
  f: file of byte;
  i, j: integer;
  s: string;
begin
  if GetTextLen = 0 then begin
    Application.MessageBox('The document is empty. There is nothing to save.', 'Information', MB_OK + MB_ICONINFORMATION);
    Exit;
  end;
  AssignFile(f, DestFile);
  Rewrite(f);
  for i:= 0 to Lines.Count - 1 do begin
    s:= Lines[i];
    for j:= 1 to length(s) do
      Write(f, byte(s[j]));
    Write(f, CR);
  end;
  CloseFile(f);
end;

procedure Register;
begin
  RegisterComponents('Samples', [TMemoExporter]);
  RegisterPropertyEditor(TypeInfo(TAboutMemoExporter), TMemoExporter, 'ABOUT', TAboutMemoExporter);
end;

end.
