unit ProgressWndDemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mProgressForm, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ProgressWnd: TmProgressWnd;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   // create our component at run-time to enable
   // testing it w/o installing to component palette
   ProgressWnd := TmProgressWnd.Create(Self);
   with ProgressWnd do begin
      Parent := Self;
      Width := 280; // defaults to 256
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   i: integer;
begin
   with ProgressWnd do begin
      Max := 6000;
      Caption := 'Starting disaster...';
      try
         // show progress window, it will be created automatically
         Show;
         for i := 0 to 2000 do
            Position := i;
         Caption := 'Preparing zeroes...';
         for i := 2001 to 4000 do
            Position := i;
         Caption := 'Writing to boot sector...';
         for i := 4001 to 6000 do
            Position := i;
      finally
         // hide and destroy window
         Hide;
      end;
   end;
   Beep;
   ShowMessage('oops!');
end;

end.
