/* str_lib.cpp

   String manipulation routines for Win32 interface. Not needed
   for other operating systems. Bad programming by Jeff Tsay.

   Last modified : 06/21/97 */

#include <windows.h>
#include "str_lib.h"

str_type my_itoa(int value, str_type str, int radix)
// Negative numbers not supported, or radices bigger than 10
{
   char temp[256];

   if (value == 0) {
   	str[1] = '\0';
      str[0] = '0';

	} else {

	   temp[255]='\0';
      int last_index;

   	for(int i=254; i>=0, value>0; i--) {
      	int remainder = value % radix;
	      value /= radix;
   	   temp[i] = (char) (remainder + '0');
      	last_index = i;
	   }

   	lstrcpy(str, temp + last_index);
   }

   return(str);
}

int my_atoi(str_type str)
// Negative numbers not supported
{
	int length = lstrlen(str);
   int base = 1;
   int result = 0;

   for(int i=length-1; i>=0; i--)
   {
		result += (str[i] - '0') * base;
      base = (base << 3) + (base << 1);  // base*=10;
   }

   return(result);
}


str_type strcpy_2n(str_type dest, str_type src)
// Copies until 2 '\0' characters are reached
{
	int last_zero = 0;
   str_type temp_src = src;

   while (1) {
   	if ((*dest++ = *temp_src++) == '\0') {
      	if (last_zero) {
         	return(dest);
         } else {
         	last_zero = 1;
         }
      } else {
      	last_zero = 0;
      }
   }
}

str_type strcat_2n(str_type dest, str_type src)
// Appends at the 2nd '\0' character
{
	int last_zero = 0;
   int found = 0;
   str_type temp_dest = dest;

   while (!found) {
      if (*temp_dest == '\0') {
      	if (last_zero) {
         	found = 1;
         } else {
         	last_zero = 1;
            temp_dest++;
         }
   	} else {
      	last_zero = 0;
         temp_dest++;
      }
   }

   strcpy_2n(temp_dest, src);

   return(dest);
}

bool b_strcmpi(str_type s1, str_type s2)
// Case insensitive string compare that returns true if
// the strings match.
{
	return ((bool) (lstrcmpi(s1, s2) == 0));
}

str_type time_string(int ms, str_type dest)
{
	int i, j, nmlength;
	int seconds, minutes;
	char second_str[4];
	char minute_str[4];

	minutes = ms / 60000;
	seconds = ms / 1000 - minutes * 60;

	my_itoa(minutes, minute_str, 10);
	my_itoa(seconds, second_str, 10);

	nmlength = 3 - lstrlen(minute_str);

	for (i=0; i < nmlength ; i++)
		dest[i] = '0';

	for (i = nmlength, j=0; i<3; i++, j++)
		dest[i] = minute_str[j];

	dest[3] = ':';

	nmlength = 6 - lstrlen(second_str);

	for (i=4; i < nmlength ; i++)
		dest[i] = '0';

	for (i=nmlength, j=0; i<6; i++, j++)
		dest[i] = second_str[j];

	dest[6]='\0';

	return (dest);
}

str_type Proper_Filename(str_type s)
{
	int length = lstrlen(s);

	for(int i=length; i>=0; --i)
		if (s[i]=='\\')
			return (s+i+1);
	return(s);
}

int CDTrack_number(str_type current, str_type next, str_type src)
{
	int ret_val;
	int length = lstrlen(src);
   int chars_to_copy = 2;
   int i = length - 5;
   int next_track;

   while ((src[i]!='k') && (src[i]!='K') && (i>0)) {
   	chars_to_copy++;
      i--;
   };

   do {
	   i++;
      chars_to_copy--;
   } while (src[i]=='0');

   lstrcpyn(current, src + i, chars_to_copy);

   ret_val = my_atoi(current);
   next_track = ret_val + 1;

   my_itoa(next_track, next, 10);

   return(ret_val);
}



