// maplay.cpp - MPEG audio decoder

#include <iostream.h>  // for reporting errors
#include "all.h"
#include "crc.h"
#include "header.h"
#include "subband.h"
#include "sublay1.h"
#include "sublay2.h"
#include "synfilt.h"
#include "ibitstr.h"
#include "obuffer.h"
#include "args.h"
#include "layer3.h"
#include "MPEx.h"
#include "maplay.h"

#include <classlib/thread.h>
#include <winsys/wsysinc.h>

bool* StopHook;

extern int ResultError;

uint32 layer;
Header *header;
Crc16 *crc;
Ibitstream *stream;
enum e_channels which_channels;
enum e_mode mode;
bool read_ready = FALSE, write_ready = FALSE;

SynthesisFilter *filter1 = NULL, *filter2 = NULL;
Obuffer *buffer = NULL;
LayerIII_Decoder *l3decoder = NULL;

TPlayThread *player = NULL;

void maplay_Exit(uint32 returncode)
{
try
{
  if (returncode == 1 && buffer) {
    buffer->set_stop_flag();
  }

  delete buffer;
  buffer = NULL;

  delete filter1;
  filter1 = NULL;
  delete filter2;
  filter2 = NULL;

  delete l3decoder;
  l3decoder = NULL;
}
  catch (...)
  {
     buffer = NULL;
     filter1 = NULL;
     filter2 = NULL;
     l3decoder = NULL;
  }
}

uint32 startplay(MPEG_Args *maplay_args)
{

   read_ready = FALSE;
   write_ready = FALSE;

   // These arguments should not change while decoding
   header = maplay_args->MPEGheader;
   crc = NULL;
   stream = maplay_args->stream;
   which_channels = maplay_args->which_c;

   // get info from header of first frame:
   layer = header->layer();
   filter1 = NULL;
   filter2 = NULL;
   buffer = NULL;
   try
   {
     if ((mode = header->mode()) == single_channel)
    	   which_channels = left;

   // create filter(s):
     {
      real scalefactor = (maplay_args->use_own_scalefactor) ?
      	    			    maplay_args->scalefactor  :
                         32768.0f;

		filter1 = new SynthesisFilter(0, scalefactor);

	   if ((mode != single_channel) && (which_channels == both))
		   filter2 = new SynthesisFilter(1, scalefactor);
     }
     // create buffer, and check to see if created ok:
     switch (maplay_args->output_mode) {

      case O_WAVEMAPPER:
      case O_DIRECTSOUND:
      buffer = create_obuffer(maplay_args);
      break;

      case O_WAVEFILE:
      buffer = create_Wavefile_obuffer(maplay_args);
      break;
     }
     if (buffer == NULL) {
       maplay_args->playmode = 1;
       ResultError = mpNoOutput;
       if (filter1) {delete filter1;}
       if (filter2) {delete filter2;}
       return (1);
     }
   }

   catch (...) {
     maplay_args->playmode = 1;
     ResultError = mpNoOutput;
     if (filter1) {delete filter1;}
     if (filter2) {delete filter2;}
     return(1);
   }
   try {
     if (player) {
       player->~TPlayThread();
       player = NULL;
     }
     player = new TPlayThread;
     player->maplay_args = maplay_args;
     player->SetPriority(maplay_args->playpriority);
     maplay_args->playmode = 3;
     player->Start();
   }
   catch (...) {
     maplay_args->playmode = 1;
     ResultError = mpInternalError;
     return(1);
   }
   return(0);
}

int TPlayThread::Run()
{
	// Layer III : initialize decoder

   bool FrameRead = true;

   if (layer == 3)
   try {
     l3decoder = new LayerIII_Decoder(stream, header, filter1, filter2, buffer, which_channels);
   }
   catch (...) {
     maplay_args->playmode = 1;
     ResultError = mpInternalError;
     return(1);
   }

   maplay_args->position_change = true;
   maplay_args->desired_position = maplay_args->startpos;

   do
   {

    if (maplay_args->stop) {
       maplay_Exit(1);
       maplay_args->stop = false;
       maplay_args->playmode = 1;
       return(0);
    }

    if (stream->current_frame()>maplay_args->endpos) {
       maplay_Exit(0);
       maplay_args->playmode = 2;
       *StopHook = true;
       return(0);
    }

    if (maplay_args->pause && maplay_args->playmode == 3) {
      maplay_args->pause = false;
      maplay_args-> playmode = 4;
    }

    if (maplay_args->pause && maplay_args->playmode == 4) {
      maplay_args->pause = false;
      maplay_args-> playmode = 3;
    }

    if (!maplay_args->nonseekable && maplay_args->position_change) {

		buffer->clear_buffer();

      if (!header->stream_seek(stream, maplay_args->desired_position)) {
         maplay_Exit(0);
         maplay_args->playmode = 2;
         *StopHook = true;
         return(1);
      }

      maplay_args->position_change = FALSE;

      filter1->reset();

      if ((which_channels == both) && (mode != single_channel))
      	filter2->reset();

      if (l3decoder)
        	l3decoder->seek_notify();

		// notify the parent of the current position

      maplay_args->musicpos = stream->current_frame();
	 }

	 // is there a change in important parameters?
	 // (bitrate switching is allowed)
	 if (header->layer() != layer)
	 {
		// layer switching is allowed

      if (header->layer() == 3) {
         l3decoder = new LayerIII_Decoder(stream, header,
           											filter1, filter2,
                                          buffer, which_channels);
      } else if (layer == 3) {
      	delete l3decoder;
         l3decoder = NULL;
      }

		layer = header->layer();
	 }

    if (maplay_args->playmode == 4) {
      Sleep(0);
    } else
    {
    if (layer != 3) {

	    Subband *subbands[32];
	    uint32 num_subbands = header->number_of_subbands();
       uint32 i;
       mode = header->mode();

		 // create subband objects:
		 if (layer == 1)
		 {
			if (mode == single_channel)
				for (i = 0; i < num_subbands; ++i)
				  subbands[i] = new SubbandLayer1(i);
			else if (mode == joint_stereo) {
				for (i = 0; i < header->intensity_stereo_bound(); ++i)
				  subbands[i] = new SubbandLayer1Stereo(i);
				for (; i < num_subbands; ++i)
				  subbands[i] = new SubbandLayer1IntensityStereo(i);
			} else {
				for (i = 0; i < num_subbands; ++i)
				  subbands[i] = new SubbandLayer1Stereo(i);
	      }

		 } else { // Layer II
			if (mode == single_channel)
				for (i = 0; i < num_subbands; ++i)
		   	  subbands[i] = new SubbandLayer2(i);
			else if (mode == joint_stereo)
			{
				for (i = 0; i < header->intensity_stereo_bound(); ++i)
			 	    subbands[i] = new SubbandLayer2Stereo(i);
				for (; i < num_subbands; ++i)
				    subbands[i] = new SubbandLayer2IntensityStereo(i);
			} else {
				for (i = 0; i < num_subbands; ++i)
				    subbands[i] = new SubbandLayer2Stereo(i);
         }
	 	 }

  	    // start to read audio data:
	    for (i = 0; i < num_subbands; ++i)
	       subbands[i]->read_allocation(stream, header, crc);

		 if (layer == 2)
			for (i = 0; i < num_subbands; ++i)
				((SubbandLayer2 *)subbands[i])->read_scalefactor_selection(stream,
            																		     crc);

		 if (!crc || header->checksum_ok())
		 {
			// no checksums or checksum ok, continue reading from stream:
			for (i = 0; i < num_subbands; ++i)
				subbands[i]->read_scalefactor(stream, header);

			do
			{
				for (i = 0; i < num_subbands; ++i)
					read_ready = subbands[i]->read_sampledata(stream);

				do
				{
					for (i = 0; i < num_subbands; ++i)
						write_ready = subbands[i]->put_next_sample(which_channels,
   	                                                       filter1, filter2);

					filter1->calculate_pcm_samples(buffer);
					if ((which_channels == both) && (mode != single_channel))
               	filter2->calculate_pcm_samples(buffer);
				} while (!write_ready);
			} while (!read_ready);
         try {
   	      buffer->write_buffer(1);
   	   }
         catch (...) {
            ResultError = mpNoOutput;
            *StopHook = true;
            maplay_Exit(0);
            return(1);
         }
		 } // checksum ok
	 // Jeff : Don't let user know if crc violated.
//	    else
		// Sh*t! Wrong crc checksum in frame!
//		cerr << "WARNING: frame contains wrong crc checksum! (throwing frame away)\n";

       for (i = 0; i < num_subbands; ++i)
			delete subbands[i];

    } else {  // Layer III
	   l3decoder->decode();
      } // Layer III
    FrameRead = header->read_header(stream, &crc);
    // this one is when not paused
    maplay_args->musicpos = stream->current_frame();
    // Update position
    } // not paused
   }
   while (FrameRead);

   // notify the parent of the last frame
   maplay_args->musicpos = stream->current_frame();
   maplay_args->playmode = 2;
   maplay_Exit(0);
   *StopHook = true;
   return(0);
};

