/* ibitstr.cpp

	Input bitstream class declarations */

#ifndef BITSTREAM_H
#define BITSTREAM_H

#ifdef __WIN32__
#define STRICT
#include <wtypes.h>
#endif // __WIN32__

#ifdef __WIN32__
#include <systypes.h>
#endif

#include "all.h"

enum e_syncmode { INITIAL_SYNC, STRICT_SYNC };



class Header;	// forward declaration so we can use the type

const uint32 bufferintsize = 433;
	// max. 1730 bytes per frame: 144 * 384kbit/s / 32000 Hz + 2 Bytes CRC

// Class to extract bitstrings from files:
class Ibitstream
{

private:

#ifdef __WIN32__
  HANDLE FH;
#else
  // variables to access files, like file descriptors
  int fd;
#endif

  uint32	buffer[bufferintsize];
  uint32	framesize;		// number of valid bytes in buffer
  uint32	*wordpointer;	// position of next unsigned int for get_bits()
  uint32	bitindex;		// number (0-31, from MSB to LSB) of next bit for get_bits()
  uint32 syncword;
  bool   single_ch_mode;

  int32  current_frame_number;

public:
  int32 last_frame_number;
  bool nonseekable;
  bool from_res;
  void* stream_handle;
  ResCloseStream ClSProcVar;
  ResReadStream RSProcVar;
  ResSetPointer RSPProcVar;
  ResGetSize RGSProcVar;
  ResRestartStream RSSProcVar;
  void* playerobj;

  Ibitstream(const char *filename);
  Ibitstream(ResCreateStream CSProc,
             ResCloseStream ClSProc,
             ResRestartStream RSSProc,
             ResReadStream RSProc,
             ResSetPointer RSPProc,
             ResGetSize RGSProc,
             void* object);
  ~Ibitstream();

  bool restart();

  bool	get_header(uint32 *headerstring , enum e_syncmode syncmode);
		// get next 32 bits from bitstream in an unsigned int,
		// returned value False => end of stream
  bool	read_frame(uint32 bytesize);
		// fill buffer with data from bitstream, returned value False => end of stream
  uint32	get_bits(uint32 number_of_bits);
		// read bits (1 <= number_of_bits <= 16) from buffer into the lower bits
		// of an unsigned int. The LSB contains the latest read bit of the stream.

  void   set_syncword(uint32 syncword0);
  		// Set the word we want to sync the header to, in
      // Big-Endian byte order

  int32 current_frame() { return(current_frame_number); }

  uint32 file_size();
		// Returns the size, in bytes, of the input file.

  // Stream searching routines (Jeff Tsay)

  int32  last_frame();

  bool   seek(int32 frames, int32 frame_size);
		// Seeks to frames

  bool   seekbytes(int32 bytes, int offset);

  bool   seek_pad(int32 frames, int32 frame_size,
  						Header *header, uint32 *offset);
		// Seeks frames for 44.1 or 22.05 kHz (padded) files

};

#endif
