/*	header.cpp

	Implementation of MPEG header class

 */

#ifndef GUI
#include <iostream.h>
#endif  // GUI

#include "header.h"

const uint32 Header::frequencies[2][4] =
{{22050, 24000, 16000, 1},
 {44100, 48000, 32000, 1}};

Header::Header()
{
  	framesize = 0;
   nSlots    = 0;
  	crc       = NULL;
   offset    = NULL;
   initial_sync = FALSE;
}

Header::~Header()
{
	delete [] offset;
}

bool Header::read_header(Ibitstream *stream, Crc16 **crcp)
{
  uint32 headerstring, channel_bitrate;

  if (!initial_sync) {

  	if (!stream->get_header(&headerstring, INITIAL_SYNC))
	 	return(FALSE);

  	h_version = (e_version) ((headerstring >> 19) & 1);

   if ((h_sample_frequency = (e_sample_frequency)
                             ((headerstring >> 10) & 3)) == 3)
   {
// report error - not supported header
     return(FALSE);
   }

   stream->set_syncword(headerstring & 0xFFF80CC0);

   initial_sync = TRUE;

  } else {

	  	if (!stream->get_header(&headerstring, STRICT_SYNC))
		 	return(FALSE);
  } // initial_sync

/*  if ((h_layer = (headerstring >> 17) & 3) == 0)
  {
	 cerr << "unknown layer identifier found!\n";
	 exit (1);
  }
  h_layer = 4 - h_layer;		// now 1 means Layer I and 3 means Layer III   */

  h_layer   = 4 - (headerstring >> 17) & 3;

  h_protection_bit = (headerstring >> 16) & 1;


/*  if ((h_bitrate_index = (headerstring >> 12) & 0xF) == 15)
  {
	 cerr << "unknown bitrate index found!\n";
	 exit (1);
  }           */
/*  if (!h_bitrate_index)
  {
	 cerr << "free format not yet implemented!\n";
	 exit (1);
  } */

  h_bitrate_index  = (headerstring >> 12) & 0xF;

  h_padding_bit = (headerstring >> 9) & 1;
  h_mode        = (e_mode)((headerstring >> 6) & 3);

/*  if (h_layer == 2)
	 // testing validity of mode and bitrate:
	 if ((((h_bitrate_index >= 1 && h_bitrate_index <= 3) || h_bitrate_index == 5) &&
	 h_mode != single_channel) ||
	(h_bitrate_index >= 11 && h_mode == single_channel))
	 {
		cerr << "illegal combination of mode and bitrate in a layer II stream:\n"
			"  mode: " << mode_string ()
		<< "\n  bitrate: " << bitrate_string () << '\n';
		exit (1);
	 } */

  h_mode_extension = (headerstring >> 4) & 3;

  if (h_mode == joint_stereo)
	 h_intensity_stereo_bound = (h_mode_extension << 2) + 4;
  else
	 h_intensity_stereo_bound = 0;		// should never be used

  h_copyright = (bool) ((headerstring >> 3) & 1);
  h_original  = (bool) ((headerstring >> 2) & 1);

  // calculate number of subbands:
  if (h_layer == 1)
	 h_number_of_subbands = 32;
  else
  {
	 channel_bitrate = h_bitrate_index;

	 // calculate bitrate per channel:
	 if (h_mode != single_channel)
		if (channel_bitrate == 4)
			channel_bitrate = 1;
		else
			channel_bitrate -= 4;

	 if ((channel_bitrate == 1) || (channel_bitrate == 2))
		if (h_sample_frequency == thirtytwo)
			h_number_of_subbands = 12;
		else
			h_number_of_subbands = 8;
	 else
		if ((h_sample_frequency == fourtyeight) || ((channel_bitrate >= 3) &&
      													  	  (channel_bitrate <= 5)))
			h_number_of_subbands = 27;
		else
			h_number_of_subbands = 30;
  }

  if (h_intensity_stereo_bound > h_number_of_subbands)
     h_intensity_stereo_bound = h_number_of_subbands;


  // calculate framesize and nSlots
	calculate_framesize();

  // read framedata:
  if (stream->read_frame(framesize) == FALSE)
     return(FALSE);

  if (!h_protection_bit)
  {
	 // frame contains a crc checksum
	 checksum = (uint16) stream->get_bits(16);
	 if (!crc)
       crc = new Crc16;
	 crc->add_bits(headerstring, 16);
	 *crcp = crc;
  }
  else
	 *crcp = NULL;

#ifdef SEEK_STOP
  if (h_sample_frequency == fourtyfour_point_one) {

	 if (!offset) {

    	uint32 max = max_number_of_frames(stream);

		offset = new uint32[max];

      for(uint32 i=0; i<max; i++)
      	offset[i] = 0;
    }

    {
     int32 cf = stream->current_frame();
     int32 lf = stream->last_frame();
	  if ((cf > 0) && (cf == lf)) {
		   offset[cf] = offset[cf-1] + h_padding_bit;
     } else {
  	      offset[0] = h_padding_bit;
     }
    }
  }
#endif // SEEK_STOP

  return(TRUE);
}

  static const int32 bitrates[2][3][16] = {
  {{0 /*free format*/, 32000, 48000, 56000, 64000, 80000, 96000,
    112000, 128000, 144000, 160000, 176000, 192000 ,224000, 256000, 0},
   {0 /*free format*/, 8000, 16000, 24000, 32000, 40000, 48000,
    56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0},
   {0 /*free format*/, 8000, 16000, 24000, 32000, 40000, 48000,
    56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}},
  {{0 /*free format*/, 32000, 64000, 96000, 128000, 160000, 192000,
	 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0},
	{0 /*free format*/, 32000, 48000, 56000, 64000, 80000, 96000,
	 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0},
	{0 /*free format*/, 32000, 40000, 48000, 56000, 64000, 80000,
	 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}}
  };

uint32 Header::bitrate()
{
  return(bitrates[h_version][h_layer-1][h_bitrate_index]);
}

uint32 Header::calculate_framesize()
// calculates framesize in bytes excluding header size
{
  if (h_layer == 1) {
	 framesize = (12 * bitrates[h_version][0][h_bitrate_index]) /
                 frequencies[h_version][h_sample_frequency];

	 if (h_padding_bit) framesize++;

	 framesize <<= 2;		// one slot is 4 bytes long

    nSlots = 0;

  } else {

	 framesize = (144 * bitrates[h_version][h_layer - 1][h_bitrate_index]) /
                 frequencies[h_version][h_sample_frequency];

	 if (h_version == MPEG2_LSF)
    	framesize >>= 1;

	 if (h_padding_bit) framesize++;

	 // Layer III slots
	 if (h_layer == 3) {

       if (h_version == MPEG1) {

			 nSlots = framesize - ((h_mode == single_channel) ? 17 : 32) // side info size
									  -  (h_protection_bit ? 0 : 2) 		       // CRC size
									  - 4; 								             // header size
       } else {  // MPEG-2 LSF
        	 nSlots = framesize - ((h_mode == single_channel) ?  9 : 17) // side info size
						   		  -  (h_protection_bit ? 0 : 2) 		       // CRC size
									  - 4; 								             // header size
       }
	 } else {
    	 nSlots = 0;
    }
  }

  framesize -= 4;             // subtract header size

  return(framesize);
}

#ifdef SEEK_STOP
// Stream searching routines
bool Header::stream_seek(Ibitstream *stream, uint32 seek_pos)
{
   return ((h_sample_frequency == fourtyfour_point_one) ?
			  stream->seek_pad(seek_pos, framesize - h_padding_bit,
                            this, offset) :
     		  stream->seek(seek_pos, framesize));
}
#endif

uint32 Header::max_number_of_frames(Ibitstream *stream)
// Returns the maximum number of frames in the stream
{
	  return(stream->file_size() / (framesize + 4 - h_padding_bit));
}

uint32 Header::min_number_of_frames(Ibitstream *stream)
// Returns the minimum number of frames in the stream
{
	  return(stream->file_size() / (framesize + 5 - h_padding_bit));
}

real Header::ms_per_frame()
{
	static real ms_per_frame_array[3][3] = {{8.707483f,  8.0f, 12.0f},
												       {26.12245f, 24.0f, 36.0f},
   	                                     {26.12245f, 24.0f, 36.0f}};

	return(ms_per_frame_array[h_layer-1][h_sample_frequency]);
}
                                           
real Header::total_ms(Ibitstream *stream)
{
	return(max_number_of_frames(stream) * ms_per_frame());
}

