/* args.h

	An abstract class to pass values to maplay and other worker
   threads.

	From the Win32 API, we can only pass one 32-bit value to a thread. This will
   be a pointer to a object of this class. The Args class contains the seeking
   control variables needed for both MPEG and MCI files.

   Added stop and done variables and functions for terminating the
   threads from outside.

   This class should be used to pass arguments to maplay(),
   and to initialize the Obuffer's. */

#ifndef ARGS_H
#define ARGS_H

#ifdef __WIN32__
#define STRICT
#include <wtypes.h>
#include <windows.h>
enum e_output { O_WAVEMAPPER, O_DIRECTSOUND, O_WAVEFILE };
#endif // __WIN32__

#include "all.h"
#include "ibitstr.h"
#include "header.h"
#include <classlib/thread.h>

class Args
{
	public:

	Args()
   {

#ifdef SEEK_STOP
      stop             = false;
      pause            = false;
      done             = false;
      nonseekable      = false;
      desired_position = 0;
      position_change  = false;
#endif // SEEK_STOP

   }

	virtual ~Args() {}

   volatile bool  stop;
   volatile bool  pause;
   volatile bool  done;
           bool  nonseekable;
  	volatile int32 desired_position;
	volatile bool  position_change;
   HANDLE         PlayMutex;
};

// A class to contain arguments for maplay.
class MPEG_Args : public Args
{
private:
   volatile uint32 h_errorcode;
public:
	Ibitstream *stream;
   Header *MPEGheader;

	MPEG_Args()
	{
		stream = NULL;
		MPEGheader = NULL;
		which_c = both;
	   use_own_scalefactor = FALSE;
   	scalefactor = 32768.0;

#ifdef __WIN32__
  		phwo = NULL;
      output_mode = O_WAVEMAPPER;
#endif // __WIN32__

  	}

	enum e_channels which_c;

   bool use_own_scalefactor;
   float scalefactor;

   uint32 startpos;   // start and finish positions (in frames)
   uint32 endpos;
volatile uint32 musicpos;  // current position (in frames)
volatile bool from_res; 

	TThread::TPriority playpriority;

volatile uint32 playmode; // -1 - not initialized, 0 - closed, 1 - opened, 2- stopped
								  // 3 - playing, 4 - paused

uint32 errorcode()
{
	uint32 ec;
   ec = h_errorcode;
   h_errorcode = 0;
   return (ec);
}

#ifdef __WIN32__
	HWAVEOUT *phwo;
   enum e_output output_mode;
	char output_filename[260];
#endif // __WIN32__

	~MPEG_Args() { }
};

#ifdef __WIN32__
// A class to hold the arguments for MCI playing.
class MCI_Args : public Args {

public:
	MCI_Args()
	{
		playing = FALSE;
      CDMode  = FALSE;
      final_track = FALSE;
	}

   ~MCI_Args() { }

   bool CDMode;
   bool final_track;
   char this_track_str[8];
   char next_track_str[8];

	volatile bool playing;
};
#endif // __WIN32__

#endif // ARGS_H
