/*  all.h

	 Data types used throughout the maplay code. */

#ifndef ALL_H
#define ALL_H

#ifdef __WIN32__
#include <wtypes.h>
#endif

// callback resource functions

typedef void _stdcall (*ResCreateStream)(void* oops, bool* cant_seek, void* res);
typedef void _stdcall (*ResCloseStream)(void* oops,  void* handle);
typedef void _stdcall (*ResRestartStream)(void* oops,  void* handle, bool* res);
typedef void _stdcall (*ResReadStream)(void* oops, void* handle,
                                        void* read_buffer,
                                        DWORD nNumberOfBytesToRead,
                                        DWORD* nNumberOfBytesRead, bool* res);
typedef void _stdcall (*ResSetPointer)(void* oops, void* handle,
                                       DWORD NumBytes,
                                       DWORD MoveMethod, DWORD* res);

typedef void _stdcall (*ResGetSize)(void* oops, void* handle, DWORD* NewPos);

// real number
typedef float real;		// float should be enough

// Signed & unsigned integers, define SIXTEEN_BIT_COMPILER if the
// default integer size is 16 bits

#ifdef SIXTEEN_BIT_COMPILER
typedef long int32;							// 32 Bit signed integer
typedef unsigned long  uint32;         // 32 Bit unsigned integer
typedef int int16;		               // 16 Bit signed integer
typedef unsigned int	uint16;		      // 16 Bit unsigned integer
#else
// typedef int int32;							// 32 Bit signed integer
// typedef unsigned uint32;               // 32 Bit unsigned integer
typedef   signed short  int16;	      // 16 Bit signed integer
typedef unsigned short uint16;	      // 16 Bit unsigned integer
#endif // SIXTEEN_BIT_COMPILER

#ifdef ULAW
typedef unsigned char	ulawsample;	// u-law byte
#endif // ULAW

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif // !TRUE

enum e_channels { both, left, right, downmix };

#endif // ALL_H
