{+--------------------------------------------------------------------------+
 | Class:       TmFilePointer
 | Created:     8.97
 | Author:      Martin Waldenburg
 | Description:  Gives access to a mapped file pointer.
 | Version:     1.0
 | Placed to the Public Domain;
 |
 | DISCLAIMER:
 |
 | THIS SOFTWARE IS PROVIDED BY THE AUTHOR 'AS IS'.
 |
 | ALL EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 | THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 | PARTICULAR PURPOSE ARE DISCLAIMED.
 |
 | IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 | INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 | (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 | OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 | INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 | WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 | NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 | THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 |
 |  Martin.Waldenburg@T-Online.de

+--------------------------------------------------------------------------+}

unit mwFilePointer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TmFilePointer = class(TObject)
  private
    fFileHandle: THandle;
    fMapHandle: THandle;
    fFilePointer: Pointer;
    fFileSize: LongInt;
    fFileName: String;
    function CloseMap: Boolean;
    function OpenMap(FileName: PChar): Boolean;
    procedure SetFileName(const Value: String);
    { Private-Deklarationen}
  protected
    { Protected-Deklarationen}
  public
    constructor Create;
    destructor Destroy; override;
    property Ptr: Pointer read fFilePointer;
    property Size: LongInt read fFileSize;
    property FileName: String read fFileName write SetFileName;
  published
    { Published-Deklarationen }
  end;

implementation

constructor TmFilePointer.Create;
begin
  inherited Create;
end;

destructor TmFilePointer.Destroy;
begin
  CloseMap;
  inherited Destroy;
end;

function TmFilePointer.CloseMap: Boolean;
begin
  Result:=UnmapViewOfFile(fFilePointer);
  fFilePointer:=nil;
  CloseHandle(fMapHandle);
  FileClose(fFileHandle);
end;

function TmFilePointer.OpenMap(FileName: PChar): Boolean;
var
  HSize: Integer;
begin
  Result:=False;
  fFileHandle:=CreateFile(FileName, GENERIC_READ OR GENERIC_WRITE, FILE_SHARE_READ
    OR FILE_SHARE_WRITE, NIL, OPEN_EXISTING, 0, 0);
  if fFileHandle>0 then
  begin
    Result:= True;
    fMapHandle:=CreateFileMapping(fFileHandle, NIL, PAGE_READWRITE OR SEC_NOCACHE, 0, 0, NIL)
  end;
  if fMapHandle>0 then
    fFilePointer:=MapViewOfFile(fMapHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0)
  else Result:=False;
  if Result then fFileSize:=GetFileSize(fFileHandle, @HSize)else fFileSize:=0;
end;

procedure TmFilePointer.SetFileName(const Value: String);
begin
  fFileName := Value;
  CloseMap;
  OpenMap(PChar(Value));
end;

end.
