unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, mwPasLex,
  StdCtrls, mwFastTime, ExtCtrls, mwPasLexTypes, mwFilePointer;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Time1: TmwFastTime;
    Panel1: TPanel;
    Button1: TButton;
    ListBox1: TListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    FileP: TmFilePointer;
    Lex: TmwPasLex;
    aChar: Char;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FileP := TmFilePointer.Create;
  Lex := TmwPasLex.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Lex.Free;
  FileP.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  OpenDialog1.Options := OpenDialog1.Options - [ofAllowMultiSelect];
  if OpenDialog1.Execute then
  begin
    ListBox1.Clear;
    Time1.Start;
    FileP.FileName := OpenDialog1.FileName;
    Lex.Origin := FileP.Ptr;
    ListBox1.Items.BeginUpdate;
    while Lex.TokenID in [ptAnsiComment, ptBorComment, ptCRLF, ptCRLFCo,
      ptSlashesComment, ptSpace] do Lex.Next;
    while (Lex.TokenID <> ptTheEnd) and (Lex.RunPos < FileP.Size) do
    begin
      Case Lex.TokenID of
        ptIdentifier: ListBox1.Items.Add(Lex.Token + '               ' +
            ptTokenName(Lex.TokenID) + '               ' + ptTokenName(Lex.ExID));
      else ListBox1.Items.Add(Lex.Token + '               ' + ptTokenName(Lex.TokenID));
      end;
      Lex.NextNoJunk;
    end;
    ListBox1.Items.Add(Lex.Token + '               ' + ptTokenName(Lex.TokenID));
    //ListBox1.Sorted:= True;
    ListBox1.Items.EndUpdate;
    Time1.Stop;
    Form1.Caption := Time1.ElapsedTime + '  Count: ' + IntToStr(ListBox1.Items.Count);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Count: Integer;
  I: Integer;
  FileName: String;
begin
  OpenDialog1.Options := OpenDialog1.Options + [ofAllowMultiSelect];
  if OpenDialog1.Execute then
  begin
    ListBox1.Clear;
    Count := 0;
    Time1.Start;
    I := 0;
    while I < OpenDialog1.Files.Count do
    begin
      FileName := ExtractFileName(OpenDialog1.Files[I]);
      FileP.FileName := FileName;
      Lex.Origin := FileP.Ptr;
      inc(Count);
      while (Lex.TokenID <> ptTheEnd) and (Lex.RunPos < FileP.Size) do
      begin
        Lex.Next;
        inc(Count);
      end;
      inc(I);
    end;
    Time1.Stop;
    Form1.Caption := Time1.ElapsedTime + '  TokenCount: ' + IntToStr(Count) +
      '  UnitCount: ' + IntToStr(OpenDialog1.Files.Count);
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  I: Integer;
  FileName: String;
begin
  aChar := #0;
  OpenDialog1.Options := OpenDialog1.Options + [ofAllowMultiSelect];
  if OpenDialog1.Execute then
  begin
    ListBox1.Clear;
    Time1.Start;
    ListBox1.Items.BeginUpdate;
    I := 0;
    while I < OpenDialog1.Files.Count do
    begin
      FileName := ExtractFileName(OpenDialog1.Files[I]);
      FileP.FileName := FileName;
      Lex.Origin := FileP.Ptr;
      while (Lex.TokenID <> ptTheEnd) and (Lex.RunPos < FileP.Size) do
      begin
        Case Lex.TokenID of
          ptClass:
            begin
              ListBox1.Items.Add(Lex.LastIdentifier + ' :          ' + FileName +
                '       at Line: ' + IntToStr(Lex.LineNumber + 1));
            end;
          ptClassForward:
            begin
              ListBox1.Items.Add(Lex.LastIdentifier + ' :          ' + FileName +
                '        at Line: ' + IntToStr(Lex.LineNumber + 1) +
                '   Class forward declaration');
            end;
          ptClassOf:
            begin
              ListBox1.Items.Add(Lex.LastIdentifier + ' :          ' + FileName +
                '        at Line: ' + IntToStr(Lex.LineNumber + 1) +
                '   Class reference');
            end;
        end;
        Lex.Next;
      end;
      inc(I);
    end;
    //ListBox1.Sorted := True;
    ListBox1.Items.EndUpdate;
    Time1.Stop;
    Form1.Caption := Time1.ElapsedTime + '  ClassCount: ' + IntToStr(ListBox1.Items.Count) +
      '  UnitCount: ' + IntToStr(OpenDialog1.Files.Count);
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  Count: Integer;
  I: Integer;
  FileName: String;
begin
  OpenDialog1.Options := OpenDialog1.Options + [ofAllowMultiSelect];
  if OpenDialog1.Execute then
  begin
    ListBox1.Clear;
    Count := 0;
    Time1.Start;
    ListBox1.Items.BeginUpdate;
    I := 0;
    while I < OpenDialog1.Files.Count do
    begin
      FileName := ExtractFileName(OpenDialog1.Files[I]);
      FileP.FileName := FileName;
      Lex.Origin := FileP.Ptr;
      while (Lex.TokenID <> ptTheEnd) and (Lex.RunPos < FileP.Size) do
      begin
        if Lex.TokenID in
          [
          //ptCompDirect,
        ptDefineDirect,
          ptEndifDirect,
          ptElseDirect,
          ptIfdefDirect,
          ptIfNdefDirect,
          ptIfOptDirect,
          ptIncludeDirect,
          ptResourceDirect,
          ptUndefDirect
          ]
          then
        begin
          ListBox1.Items.Add(Lex.Token + ' :          ' + FileName + '   at Line: ' +
            IntToStr(Lex.LineNumber + 1) + '      Param: ' + Lex.DirectiveParam);
          inc(Count);
        end;
        Lex.Next;
      end;
      inc(I);
    end;
    //ListBox1.Sorted:= True;
    ListBox1.Items.EndUpdate;
    Time1.Stop;
    Form1.Caption := Time1.ElapsedTime + '  Count: ' + IntToStr(Count) +
      '  UnitCount: ' + IntToStr(OpenDialog1.Files.Count);
  end;
end;

end.

