unit mwPasLexTypes;

interface
type
  TCommentState = (csAnsi, csBor, csNo);

  TptTokenKind = (
    ptAbsolute,
    ptAbstract,
    ptAddressOp,
    ptAmpersand,
    ptAnd,
    ptAnsiComment,
    ptAnsiString,
    ptArray,
    ptArrayOf,
    ptAs,
    ptAsciiChar,
    ptAsm,
    ptAssembler,
    ptAssign,
    ptAutomated,
    ptBegin,
    ptBoolean,
    ptBorComment,
    ptBraceClose,
    ptBraceOpen,
    ptByte,
    ptByteBool,
    ptCardinal,
    ptCase,
    ptCdecl,
    ptClass,
    ptClassForward,
    ptClassFunction,
    ptClassOf,
    ptClassProcedure,
    ptColon,
    ptComma,
    ptComp,
    ptCompDirect,
    ptConst,
    ptConstructor,
    ptContains,
    ptCR,
    ptCRLF,
    ptCRLFCo,
    ptCurrency,
    ptDefault,
    ptDefineDirect,
    ptDestructor,
    ptDispid,
    ptDispinterface,
    ptDiv,
    ptDo,
    ptDotDot,
    ptDouble,
    ptDoubleAddressOp,
    ptDownto,
    ptDynamic,
    ptElse,
    ptElseDirect,
    ptEnd,
    ptEndIfDirect,
    ptEqual,
    ptError,
    ptExcept,
    ptExport,
    ptExports,
    ptExtended,
    ptExternal,
    ptFar,
    ptFile,
    ptFileOf,
    ptFinalization,
    ptFinally,
    ptFloat,
    ptFor,
    ptForward,
    ptFunction,
    ptGoto,
    ptGreater,
    ptGreaterEqual,
    ptIdent,
    ptIdentifier,
    ptIf,
    ptIfDefDirect,
    ptIfNDefDirect,
    ptIfOptDirect,
    ptImplementation,
    ptImplements,
    ptIn,
    ptIncludeDirect,
    ptIndex,
    ptInherited,
    ptInitialization,
    ptInline,
    ptInt64,
    ptInteger,
    ptIntegerConst,
    ptInterface,
    ptInterfaceStart,
    ptIs,
    ptLabel,
    ptLF,
    ptLibrary,
    ptLongBool,
    ptLongint,
    ptLongword,
    ptLower,
    ptLowerEqual,
    ptMessage,
    ptMinus,
    ptMod,
    ptName,
    ptNear,
    ptNil,
    ptNodefault,
    ptNot,
    ptNotEqual,
    ptNull,
    ptNumber,
    ptObject,
    ptOf,
    ptOfObject,
    ptOr,
    ptOut,
    ptOverload,
    ptOverride,
    ptPackage,
    ptPacked,
    ptPascal,
    ptPlus,
    ptPoint,
    ptPointerSymbol,
    ptPrivate,
    ptProcedure,
    ptProgram,
    ptProperty,
    ptProtected,
    ptPublic,
    ptPublished,
    ptRaise,
    ptRead,
    ptReadonly,
    ptReal,
    ptReal48,
    ptRecord,
    ptRegister,
    ptReintroduce,
    ptRepeat,
    ptRequires,
    ptResident,
    ptResourceDirect,
    ptResourcestring,
    ptRoundClose,
    ptRoundOpen,
    ptSafecall,
    ptSemiColon,
    ptSet,
    ptSetOf,
    ptShl,
    ptShortint,
    ptShortString,
    ptShr,
    ptSingle,
    ptSlash,
    ptSlashesComment,
    ptSmallint,
    ptSpace,
    ptSquareClose,
    ptSquareOpen,
    ptStar,
    ptStdcall,
    ptStored,
    ptString,
    ptStringConst,
    ptStringresource,
    ptSymbol,
    ptTheEnd,
    ptThen,
    ptThreadvar,
    ptTo,
    ptTry,
    ptType,
    ptUndefDirect,
    ptUnit,
    ptUnknown,
    ptUntil,
    ptUses,
    ptVar,
    ptVirtual,
    ptWhile,
    ptWideString,
    ptWith,
    ptWord,
    ptWordBool,
    ptWrite,
    ptWriteonly,
    ptXor);

  TStatusRecord = Record
    CommentState: TCommentState;
    ExID: TptTokenKind;
    LastIdentPos: Integer;
    LastNoSpace: TptTokenKind;
    LastNoSpacePos: Integer;
    LineNumber: Integer;
    LinePos: Integer;
    Origin: PChar;
    RoundCount: Integer;
    RunPos: Integer;
    SquareCount: Integer;
    TokenPos: Integer;
    TokenID: TptTokenKind;
  end;

function ptTokenName(Value: TptTokenKind): String;

implementation

function ptTokenName(Value: TptTokenKind): String;
begin
  Case Value of
      ptAbsolute: Result:= 'ptAbsolute';
      ptAbstract: Result:= 'ptAbstract';
      ptAddressOp: Result:= 'ptAddressOp';
      ptAmpersand: Result:= 'ptAmpersand';
      ptAnd: Result:= 'ptAnd';
      ptAnsiComment: Result:= 'ptAnsiComment';
      ptAnsiString: Result:= 'ptAnsiString';
      ptArray: Result:= 'ptArray';
      ptArrayOf: Result:= 'ptArrayOf';
      ptAs: Result:= 'ptAs';
      ptAsciiChar: Result:= 'ptAsciiChar';
      ptAsm: Result:= 'ptAsm';
      ptAssembler: Result:= 'ptAssembler';
      ptAssign: Result:= 'ptAssign';
      ptAutomated: Result:= 'ptAutomated';
      ptBegin: Result:= 'ptBegin';
      ptBoolean: Result:= 'ptBoolean';
      ptBorComment: Result:= 'ptBorComment';
      ptBraceClose: Result:= 'ptBraceClose';
      ptBraceOpen: Result:= 'ptBraceOpen';
      ptByte: Result:= 'ptByte';
      ptByteBool: Result:= 'ptByteBool';
      ptCardinal: Result:= 'ptCardinal';
      ptCase: Result:= 'ptCase';
      ptCdecl: Result:= 'ptCdecl';
      ptClass: Result:= 'ptClass';
      ptClassForward: Result:= 'ptClassForward';
      ptClassFunction: Result:= 'ptClassFunction';
      ptClassOf: Result:= 'ptClassOf';
      ptClassProcedure: Result:= 'ptClassProcedure';
      ptColon: Result:= 'ptColon';
      ptComma: Result:= 'ptComma';
      ptComp: Result:= 'ptComp';
      ptCompDirect: Result:= 'ptCompDirect';
      ptConst: Result:= 'ptConst';
      ptConstructor: Result:= 'ptConstructor';
      ptContains: Result:= 'ptContains';
      ptCR: Result:= 'ptCR';
      ptCRLF: Result:= 'ptCRLF';
      ptCRLFCo: Result:= 'ptCRLFCo';
      ptCurrency: Result:= 'ptCurrency';
      ptDefault: Result:= 'ptDefault';
      ptDefineDirect: Result:= 'ptDefineDirect';
      ptDestructor: Result:= 'ptDestructor';
      ptDispid: Result:= 'ptDispid';
      ptDispinterface: Result:= 'ptDispinterface';
      ptDiv: Result:= 'ptDiv';
      ptDo: Result:= 'ptDo';
      ptDotDot: Result:= 'ptDotDot';
      ptDouble: Result:= 'ptDouble';
      ptDoubleAddressOp: Result:= 'ptDoubleAddressOp';
      ptDownto: Result:= 'ptDownto';
      ptDynamic: Result:= 'ptDynamic';
      ptElse: Result:= 'ptElse';
      ptElseDirect: Result:= 'ptElseDirect';
      ptEnd: Result:= 'ptEnd';
      ptEndIfDirect: Result:= 'ptEndIfDirect';
      ptEqual: Result:= 'ptEqual';
      ptError: Result:= 'ptError';
      ptExcept: Result:= 'ptExcept';
      ptExport: Result:= 'ptExport';
      ptExports: Result:= 'ptExports';
      ptExtended: Result:= 'ptExtended';
      ptExternal: Result:= 'ptExternal';
      ptFar: Result:= 'ptFar';
      ptFile: Result:= 'ptFile';
      ptFileOf: Result:= 'ptFileOf';
      ptFinalization: Result:= 'ptFinalization';
      ptFinally: Result:= 'ptFinally';
      ptFloat: Result:= 'ptFloat';
      ptFor: Result:= 'ptFor';
      ptForward: Result:= 'ptForward';
      ptFunction: Result:= 'ptFunction';
      ptGoto: Result:= 'ptGoto';
      ptGreater: Result:= 'ptGreater';
      ptGreaterEqual: Result:= 'ptGreaterEqual';
      ptIdent: Result:= 'ptIdent';
      ptIdentifier: Result:= 'ptIdentifier';
      ptIf: Result:= 'ptIf';
      ptIfDefDirect: Result:= 'ptIfDefDirect';
      ptIfNDefDirect: Result:= 'ptIfNDefDirect';
      ptIfOptDirect: Result:= 'ptIfOptDirect';
      ptImplementation: Result:= 'ptImplementation';
      ptImplements: Result:= 'ptImplements';
      ptIn: Result:= 'ptIn';
      ptIncludeDirect: Result:= 'ptIncludeDirect';
      ptIndex: Result:= 'ptIndex';
      ptInherited: Result:= 'ptInherited';
      ptInitialization: Result:= 'ptInitialization';
      ptInline: Result:= 'ptInline';
      ptInt64: Result:= 'ptInt64';
      ptInteger: Result:= 'ptInteger';
      ptIntegerConst: Result:= 'ptIntegerConst';
      ptInterface: Result:= 'ptInterface';
      ptInterfaceStart: Result:= 'ptInterfaceStart';
      ptIs: Result:= 'ptIs';
      ptLabel: Result:= 'ptLabel';
      ptLF: Result:= 'ptLF';
      ptLibrary: Result:= 'ptLibrary';
      ptLongBool: Result:= 'ptLongBool';
      ptLongint: Result:= 'ptLongint';
      ptLongword: Result:= 'ptLongword';
      ptLower: Result:= 'ptLower';
      ptLowerEqual: Result:= 'ptLowerEqual';
      ptMessage: Result:= 'ptMessage';
      ptMinus: Result:= 'ptMinus';
      ptMod: Result:= 'ptMod';
      ptName: Result:= 'ptName';
      ptNear: Result:= 'ptNear';
      ptNil: Result:= 'ptNil';
      ptNodefault: Result:= 'ptNodefault';
      ptNot: Result:= 'ptNot';
      ptNotEqual: Result:= 'ptNotEqual';
      ptNull: Result:= 'ptNull';
      ptNumber: Result:= 'ptNumber';
      ptObject: Result:= 'ptObject';
      ptOf: Result:= 'ptOf';
      ptOfObject: Result:= 'ptOfObject';
      ptOr: Result:= 'ptOr';
      ptOut: Result:= 'ptOut';
      ptOverload: Result:= 'ptOverload';
      ptOverride: Result:= 'ptOverride';
      ptPackage: Result:= 'ptPackage';
      ptPacked: Result:= 'ptPacked';
      ptPascal: Result:= 'ptPascal';
      ptPlus: Result:= 'ptPlus';
      ptPoint: Result:= 'ptPoint';
      ptPointerSymbol: Result:= 'ptPointerSymbol';
      ptPrivate: Result:= 'ptPrivate';
      ptProcedure: Result:= 'ptProcedure';
      ptProgram: Result:= 'ptProgram';
      ptProperty: Result:= 'ptProperty';
      ptProtected: Result:= 'ptProtected';
      ptPublic: Result:= 'ptPublic';
      ptPublished: Result:= 'ptPublished';
      ptRaise: Result:= 'ptRaise';
      ptRead: Result:= 'ptRead';
      ptReadonly: Result:= 'ptReadonly';
      ptReal: Result:= 'ptReal';
      ptReal48: Result:= 'ptReal48';
      ptRecord: Result:= 'ptRecord';
      ptRegister: Result:= 'ptRegister';
      ptReintroduce: Result:= 'ptReintroduce';
      ptRepeat: Result:= 'ptRepeat';
      ptRequires: Result:= 'ptRequires';
      ptResident: Result:= 'ptResident';
      ptResourceDirect: Result:= 'ptResourceDirect';
      ptResourcestring: Result:= 'ptResourcestring';
      ptRoundClose: Result:= 'ptRoundClose';
      ptRoundOpen: Result:= 'ptRoundOpen';
      ptSafecall: Result:= 'ptSafecall';
      ptSemiColon: Result:= 'ptSemiColon';
      ptSet: Result:= 'ptSet';
      ptSetOf: Result:= 'ptSetOf';
      ptShl: Result:= 'ptShl';
      ptShortint: Result:= 'ptShortint';
      ptShortString: Result:= 'ptShortString';
      ptShr: Result:= 'ptShr';
      ptSingle: Result:= 'ptSingle';
      ptSlash: Result:= 'ptSlash';
      ptSlashesComment: Result:= 'ptSlashesComment';
      ptSmallint: Result:= 'ptSmallint';
      ptSpace: Result:= 'ptSpace';
      ptSquareClose: Result:= 'ptSquareClose';
      ptSquareOpen: Result:= 'ptSquareOpen';
      ptStar: Result:= 'ptStar';
      ptStdcall: Result:= 'ptStdcall';
      ptStored: Result:= 'ptStored';
      ptString: Result:= 'ptString';
      ptStringConst: Result:= 'ptStringConst';
      ptStringresource: Result:= 'ptStringresource';
      ptSymbol: Result:= 'ptSymbol';
      ptTheEnd: Result:= 'ptTheEnd';
      ptThen: Result:= 'ptThen';
      ptThreadvar: Result:= 'ptThreadvar';
      ptTo: Result:= 'ptTo';
      ptTry: Result:= 'ptTry';
      ptType: Result:= 'ptType';
      ptUndefDirect: Result:= 'ptUndefDirect';
      ptUnit: Result:= 'ptUnit';
      ptUnknown: Result:= 'ptUnknown';
      ptUntil: Result:= 'ptUntil';
      ptUses: Result:= 'ptUses';
      ptVar: Result:= 'ptVar';
      ptVirtual: Result:= 'ptVirtual';
      ptWhile: Result:= 'ptWhile';
      ptWideString: Result:= 'ptWideString';
      ptWith: Result:= 'ptWith';
      ptWord: Result:= 'ptWord';
      ptWordBool: Result:= 'ptWordBool';
      ptWrite: Result:= 'ptWrite';
      ptWriteonly: Result:= 'ptWriteonly';
      ptXor: Result:= 'ptXor';
    end;
end;
end.

