{ Class: TMultiCheckBox and TMultiRadioButton for Delphi 2 and 3 and C++ Builder 1
  Author: CRESTO Sylvain                                   -> version 1.2
  Written: 02/08/97  Modified: 15/11/97
  cresto@mygale.org
  http://www.mygale.org/~cresto

  Information:
  TMultiCheckBox is a descendent of TCheckBox that allows multi-line captions.
  TMultiRadioButton is a descendent of TRadioButton that allows multi-line captions.
  I'm placing it in the public domain.  Do with it as you like!

--------

  Composants: TMultiCheckBox et TMultiRadioButton pour Delphi 2 et 3 et C++ Builder 1
  Auteur: CRESTO Sylvain                                   -> version 1.2
  Ecris Le: 02/08/97  Modifi Le: 15/11/97
  cresto@mygale.org
  http://www.mygale.org/~cresto

  Information:
  TMultiCheckBox est un descendant de TCheckBox qui permet d'utiliser des libells de plusieurs lignes.
  TMultiRadioButton est un descendant de TRadioButton qui permet d'utiliser des libells de plusieurs lignes.
  J'ai plac ces composants dans le domaine publique.  Vous pouvez en faire ce que vous voulez!



}

unit MLCBRB;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMultiCheckBox = class(TCheckBox)
  private
    fMultiLine: Boolean;
    procedure SetMultiLine(Value: Boolean);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property MultiLine: Boolean read fMultiLine write SetMultiLine default True;
  end;

  TMultiRadioButton = class(TRadioButton)
  private
    fMultiLine: Boolean;
    procedure SetMultiLine(Value: Boolean);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property MultiLine: Boolean read fMultiLine write SetMultiLine default True;
  end;


procedure Register;

implementation
{$R MLCBRB.RES}


{  TMultiCheckBox component }
constructor TMultiCheckBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fMultiLine:=true;
end;

procedure TMultiCheckBox.SetMultiLine(Value: Boolean);
begin
  if fMultiLine<>Value then
  begin
    fMultiLine:=Value;
    RecreateWnd;
  end;
end;

procedure TMultiCheckBox.CreateParams(var Params: TCreateParams);
begin
     inherited CreateParams(Params);
     if MultiLine then Params.Style:=Params.Style or BS_MULTILINE or BS_TOP
                  else Params.Style:=Params.Style and not BS_MULTILINE and not BS_TOP;
end;



{  TMultiRadioButton component }
constructor TMultiRadioButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fMultiLine:=true;
end;

procedure TMultiRadioButton.SetMultiLine(Value: Boolean);
begin
  if fMultiLine<>Value then
  begin
    fMultiLine:=Value;
    RecreateWnd;
  end;
end;

procedure TMultiRadioButton.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  if MultiLine then Params.Style:=Params.Style or BS_MULTILINE or BS_TOP
               else Params.Style:=Params.Style and not BS_MULTILINE and not BS_TOP;
end;


procedure Register;
begin
  RegisterComponents('Standard', [TMultiCheckBox]);
  RegisterComponents('Standard', [TMultiRadioButton]);
end;

end.
