unit uBoidEngine;

interface

uses
	Graphics, Classes, uTMovableEngine, uTMovable, uBoids;

type
  TBoidEngine = class(TMovableEngine)
    LineLength			: real;

	  OptimalDistance : real;
    StayInCenter		: real;
  	TooClose 				: real;
	  ReallyClose 		: real;
  	MaxTurnSpeed 		: real;

//    procedure RunStep;
    procedure CopySettingsToBoid(Boid : TBoid);
    procedure CopySettingsToAllBoids;

    constructor Create(iBoidCount : integer; OutputCanvas : TCanvas);
    procedure AdjustMovableCount(iMovableCount : integer);
  end;

implementation

//******************************************************************************
constructor TBoidEngine.Create(iBoidCount : integer; OutputCanvas : TCanvas);
var
  i 				: integer;
  NewBoid 	: TBoid;
begin
	inherited Create(OutputCanvas);

  MaxSpeed := 5;
  MaxSpeedChange := 0.09;
  SensorDistance := 60;

  OptimalDistance := 20;
  TooClose := 19;
  ReallyClose := 12;
  MaxTurnSpeed := 0.05;

  LineLength := 3;

  for i := 1 to iBoidCount do
  begin
  	NewBoid := TBoid.Create(Canvas);
    MovableList.Add(NewBoid);

		CopySettingsToBoid(NewBoid);
  end;
end;

//******************************************************************************
procedure TBoidEngine.CopySettingsToAllBoids;
var
	i : integer;
begin
	for i := 0 to MovableList.Count - 1 do
  	CopySettingsToBoid(TBoid(MovableList[i]));
end;

//******************************************************************************
procedure TBoidEngine.CopySettingsToBoid(Boid : TBoid);
begin
  Boid.MaxSpeed := MaxSpeed;
  Boid.MaxSpeedChange := MaxSpeedChange;
 	Boid.SensorDistance := SensorDistance;

  Boid.OptimalDistance := OptimalDistance;
  Boid.StayInCenter := StayInCenter;
 	Boid.TooClose := TooClose;
  Boid.ReallyClose := ReallyClose;
 	Boid.MaxTurnSpeed := MaxTurnSpeed;
  Boid.LineLength := LineLength;
end;

//******************************************************************************
procedure TBoidEngine.AdjustMovableCount(iMovableCount : integer);
var
	i 					: integer;
	NewBoid 		: TBoid;
begin
  if iMovableCount > MovableList.Count then
  begin
	  for i := MovableList.Count to iMovableCount-1 do
  	begin
	  	NewBoid := TBoid.Create(Canvas);
    	MovableList.Add(NewBoid);

			CopySettingsToBoid(NewBoid);
  	end;
  end else
  while iMovableCount < MovableList.Count do
  begin
    TMovable(MovableList[MovableList.Count-1]).Destroy;
    MovableList.Delete(MovableList.Count-1);
    MovableList.Pack;
  end;
end;
end.
