unit MDIWMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  MDIWallp, StdCtrls, ExtCtrls, Buttons, Menus, Graphics;

type
  TMDIMainForm = class(TForm)
    Wallpaper: TMDIWallpaper;
    MainMenu1: TMainMenu;
    Image1: TMenuItem;
    ImageLoad: TMenuItem;
    OpenDialog: TOpenDialog;
    procedure ImageLoadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MDIMainForm: TMDIMainForm;

implementation

uses MDIWChld;

{$R *.DFM}

procedure TMDIMainForm.ImageLoadClick(Sender: TObject);
begin
  with OpenDialog do
  begin
    if Wallpaper.Picture.Graphic <> nil
      then DefaultExt := GraphicExtension(TGraphicClass(Wallpaper.Picture.Graphic.ClassType))
      else DefaultExt := GraphicExtension(TBitmap);
    if Execute then
    with Wallpaper.Picture do
    begin
      LoadFromFile(FileName);
      MDIChild.TileWidth.MinValue := Width;
      MDIChild.TileHeight.MinValue := Height;
      MDIChild.TileWidth.Value := Width;
      MDIChild.TileHeight.Value := Height;
    end;
  end;
end;

procedure TMDIMainForm.FormCreate(Sender: TObject);
begin
  OpenDialog.Filter := GraphicFilter(TGraphic);
end;

end.
