unit MDIWChld;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin,
  {$IFDEF RX_LIB}
  RxGIF, RxHook,
  {$ENDIF}
  MDIWallp;

type
  TMDIChild = class(TForm)
    ScrollBar1: TScrollBar;
    ShiftMode: TRadioGroup;
    Label1: TLabel;
    Mode: TComboBox;
    Label2: TLabel;
    ColorDialog: TColorDialog;
    TranspColor: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    TileWidth: TSpinEdit;
    TileHeight: TSpinEdit;
    GroupBox2: TGroupBox;
    ZigZag: TCheckBox;
    Transparent: TCheckBox;
    Enabled: TCheckBox;
    GrayMapped: TCheckBox;
    AutoSizeTile: TCheckBox;
    FitPictureSize: TCheckBox;
    procedure ScrollBar1Change(Sender: TObject);
    procedure ShiftModeClick(Sender: TObject);
    procedure ZigZagClick(Sender: TObject);
    procedure ModeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TransparentClick(Sender: TObject);
    procedure EnabledClick(Sender: TObject);
    procedure GrayMappedClick(Sender: TObject);
    procedure TileWidthChange(Sender: TObject);
    procedure TileHeightChange(Sender: TObject);
    procedure AutoSizeTileClick(Sender: TObject);
    procedure TranspColorClick(Sender: TObject);
    procedure FitPictureSizeClick(Sender: TObject);
  private
    { Private declarations }
    procedure InvalidateHookForm;
  public
    { Public declarations }
  end;

var
  MDIChild: TMDIChild;

implementation

uses
  {$IFDEF RX_LIB}
  HookDemo,
  {$ENDIF}
  Graphics,
  MDIWMain;

{$R *.DFM}

procedure TMDIChild.InvalidateHookForm;
begin
  {$IFDEF RX_LIB}
  if Assigned(HookForm) then HookForm.Invalidate;
  {$ENDIF}
end;

procedure TMDIChild.ScrollBar1Change(Sender: TObject);
begin
  MDIMainForm.Wallpaper.Shift := ScrollBar1.Position;
  ZigZag.Checked := MDIMainForm.Wallpaper.ZigZag;
  InvalidateHookForm;
end;

procedure TMDIChild.ShiftModeClick(Sender: TObject);
begin
  MDIMainForm.Wallpaper.ShiftMode := TShiftMode(ShiftMode.ItemIndex);
  InvalidateHookForm;
end;

procedure TMDIChild.ZigZagClick(Sender: TObject);
begin
  MDIMainForm.Wallpaper.ZigZag := ZigZag.Checked;
  InvalidateHookForm;
end;

procedure TMDIChild.ModeChange(Sender: TObject);
begin
  MDIMainForm.Wallpaper.Mode := TWallpaperMode(Mode.ItemIndex);
  InvalidateHookForm;
end;

procedure TMDIChild.FormCreate(Sender: TObject);
var
  Wp: TMDIWallpaper;
begin
  Mode.ItemIndex := 0;
{$IFNDEF VER90}
  GrayMapped.Enabled := True;
{$ENDIF}
  Wp := MDIMainForm.Wallpaper;
  with TileWidth do
  begin
    MinValue := Wp.Picture.Width;
    Value := Wp.TileWidth;
  end;
  with TileHeight do
  begin
    MinValue := Wp.Picture.Height;
    Value := Wp.TileHeight;
  end;
  AutoSizeTile.Checked := Wp.AutoSizeTile;
end;

procedure TMDIChild.TransparentClick(Sender: TObject);
begin
  MDIMainForm.Wallpaper.Transparent := Transparent.Checked;
  InvalidateHookForm;
end;

procedure TMDIChild.EnabledClick(Sender: TObject);
begin
  MDIMainForm.Wallpaper.Enabled := Enabled.Checked;
  InvalidateHookForm;
end;

procedure TMDIChild.GrayMappedClick(Sender: TObject);
begin
{$IFNDEF VER90}
  MDIMainForm.Wallpaper.GrayMapped := GrayMapped.Checked;
  InvalidateHookForm;
{$ENDIF}
end;

procedure TMDIChild.TileWidthChange(Sender: TObject);
begin
  MDIMainForm.Wallpaper.TileWidth := TileWidth.Value;
  InvalidateHookForm;
end;

procedure TMDIChild.TileHeightChange(Sender: TObject);
begin
  MDIMainForm.Wallpaper.TileHeight := TileHeight.Value;
  InvalidateHookForm;
end;

procedure TMDIChild.AutoSizeTileClick(Sender: TObject);
begin
  MDIMainForm.Wallpaper.AutoSizeTile := AutoSizeTile.Checked;
  MDIMainForm.Wallpaper.TileWidth := TileWidth.Value;
  MDIMainForm.Wallpaper.TileHeight := TileHeight.Value;
  InvalidateHookForm;
end;

procedure TMDIChild.TranspColorClick(Sender: TObject);
begin
  with ColorDialog do
  begin
    Color := MDIMainForm.Wallpaper.TransparentColor;
    if Execute then
      MDIMainForm.Wallpaper.TransparentColor := Color;
  end;
  InvalidateHookForm;
end;

procedure TMDIChild.FitPictureSizeClick(Sender: TObject);
begin
  MDIMainForm.Wallpaper.FitPictureSize := FitPictureSize.Checked;
  InvalidateHookForm;
end;

end.
