unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, MCSGrid, StdCtrls,SortGrid;

type
  TForm1 = class(TForm)
    MSStringGrid1: TMSStringGrid;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    GroupBox2: TGroupBox;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    Button1: TButton;
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure MSStringGrid1FixedCellClick(Sender: TObject; ACol,
      ARow: Longint);
    procedure MSStringGrid1GetAlignment(Sender: TObject; ARow,
      ACol: Longint; var AAlignment: TAlignment);
    procedure RadioButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Ascend:Boolean;
    sortcol:integer;
    procedure GridSort;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 MSStringGrid1.FixedButtons:=CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
 MSStringGrid1.GridLines:=CheckBox2.Checked;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 with  MSStringGrid1 do begin
   Cells[0,0]:='Name';
   Cells[1,0]:='Birthday';
   Cells[0,1]:='Barbara';
   Cells[1,1]:='10/10/61';
   Cells[0,2]:='David';
   Cells[1,2]:='01/10/45';
   Cells[0,3]:='Jim';
   Cells[1,3]:='09/06/75';
 end;
 Ascend:=True;
 
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
 if CheckBox3.Checked then
   MSStringGrid1.Options:=MSStringGrid1.Options+[goDrawFocusSelected]
 else
   MSStringGrid1.Options:=MSStringGrid1.Options-[goDrawFocusSelected];
 MSStringGrid1.SetFocus;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
 MSStringGrid1.Elipsify:=CheckBox4.Checked;
end;

procedure TForm1.MSStringGrid1FixedCellClick(Sender: TObject; ACol,
  ARow: Longint);
begin
 Ascend:=not Ascend;
 sortcol:=ACol;
 GridSort;
end;

procedure TForm1.GridSort;
begin
case sortcol of
  0: MyQuickSortGrid(gstText,Ascend,MSStringGrid1,
   1, MSStringGrid1.RowCount-1, sortcol);
  1: MyQuickSortGrid(gstDate,Ascend,MSStringGrid1,
   1, MSStringGrid1.RowCount-1, sortcol);

 end;
end;

procedure TForm1.MSStringGrid1GetAlignment(Sender: TObject; ARow,
  ACol: Longint; var AAlignment: TAlignment);
begin
 
 Case ACol of
  0: if RadioButton1.Checked then AAlignment:=taLeftJustify
     else if  RadioButton2.Checked then
     AAlignment:=taRightJustify else
     AAlignment:=taCenter;
  1: if RadioButton4.Checked then AAlignment:=taLeftJustify
     else if  RadioButton5.Checked then
     AAlignment:=taRightJustify else
     AAlignment:=taCenter;
  end;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
 MSStringGrid1.Refresh;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 Close;
end;

end.
