unit Sortgrid;

interface

Uses MCSGrid, Classes, SysUtils;

Type
  TGridSortType = ( gstText, gstDate, gstNumeric );
{ Sorting routines for TMyStringGrids
  =================================
  All procedures use the same parameters:
  - String grid, StartRow, EndRow, SortCol

  Use QuickSortGrid to sort a column that has string values
  Use QuickSortGridNumeric to sort a column that has numeric values

  qsortGrid and qsortGridNumeric sort entire grids with all its cells and
  therefore shouldn't been called directly

  Please note that BubbleSortGrid is faster than QuickSortGrid for less than 5 rows
}
procedure QuickSortGrid(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
procedure QuickSortGridNumeric(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
procedure MyQuickSortGrid(How:TGridSortType;Ascend : Boolean;sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
procedure BubbleSortGrid(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
procedure qsortGrid(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
procedure qsortGridNumeric(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
procedure qsortGridDate(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);

implementation

procedure QuickSortGrid(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
var j: Word;
    sortGrid, tempGrid : TMSStringGrid;
begin
  {create temporary 2 col string grid}
  sortGrid := TMSStringGrid.Create(Nil);
  sortGrid.RowCount := sGrid.RowCount;
  sortGrid.ColCount := 2;
  {fill the grid with the original row number and the sort column}
  for j := StartRow to EndRow do begin
    sortGrid.Cells[0, j] := IntToStr(j);
    sortGrid.Cells[1, j] := sGrid.Cells[SortCol, j];
  end;
  {sort this grid with the general grid sorting routine}
  qsortGrid(sortGrid, StartRow, EndRow, 1);
  {create a temporary grid the store the sorted new grid}
  tempGrid := TMSStringGrid.Create(Nil);
  tempGrid.RowCount := sGrid.RowCount;
  tempGrid.ColCount := sGrid.ColCount;
  {fill the entire temporary grid}
  for j := StartRow to EndRow do
    tempGrid.rows[j] :=sGrid.rows[StrToInt(sortGrid.Cells[0,j])];
  {store the temporary grid into the original grid}
  for j := StartRow to EndRow do
    sGrid.rows[j] := tempGrid.rows[j];
  tempGrid.Free;
  sortGrid.Free;
end;


procedure MyQuickSortGrid(How : TGridSortType; Ascend : Boolean;
sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
var j : Word;
    sortGrid, tempGrid : TMSStringGrid;
begin
  {create temporary 2 col string grid}
  sortGrid := TMSStringGrid.Create(Nil);
  sortGrid.RowCount := sGrid.RowCount;
  sortGrid.ColCount := 2;
  {fill the grid with the original row number and the sort column}
  for j := StartRow to EndRow do begin
    sortGrid.Cells[0, j] := IntToStr(j);
    sortGrid.Cells[1, j] := sGrid.Cells[SortCol, j];
  end;
  {sort this grid with the general grid sorting routine}
  case How of
  gstText: qsortGrid(sortGrid, StartRow, EndRow, 1);
  gstDate:qsortGridDate(sortGrid, StartRow, EndRow, 1);
  gstNumeric:qsortGridNumeric(sortGrid, StartRow, EndRow, 1);
  end;
  {create a temporary grid the store the sorted new grid}
  tempGrid := TMSStringGrid.Create(Nil);
  tempGrid.RowCount := sGrid.RowCount;
  tempGrid.ColCount := sGrid.ColCount;
  {fill the entire temporary grid}
  for j := StartRow to EndRow do
    tempGrid.rows[j] :=sGrid.rows[StrToInt(sortGrid.Cells[0,j])];
  {store the temporary grid into the original grid}
  if Ascend then
   for j := StartRow to EndRow do
    sGrid.rows[j] := tempGrid.rows[j]
  else
    for j := StartRow to EndRow do
    sGrid.rows[sGrid.RowCount-j] := tempGrid.rows[j];
  tempGrid.Free;
  sortGrid.Free;
end;
procedure QuickSortGridNumeric(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
var j : Word;
    sortGrid, tempGrid : TMSStringGrid;
begin
  {create temporary 2 col string grid}
  sortGrid := TMSStringGrid.Create(Nil);
  sortGrid.RowCount := sGrid.RowCount;
  sortGrid.ColCount := 2;
  {fill the grid with the original row number and the sort column}
  for j := StartRow to EndRow do begin
    sortGrid.Cells[0, j] := IntToStr(j);
    sortGrid.Cells[1, j] := sGrid.Cells[SortCol, j];
  end;
  {sort this grid with the general grid sorting routine}
  qsortGridNumeric(sortGrid, StartRow, EndRow, 1);
  {create a temporary grid the store the sorted new grid}
  tempGrid := TMSStringGrid.Create(Nil);
  tempGrid.RowCount := sGrid.RowCount;
  tempGrid.ColCount := sGrid.ColCount;
  {fill the entire temporary grid}
  for j := StartRow to EndRow do
    tempGrid.rows[j] :=sGrid.rows[StrToInt(sortGrid.Cells[0,j])];
  {store the temporary grid into the original grid}
  for j := StartRow to EndRow do
    sGrid.rows[j] := tempGrid.rows[j];
  tempGrid.Free;
  sortGrid.Free;
end;

procedure BubbleSortGrid(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
Var Index : Word;
    Changed : Boolean;
    tempRow : TStringList;
    fields, i : Word;
begin
  tempRow :=TStringList.Create;
  fields := sGrid.ColCount;
  repeat
    Changed := False;
    for Index := StartRow to EndRow-1 do begin
      if sGrid.Cells[SortCol, Index] > sGrid.Cells[SortCol, Index+1] then begin
        tempRow.Clear;
        for i := 0 to fields - 1 do tempRow.Add(sGrid.cells[i, Index+1]);
        sGrid.rows[Index+1] := sGrid.rows[Index];
        for i := 0 to fields - 1 do sGrid.cells[i, Index] := tempRow.Strings[i];
        Changed := True;
      end;
    end;
  until Changed = False;
  tempRow.Free;
end;

procedure qsortGridNumeric(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
Var x, y : Word;
    temp: Extended;
    tempRow : TStringList;
    ind : Word;
    fields, i : Word;
begin
    tempRow :=TStringList.Create;
    fields := sGrid.ColCount;
    if StartRow < EndRow then begin
      x:= StartRow;
      y:= EndRow;
      ind := (StartRow+EndRow) div 2;
      temp := StrToFloat(sGrid.cells[SortCol, ind]);
      while x <= y do begin
        while StrToFloat(sGrid.cells[SortCol, x]) < temp do Inc(x);
        while StrToFloat(sGrid.cells[SortCol, y]) > temp do Dec(y);
        if x <= y then begin
          tempRow.Clear;
          for i := 0 to fields - 1 do tempRow.Add(sGrid.cells[i, x]);
          sGrid.rows[x] := sGrid.rows[y];
          for i := 0 to fields - 1 do sGrid.cells[i, y] := tempRow.Strings[i];
          Inc(x);
          Dec(y);
        end;
      end;
      tempRow.Free;
      qsortGridNumeric(sGrid, StartRow, y, SortCol);
      qsortGridNumeric(sGrid, x, EndRow, SortCol);
    end;
end;

procedure qsortGridDate(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
 function ReturnDate(s:string):TDateTime;
 begin
  try
    result:=StrToDate(s);
  except
    result:=0.0;
  end;
 end;
Var x, y : Word;
    temp: Extended;
    tempRow : TStringList;
    ind : Word;
    fields, i : Word;
    
begin
     tempRow :=TStringList.Create;
    fields := sGrid.ColCount;
    if StartRow < EndRow then begin
      x:= StartRow;
      y:= EndRow;
      ind := (StartRow+EndRow) div 2;
      temp := ReturnDate(sGrid.cells[SortCol, ind]);
      while x <= y do begin
        while ReturnDate(sGrid.cells[SortCol, x]) < temp do Inc(x);
        while ReturnDate(sGrid.cells[SortCol, y]) > temp do Dec(y);
        if x <= y then begin
          tempRow.Clear;
          for i := 0 to fields - 1 do tempRow.Add(sGrid.cells[i, x]);
          sGrid.rows[x] := sGrid.rows[y];
          for i := 0 to fields - 1 do sGrid.cells[i, y] := tempRow.Strings[i];
          Inc(x);
          Dec(y);
        end;
      end;
      tempRow.Free;
      qsortGridDate(sGrid, StartRow, y, SortCol);
      qsortGridDate(sGrid, x, EndRow, SortCol);
    end;
end;

procedure qsortGrid(sGrid : TMSStringGrid; StartRow, EndRow, SortCol : Integer);
Var x, y : Word;
    temp: String;
    tempRow : TStringList;
    ind : Word;
    fields, i : Word;
begin
  {BubbleSort is faster if there a less than 5 rows}
  if (EndRow-StartRow) < 5 then
    BubbleSortGrid(sGrid, StartRow, EndRow, SortCol)
  else begin
    tempRow :=TStringList.Create;
    fields := sGrid.ColCount;
    if StartRow < EndRow then begin
      x:= StartRow;
      y:= EndRow;
      ind := (StartRow+EndRow) div 2;
      temp := UpperCase(sGrid.cells[SortCol, ind]);
      while x <= y do begin
        while UpperCase(sGrid.cells[SortCol, x]) < temp do Inc(x);
        while UpperCase(sGrid.cells[SortCol, y]) > temp do Dec(y);
        if x <= y then begin
          tempRow.Clear;
          for i := 0 to fields - 1 do tempRow.Add(sGrid.cells[i, x]);
          sGrid.rows[x] := sGrid.rows[y];
          for i := 0 to fields - 1 do sGrid.cells[i, y] := tempRow.Strings[i];
          Inc(x);
          Dec(y);
        end;
      end;
      tempRow.Free;
      qsortGrid(sGrid, StartRow, y, SortCol);
      qsortGrid(sGrid, x, EndRow, SortCol);
    end;
  end;
end;


end.
