unit makemap2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  Tfmzoom = class(TForm)
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  fmzoom: Tfmzoom;
  w,h:integer;
  clr : trect;
implementation

uses makemap1;

{$R *.DFM}

procedure Tfmzoom.FormResize(Sender: TObject);
begin
	repaint;
     clientwidth := w;
     clientheight := h;
end;

procedure Tfmzoom.FormPaint(Sender: TObject);
var it : single;
    rc1 : trect;
begin
     if (myimg.width * myimg.height)= 0 then exit;
     w := clientwidth;
     it := w / myimg.width;
     h := round(it*myimg.height);
     if h > clientheight then begin
        h := clientheight;
        it := h / myimg.height;
        w := round(it*myimg.width);
     end;
     canvas.stretchdraw(rect(0,0,w,h),myimg);
      if not visible then clientwidth := w;
      if not visible then clientheight := h;
      if not visible then exit;
      if form1.bild.width = 0 then exit;
     it := w / form1.bild.width;
     rc1 := clr;
     rc1.left := round(rc1.left * it);
     rc1.top := round(rc1.top * it);
     rc1.right := round(rc1.right * it);
     rc1.bottom := round(rc1.bottom * it);
     canvas.rectangle(rc1.left,rc1.top,rc1.right,rc1.bottom);
//     canvas.framerect(rc1);
end;

procedure Tfmzoom.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     form1.btnzoom.down := false;
end;

procedure Tfmzoom.FormShow(Sender: TObject);
begin
        canvas.brush.style := bsdiagcross;
//        canvas.pen.width := 1;

end;

procedure Tfmzoom.FormDblClick(Sender: TObject);
begin
     clientwidth := w;
     clientheight := h;
end;

end.
