unit makemap1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls, ComCtrls, Menus;

type
  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    bild: TPaintBox;
    opend: TOpenDialog;
    bar: TStatusBar;
    PopupMenu1: TPopupMenu;
    showmap1: TMenuItem;
    showmap2: TMenuItem;
    Memo1: TMemo;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Bevel1: TBevel;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    ComboBox1: TComboBox;
    btnzoom: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure bildPaint(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure bildMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure bildMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure bildMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure bildDblClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure showmap2Click(Sender: TObject);
    procedure showmap1Click(Sender: TObject);
    procedure btnzoomClick(Sender: TObject);
  private
    { Private-Deklarationen }
    function getzoom : integer;
    procedure updatebild;
    procedure getimgs;
    procedure addmap(x,y:integer);
    function gv (a,x:integer):string;
    procedure drawmap(s:string;tc:tcanvas;zoom:integer);
    function gc (var s : string;a:integer):integer;
    procedure stretchbild(b:tbitmap);
    function getvisrect:trect;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  myimg,tbmp :tbitmap;
  map : tstrings;
  points : tstrings;
  mode : integer = 1;
  ismode : boolean = false;
  oldx,oldy : integer;
  pts : array [0..500] of tpoint;
  ptix : integer = 0;
  allownext : boolean = true;
  allowchange : boolean = true;
  canchange : boolean = true;
const zoom : array [-1..3] of byte = (1,1,2,4,8);
implementation

uses makemap2;


{$R *.DFM}

function tform1.getvisrect:trect;
begin
     with scrollbox1 do begin
          result.left:=horzscrollbar.scrollpos;
          result.top :=vertscrollbar.scrollpos;
          result.right := clientwidth+result.left;
          if result.right >= bild.width then result.right := bild.width-1;
          result.bottom := clientheight+result.top;
          if result.bottom >= bild.height then result.bottom := bild.height-1;
     end;
end;

procedure tform1.stretchbild(b:tbitmap);
var rc1,rc2 : trect;

begin
     rc1:=getvisrect;
     rc1.left := rc1.left-2;
     rc1.top := rc1.top-2;
     rc1.right := rc1.right+2;
     rc1.bottom := rc1.bottom+2;
     rc2.left := rc1.left div getzoom;
     rc2.top := rc1.top div getzoom;
     rc2.right := rc1.right div getzoom;
     rc2.bottom := rc1.bottom div getzoom;
     bild.canvas.copyrect(rc1,b.canvas,rc2);
     fmzoom.formpaint(nil);
end;

function tform1.gc (var s : string;a:integer):integer;
var t : integer;
begin
     result := maxint;
     if length(s) < 2 then exit;
     if s[1] = ',' then begin
        delete(s,1,1);
        t := pos(',',s);
        if t = 0 then t := maxint-1;
        result := strtointdef(copy(s,1,t-1),maxint)*a;
        s := copy(s,t,maxint);
     end;
end;

procedure tform1.drawmap(s:string;tc:tcanvas;zoom:integer);
var ch : char;
    a,b,c,d : integer;
    tmt : array [0..500] of tpoint;
begin
     ch := s[1];
     delete(s,1,1);
     with tc do begin
          //pen.mode := pmblack;
          if ch <> 'p' then begin
             a := gc(s,zoom);
             b := gc(s,zoom);
             c := gc(s,zoom);
             d := gc(s,zoom);
          end;
          case ch of
               'c' : ellipse(a,b,c,(c-a)+b);
               'p' : begin
                          a := 0;
                          b := gc(s,zoom);
                          while b < maxint-1 do begin
                                tmt[a].x := b;
                                tmt[a].y := gc(s,zoom);
                                inc(a);
                                b:=gc(s,zoom);
                          end;
                          polygon(slice(tmt,a-1));
                      end;
               'r' : rectangle(a,b,c,d);
          end;
     end;
end;

function tform1.gv (a,x:integer):string;
begin
     a := a div getzoom;
     //if a < 0 then a := 0;
     //if a > x then a := x;
     result:=','+inttostr(a);
end;

procedure tform1.addmap(x,y:integer);
const md : array [1..3] of char = ('r','c','p');
var sr : string;
    t : integer;
    x1,y1 : integer;
begin
     x1 := myimg.width;
     y1 := myimg.height;
     sr := md[mode];
     if mode < 1 then exit;
     if mode <> 3 then begin
         sr := sr+gv(oldx,x1)+gv(oldy,y1);
         sr := sr+gv(x,x1);
         if mode = 1 then sr := sr+gv(y,y1);
         map.add(sr);
         memo1.lines.add(sr);
         updatebild;
         exit;
     end;
     if ptix < 2 then exit;
     for t := 0 to ptix -1 do begin
         sr := sr+gv(pts[t].x,x1);
         sr := sr+gv(pts[t].y,y1);
     end;
     map.add(sr);
         memo1.lines.add(sr);
     updatebild;
end;


procedure tform1.getimgs;
begin
     screen.cursor := crhourglass;
     //canvas.stretchdraw(rect(0,0,width,height),myimg);
     tbmp.width := myimg.width;
     tbmp.height := myimg.height;
     screen.cursor := crdefault;
     fmzoom.repaint;
end;

procedure tform1.updatebild;
begin
          ismode := false;
          bild.width := myimg.width * getzoom;
          bild.height := myimg.height * getzoom;
          bildpaint(nil);
end;

function tform1.getzoom : integer;
begin
     result := zoom[combobox1.itemindex];
end;

procedure TForm1.FormCreate(Sender: TObject);
var t : integer;
begin
     myimg := tbitmap.create;
     map := tstringlist.create;
     tbmp := tbitmap.create;
     combobox1.itemindex := 0;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var t : integer;
begin
     myimg.free;
     tbmp.free;
     map.free;

end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var sr : tfilename;
begin
     with opend do begin
          title := 'open map';
          if execute then begin
             sr := filename;
             if not fileexists(sr) then exit;
             myimg.loadfromfile(sr);
             getimgs;
             sr:=changefileext(sr,'.map');
             map.clear;
             if  fileexists(sr) then
                 map.loadfromfile(sr);
             memo1.lines.assign(map);
             updatebild;
             speedbutton4.down := true;
             mode := 1;
          end;
     end;
end;

procedure TForm1.bildPaint(Sender: TObject);
var t : integer;
begin
     clr := getvisrect;
     tbmp.width := myimg.width;
     tbmp.height := myimg.height;
     with tbmp.canvas do begin
     	draw(0,0,myimg);
     	pen.mode := pmblack;
     	pen.mode := pmnot;
     if map.count > 0 then for t := 0 to map.count -1 do
        drawmap(map[t],tbmp.canvas,1);
     end;
     stretchbild(tbmp);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
     updatebild;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
var sr : tfilename;
begin
     sr := opend.filename;
     if not fileexists(sr) then
     with opend do begin
          title := 'save map';
          if not execute then exit;
          sr := changefileext(opend.filename,'.map');
     end;
     sr := changefileext(sr,'.map');
     map.savetofile(sr);
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
     ismode := false;
     mode := (sender as tspeedbutton).tag;
     updatebild;
end;

procedure TForm1.bildMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var t : integer;
begin
     bar.simpletext := 'X: '+inttostr(x div getzoom)+'  Y: '+inttostr(y div getzoom);
     if not ismode then exit;
     with bild.canvas do begin
          stretchbild(tbmp);
          pen.mode := pmnot;
          pen.width := 0;
          case mode of
               1 : rectangle(oldx div getzoom*getzoom,oldy div getzoom*getzoom,x div getzoom*getzoom,y div getzoom*getzoom);
               2 : ellipse(oldx div getzoom*getzoom,oldy div getzoom*getzoom,x div getzoom*getzoom,(oldy+(x-oldx)) div getzoom*getzoom);
               3 : begin
                        if ptix = 0 then exit;
                        pen.width := getzoom;
                        t := 0;
                        moveto(pts[0].x,pts[0].y);
                        if ptix > 1 then begin
                           for t := 1 to ptix -1 do
                               lineto(pts[t].x,pts[t].y);
                        end;
                        lineto(x div getzoom*getzoom,y div getzoom*getzoom);
                   end;
          end;
     end;
end;

procedure TForm1.bildMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     if not allownext then begin
        allownext := true;
        exit;
     end;
     if not ismode then bildpaint(nil);
     oldx := x;
     oldy := y;
     if not ismode then ptix := 0;
     ismode := true;
     if mode = 3 then begin
        if ptix > 500 then exit;
        pts [ptix].x := x div getzoom*getzoom;
        pts [ptix].y := y div getzoom*getzoom;
        inc (ptix);
     end;
end;

procedure TForm1.bildMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     if ismode then if mode <> 3 then addmap(x,y);
     if mode <> 3 then ismode := false;
end;

procedure TForm1.bildDblClick(Sender: TObject);
begin
     if ismode then if mode = 3 then addmap(0,0);
     ismode := false;
     ptix :=0;
     allownext := false;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     if key = vk_escape then
        updatebild;
end;

procedure TForm1.showmap2Click(Sender: TObject);
var t : integer;
    sr : string;
begin
     bild.canvas.pen.mode := pmblack;
     sr :=memo1.lines[SendMessage(memo1.Handle, EM_LINEFROMCHAR, memo1.SelStart, 0)];
     if sr = '' then exit;
     drawmap(sr,bild.canvas,getzoom);
     bild.canvas.pen.mode := pmnot;
     for t := 0 to 10 do begin
         drawmap(sr,bild.canvas,getzoom);
         sleep(30);
     end;
     updatebild;

end;

procedure TForm1.showmap1Click(Sender: TObject);
begin
     map.assign(memo1.lines);
     updatebild;
end;

procedure TForm1.btnzoomClick(Sender: TObject);
begin
     fmzoom.visible := btnzoom.down;
     fmzoom.repaint;
end;

end.
