unit test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,mapimg,
  ExtCtrls, StdCtrls, Grids, ComCtrls;

type
  TForm1 = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

function loads(a,b:integer):string;
function fmt (a:string):string;
var
  Form1: TForm1;
  myimg : tmapimage;
  tbmp : tbitmap;
  offs : integer = 0;
const
     states : array [0..16] of byte = (
     1,3,16,16,2,12,11,10,14,4,5,6,9,15,13,8,7);

implementation


{$R *.DFM}
{$r testp1.res}

function fmt (a:string):string;
var i:integer;
begin
     i:=strtointdef(a,0);
     result:=format('%.0n',[i+0.0]);
end;

function loads(a,b:integer):string;
var buf : array [0..255] of char;
begin
     loadstring(hinstance,a+b+offs,buf,254);
     result := strpas(buf);
end;

procedure TForm1.FormCreate(Sender: TObject);
var li : tlistitem;
begin
     myimg := tmapimage.create(self);
     tbmp := tbitmap.create;
     myimg.parent:=self;
     myimg.left := 2;
     myimg.top := 2;
     myimg.autosize := true;
     myimg.picture.bitmap.loadfromfile('germany.bmp');
     tbmp.loadfromfile('germany.bmp');
     myimg.map.loadfromfile('germany.map');
     myimg.onmousemove := formmousemove;
     myimg.onmousedown := formmousedown;
     myimg.onmouseup := formmouseup;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
     myimg.free;
     tbmp.free;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var x1 : integer;
begin
     x1 := myimg.getmap(x,y);
     if x1 > -1 then begin
        if offs = 0 then label1.caption := loads(states[x1],400);
        if offs > 0 then label1.caption := loads(x1+1,400);
     end else label1.caption := '';
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var t,i1,i2:integer;
begin
     myimg.picture.bitmap.canvas.brush.color := clblack;
     t := myimg.getmap(x,y);
     if t = -1 then exit;
     if ((t = 3) or (t = 2)) and (offs = 0) then begin
        i1 := myimg.createregion(2);
        i2 := myimg.createregion(3);
        combinergn(i1,i1,i2,rgn_or);
        deleteobject(i2);
     end else i1 := myimg.createregion(t);

     with myimg.picture.bitmap.canvas do
          if i1 > 0 then begin
             selectobject(handle,i1);
             rectangle(0,0,myimg.width,myimg.height);
             deleteobject(i1);
          end;
         if offs = 0 then t:=states[t] else inc(t);
         edit1.text:=loads(t,0);
         edit2.text:=(loads(t,100));
         edit3.text:=(fmt(loads(t,200)));
         edit4.text:=(fmt(loads(t,300)));
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     myimg.picture.bitmap:=(tbmp);
     if myimg.getmap(x,y) = 12 then begin
        myimg.picture.loadfromfile('saarland.bmp');
        tbmp.loadfromfile('saarland.bmp');
        myimg.map.loadfromfile('saarland.map');
        offs := 1000;
        label2.caption := 'Kreis:';
        label3.caption := 'Kreisstadt:';
        button1.visible := true;
        caption := 'about saarland''s counties (sample for tmapimage)';
        edit1.text := '';
        edit2.text := '';
        edit3.text := '';
        edit4.text := '';
     end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     offs := 0;
        myimg.picture.loadfromfile('germany.bmp');
        tbmp.loadfromfile('germany.bmp');
        myimg.map.loadfromfile('germany.map');
        button1.visible := false;
        label2.caption := 'Land:';
        label3.caption := 'Hauptstadt:';
        caption := 'about german states (sample for tmapimage)';
        edit1.text := '';
        edit2.text := '';
        edit3.text := '';
        edit4.text := '';
end;

end.
