{MapImage Component for Delphi 2  written by Markus Stephany
                                             MirBir.St@T-Online.de
                                             http://home.t-online.de/home/mirbir.st/

 V 1.00    06/04/97

 Set different clickable regions on the image (maybe the counties of a state)
 and get the map on every mouse-event (see the sample).
 load and save the map; create your own with the sample map-editor.

 this is free for freeware, public domain and shareware, but not for commercial use
 without my permission.

 if something is going wrong (or even not), contact me (see above), but do not make
 me responsable for anything !!

TMapImage is a child of TImage.
The added properties/functions are :

- map			: tstrings
	the description strings of the TMI's regions. the syntax for each string:
	first character : 'r' for a rectangular region
			  'c' for a round region
                          'p' for a polygonal region
        the further contents: ',xxx' for each number
			      'c' : 3 items (x,y,radius) (e.g. 'c,0,0,100')	
			      'r' : 4 items (left,top,right,bottom) (eg 'r,0,0,80,120')
                              'p' : 2..500 items (two for each border-point (x,y))
                                    (eg. 'p,50,0,0,100,100,100' for a triangle)
       if there are 2 or more regions on one point, the region described in the map with
       the higher index is used.	
	
- getmap (x,y:integer)	: integer
	on which region is the coordinate(x,y) ?
        result : -1 for no region
                 xx for the index[xx] of the map-tstrings    

- MapCursor,NoMapCursor : tcursor
	the cursor that will be shown if the mouse is / is not on a region
        (by default : crHand (included index : 39) / crdefault

- createregion (x:integer)	: hrgn
	this function will create a windows-region from map[x] and give back the handle.
	you have to delete the region after the usage with deleteobject (result) by yourself!
 	overlapping regions will be handled correctly.

-- the property stretch can not be used.

}
unit mapimg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;


const crMap = 39;

type
  TMapImage = class(TImage)
  fstretch : boolean;
  fmap : tstrings;
  fmapcursor,fcursor: tcursor;
  factmap : integer;
  finmove : boolean;

  private
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    destructor destroy ; override;
    procedure setmap(val:tstrings);
  public
    { Public-Deklarationen }
    function getmap (x,y:integer):integer;
    function createregion(index:integer):integer;
    constructor create (aowner : tcomponent);override;
  published
    { Published-Deklarationen }
    property Stretch :boolean read fstretch;
    property MapCursor : tcursor read fmapcursor write fmapcursor default crMap;
    property NoMapCursor : tcursor read fcursor write fcursor default crDefault;
    property Map : tstrings read fmap write setmap;
  end;

procedure Register;


implementation
{$r map.res}
constructor tmapimage.create (aowner : tcomponent);
begin
     inherited create (aowner);
     fmap := tstringlist.create;
     screen.cursors[crmap] := loadcursor(hinstance,'HANDCUR');
     fmapcursor := crmap;
     fcursor := crdefault;
     inherited stretch := false;
     fstretch := false;
     autosize := true;
     finmove := false;
end;

destructor tmapimage.destroy;
begin
     fmap.free;
     inherited destroy;
end;

procedure tmapimage.setmap(val:tstrings);
begin
     fmap.assign(val);
end;

procedure tmapimage.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
     finmove := false;
//     if getmap(x,y) = -1 then windows.setcursor(screen.cursors[cursor]) else
//        windows.setcursor(screen.cursors[mapcursor]);
     if getmap(x,y) = -1 then cursor := fcursor else cursor := fmapcursor;
     finmove := true;
     inherited mousemove(shift,x,y);
end;

    function getza(var s:string) : integer;
    var a : integer;
    begin
         result := maxint;
         a := pos (',',s);
         if a = 0 then a := maxint-1;
         result := strtointdef(copy(s,1,a-1),maxint);
         s:=copy(s,a+1,maxint);
    end;

    function getrc (sr : string):trect;
    begin
         result.left := getza(sr);
         result.top := getza(sr);
         result.right := getza(sr);
         result.bottom := getza(sr);
    end;
    function getar (var ar : array of tpoint;sr : string):integer;
    var a : integer;
    begin
         result := 0;
         a := getza(sr);
         while a < maxint-1 do begin
               ar[result].x := a;
               a:=getza(sr);
               ar[result].y:=a;
               inc(result);
               a:=getza(sr);
         end;
    end;
function isinreg(x,y:integer;sr : string):boolean;
var ptar : array [0..500] of tpoint;
    ptix,rg : integer;
    ch : char;
    arps : tpoint;
    rc : trect;

begin
     result := false;
     if sr = '' then exit;
     ch := sr[1];
     delete(sr,1,2);
     arps.x := x;
     arps.y := y;
     case ch of
          'c': begin
                    rc := getrc(sr);
                    ptix := CreateEllipticRgn(rc.left,rc.top,rc.right,
                            rc.top+(rc.right-rc.left));
                    result := ptinregion(ptix,x,y);
                    deleteobject(ptix);
               end;
          'p': begin
                    ptix := getar(ptar,sr);
                    rg := createpolygonrgn(ptar,ptix,winding);
                    result := ptinregion(rg,x,y);
                    deleteobject(rg);
               end;
          'r': result := ptinrect(getrc(sr),arps);
     end;
end;

function tmapimage.getmap (x,y:integer):integer;
var ct : integer;
    sr : string;
begin
     result := -1;
     if finmove then result := factmap else begin
        // map holen
        if fmap.count > 0 then for ct := fmap.count-1 downto 0 do begin
           sr := fmap[ct];
           if isinreg(x,y,sr) then begin
              result := ct;
              factmap := result;
              finmove := false;
              exit;
           end;
        end;
        result := -1;
        factmap := result;
     end;
     finmove := false;
end;

function tmapimage.createregion(index:integer):integer;
var i1,i2 : integer;
var i3,i4:integer;

    function getreg(s1:string):integer;
    var ch : char;
        rc : trect;
        ptix : integer;
        ptar : array [0..500] of tpoint;
        sr : string;
    begin
         sr := s1;
         result := 0;
         if sr = '' then exit;
         ch := sr[1];
         delete(sr,1,2);
         case ch of
          'c': begin
                    rc := getrc(sr);
                    result := CreateEllipticRgn(rc.left,rc.top,rc.right,
                            rc.top+(rc.right-rc.left));
               end;
          'p': begin
                    ptix := getar(ptar,sr);
                    result := createpolygonrgn(ptar,ptix,winding);
               end;
          'r': begin
                    rc := getrc(sr);
                    result := CreaterectRgn(rc.left,rc.top,rc.right,
                            rc.bottom);
               end;
         end;
    end;
begin
     result := 0;
     i2 := 0;
     if index >= fmap.count then exit;
     i1 := getreg(fmap[index]);
     if index < fmap.count -1 then for i3 := index+1 to fmap.count-1 do begin
        i2 := getreg(fmap[i3]);
        combinergn(i1,i1,i2,rgn_diff);

        deleteobject(i2);
     end;
     result := i1;
end;


procedure Register;
begin
  RegisterComponents('Beispiele', [TMapImage]);
end;

end.
