{*******************************************************************}
{                                                                   }
{  Diff Maker                                                       }
{  Copyright (c) 1997 S.Kurinny & S.Kostinsky                       }
{                                                                   }
{ 27/10/98  Modified by Gregory L. Bullock (bullock@tsppd.com) to   }
{           pass the calling program's Notify procedure an estimate }
{           of the amount completed so far & to call it more often. }
{                                                                   }
{  2/20/98  Modified by Gregory L. Bullock (bullock@tsppd.com) so   }
{           Delphi 1.0 will compile:                                }
{           Changed "Integer" to "LongInt"                          }
{           Changed useofs & bufofs in t3word from LongInt to word. }
{           Changed arrays with size MaxHashValue (= 131071) to     }
{              2-D with subarrays smaller than $FFF0.               }
{           Reduced BufSize from 2048*1024.                         }
{           Converted Comp(...) to Pascal.                          }
{           This version still compiles under D2.  The only changes }
{           that aren't protected by a "$IFDEF Win32" directive are }
{           the integer-to-longint conversions.                     }
{                                                                   }
{*******************************************************************}

unit aDiff;

interface
Uses SysUtils, Classes,
  {$IFDEF Win32} aCRC32; {$ELSE} aCRC3216; {$ENDIF}

{-------------------------------------------------}

Const
{$IFDEF MAKE16AND32COMPATIBLE}
  BufSize=$FFF8;
{$ELSE}
{$IFDEF Win32}
  BufSize=2048*1024;
{$ELSE}
  BufSize=$FFF8;
{$ENDIF}
{$ENDIF}

type
  PLongInt=^LongInt;
  TMyProcedure=procedure(Completed, Total: LongInt);
{$IFDEF Win32}
  TByteArray=packed Array[1..MaxInt] of byte;
{$ELSE}
  TByteArray=Array[1..$FFFF] of byte;
{$ENDIF}
  PByteArray=^TByteArray;

     TDiffCompData=record
       InBuf      : PByteArray;      {pointer to input buffer}
       UseBuf     : PByteArray;      {pointer to use buffer}
       InBufSize  : LongInt;         {input buffer size}
       UseBufSize : LongInt;         {use buffer size}
       MaxLevel   : LongInt;         {max search level}
       MaxLength  : LongInt;         {max string length}
       MinLength  : LongInt;         {min string length}
       OutBuf     : PByteArray;
       OutSpBuf   : PByteArray;
       OutBufSize : PLongInt;
       OutSpBufSize:PLongInt;
       EnoughLen   :LongInt;
       NotifyProc : TmyProcedure;
     end;

{-------------------------------------------------}

{ Calculates hash value
  3 bytes to 0..32767 }
Function CalcHash(a,b,c:LongInt):LongInt;

{ Compares buffers and returns number of equal bytes
  Len - max length }
{$IFDEF Win32}
function comp(var a,b;len:integer):integer; assembler;
{$ELSE}
function comp(var a,b;len:LongInt):word;
{$ENDIF}
Function Min(a,b:LongInt):LongInt;
Function Max(a,b:LongInt):LongInt;
procedure DiffStreamCompress(InStream,UseStream,OutStream:TStream;Notify:TmyProcedure;MaxLev:LongInt);
procedure DiffCompress(D:TDiffCompData);
procedure DiffStreamExtract(InStream,UseStream,OutStream:TStream;Notify:TMyProcedure);

{-------------------------------------------------}

Const
  SSmallBuffer='Buffer size should be at least 4 bytes';

{-------------------------------------------------}
implementation
{-------------------------------------------------}

Const
  MaxHashValue=$1FFFF;
  MaxHashArraySize=$FFF0 div SizeOf(LongInt);
  MaxNHashArrays = MaxHashValue div MaxHashArraySize + 1;
  cMaxFastData=6;

type
{$IFDEF MAKE16AND32COMPATIBLE}
  t3word=record
    len:word;
    useofs:word;
    bufofs:word;
  end;
{$ELSE}
{$IFDEF WIN32}
  t3word=packed record
    len:word;
    useofs:LongInt;
    bufofs:LongInt;
  end;
{$ELSE}
  t3word=record
    len:word;
    useofs:word;
    bufofs:word;
  end;
{$ENDIF}
{$ENDIF}
  p3word=^t3word;

  arrayt3word=array[0..Maxint div 20] of t3word;
  parrayt3word=^arrayt3word;

{$IFDEF Win32}
  THashTable=Array[0..MaxHashValue] of Integer;
  PHashTable=^THashTable;
  THashList=Array[1..MaxInt div 4] of integer;
{$ELSE}
  THashArray=Array[0..MaxHashArraySize-1] of LongInt;
  THashTable=Array[0..MaxNHashArrays] of ^THashArray;
  THashList=Array[0..MaxNHashArrays] of ^THashArray;
{$ENDIF}
  PHashList=^THashList;

{-----------------------------------------}

Function Max(a,b:LongInt):LongInt;
begin
  If a>b then result:=a else result:=b;
end;

{-----------------------------------------}

Function Min(a,b:LongInt):LongInt;
begin
  If a<b then result:=a else result:=b;
end;

{----------------------------------------------------------------}

{$IFDEF Win32}
function comp(var a,b;len:integer):integer; assembler;
asm
    PUSH ESI
    PUSH EDI
    mov esi,a
    mov edi,b
    cld
    mov eax,len
    mov ecx,eax
    rep cmpsb
    inc ecx
    sub eax,ecx
    POP EDI
    POP ESI
end;
{$ELSE}
function comp(var a,b;len:LongInt):word;
type
  ByteArray = array[0..$FFFE] of byte;
begin
  Result := 0;
  while (Result<len) and (ByteArray(a)[Result] = ByteArray(b)[Result]) do
    Inc(Result);
end;
{$ENDIF}

{--------------------------------------------------------}

procedure DiffCompress(D:TDiffCompData);
Var
{$IFDEF Win32}
  HTab:PHashTable;
{$ELSE}
  HTab:THashTable;
{$ENDIF}
  HList:PHashList;
  i:LongInt;
  a,b,c:LongInt;
  h:LongInt;
  curofs:LongInt;
  curlen:LongInt;
  curlevel:LongInt;
  templen:LongInt;
  tempOFs:LongInt;
  oldh:LongInt;
  x:LongInt;
  t3:t3word;
  curpos,cursppos:LongInt;
{$IFNDEF Win32}
  SizeHashList: word;
{$ENDIF}
  NotificationCount:LongInt;

Label
  l3,l2,l1;
begin
  With D do
  begin

  If (InBufSize<4) or (UseBufSize<4) then
    raise Exception.Create(SSmallBuffer);
  CurPos:=1;
  CurSpPos:=1;
{$IFDEF Win32}
  New(HTab);
  GetMem(HList,UseBufSize*4);
  try
    FillChar(HTab^,Sizeof(THashTable),0);
    a:=UseBuf[1];
    b:=UseBuf[2];
    c:=UseBuf[3];
{$ELSE}
  for i := 0 to MaxNHashArrays do
    New(HTab[i]);
  SizeHashList := (UseBufSize*4 + Pred(sizeof(THashArray))) div sizeof(THashArray);
  GetMem(HList,SizeHashList*sizeof(pointer));
  for i := 0 to Pred(SizeHashList) do
    New(HList^[i]);
  try
    for i := 0 to MaxNHashArrays do
      FillChar(HTab[i]^,Sizeof(THashArray),0);
    a:=UseBuf^[1];
    b:=UseBuf^[2];
    c:=UseBuf^[3];
{$ENDIF}
    oldh:=maxint;
    For i:=1 to UseBufSize-4 do
    begin
      h:=(a shl 9) xor (b shl 5) xor c;
       If h<>oldh then
       begin
{$IFDEF Win32}
        HList^[i]:=HTab^[h];
        HTab^[h]:=i;
{$ELSE}
        HList^[Pred(i) div MaxHashArraySize]^[Pred(i) mod MaxHashArraySize]
          := HTab[h div MaxHashArraySize]^[h mod MaxHashArraySize];
        HTab[h div MaxHashArraySize]^[h mod MaxHashArraySize]:=i;
{$ENDIF}
        oldh:=h;
       end;
{$IFDEF Win32}
      a:=b;b:=c;c:=UseBuf[i+3];
{$ELSE}
      a:=b;b:=c;c:=UseBuf^[i+3];
{$ENDIF}
    end;
    {-------}
    NotificationCount := 0;
    i:=1;
    While i<=InBufSize do
    begin
      if (NotificationCount mod 16 = 0) and Assigned(NotifyProc) then
        NotifyProc(i,InBufSize);
      Inc(NotificationCount);
{$IFDEF Win32}
      a:=InBuf[i];
      if i>inbufsize-3 then goto l1;
      h:=(a shl 9) xor (InBuf[i+1] shl 5) xor InBuf[i+2];
      curlen:=minlength-1;
      TempOFs:=HTab^[h];
{$ELSE}
      a:=InBuf^[i];
      if i>inbufsize-3 then goto l1;
      h:=(a shl 9) xor (InBuf^[i+1] shl 5) xor InBuf^[i+2];
      curlen:=minlength-1;
      TempOFs:=HTab[h div MaxHashArraySize]^[h mod MaxHashArraySize];
{$ENDIF}
      curlevel:=0;
      While (tempofs<>0) and (CurLevel<MaxLevel) do
      begin
        x:=Min(InBufSize-i,UseBufSize-TempOFs);
{$IFDEF Win32}
        templen:=Comp(InBuf[i],UseBuf[TempOfs],x) and $0000ffff;
{$ELSE}
        templen:=Comp(InBuf^[i],UseBuf^[TempOfs],x) and $0000ffff;
{$ENDIF}
        If TempLen>CurLen then
        begin
          CurLen:=TempLen;
          CurOfs:=TempOfs;
        end;
     l3:
{$IFDEF Win32}
        TempOfs:=HList^[TempOfs];
{$ELSE}
        TempOfs:=HList^[Pred(TempOfs) div MaxHashArraySize]^[Pred(TempOfs) mod MaxHashArraySize];
{$ENDIF}
        inc(CurLevel);
      end;
      If CurLen<MinLength then
      begin
      l1:
{$IFDEF Win32}
        OutBuf[CurPos]:=a;
{$ELSE}
        OutBuf^[CurPos]:=a;
{$ENDIF}
        inc(CurPos);
        Inc(i);
      end else
      begin
    l2:
       t3.len:=CurLen;
       t3.useofs:=CurOfs;
       t3.bufofs:=i;
{$IFDEF Win32}
       Move(t3,OutSpBuf[CurSpPos],SizeOf(t3));
{$ELSE}
       Move(t3,OutSpBuf^[CurSpPos],SizeOf(t3));
{$ENDIF}
       inc(CurSpPos,SizeOf(t3));
       Inc(i,CurLen);
      end;
    end;
    {-------}
    t3.len:=0;
    t3.useofs:=0;
    t3.bufofs:=InBufSize+1;
{$IFDEF Win32}
    Move(t3,OutSpBuf[CurSpPos],SizeOf(t3));
{$ELSE}
    Move(t3,OutSpBuf^[CurSpPos],SizeOf(t3));
{$ENDIF}
    inc(CurSpPos,SizeOf(t3));
    OutBufSize^:=CurPos-1;
    OutSpBufSize^:=CurSpPos-1;
  finally
{$IFDEF Win32}
    Dispose(HTab);
    FreeMem(HList,UseBufSize*4);
{$ELSE}
    for i := 0 to MaxNHashArrays do
      Dispose(HTab[i]);
    for i := 0 to Pred(SizeHashList) do
      Dispose(HList^[i]);
    FreeMem(HList,SizeHashList*sizeof(pointer));
{$ENDIF}
  end;
  end;
end;

{-------------------------------------------------}

procedure DiffStreamCompress(InStream,UseStream,OutStream:TStream;Notify:TMyProcedure;MaxLev:LongInt);
Var
   Buf,Temp,OutBuf,OutSpBuf:PByteArray;
   BufRead,TempRead:LongInt;
{----}

procedure WriteByte(A:Byte);
begin
  OutStream.Write(A,1);
end;

{----}

procedure WriteInt(A:LongInt);
begin
  OutStream.Write(A,SizeOF(LongInt));
end;

{----}

procedure CompressBuf(Var aInBuf,aUseBuf;BufSize,UseSize,MaxLev:LongInt);
Var
  dat:TDiffCompData;
  obufsize,ospbufsize:LongInt;
begin
    Dat.OutBuf     :=OutBuf;
    Dat.OutSpBuf   :=OutSpBuf;
    With dat do
    begin
       InBuf      :=@TByteArray(aInBuf);
       UseBuf     :=@TByteArray(aUseBuf);
       InBufSize  :=BufSize;
       UseBufSize :=UseSize;
       MaxLevel   :=MaxLev;
       MaxLength  :=65535;
       MinLength  :=20;
       OutBufSize :=@obufsize;
       OutSpBufSize:=@ospbufsize;
       EnoughLen:=1024;
       NotifyProc := Notify;
    end;
    obufsize:=0;
    ospbufsize:=0;
    DiffCompress(Dat);

    WriteInt(OBufSize);
    WriteInt(OSpBufSize);
    OutStream.Write(OutBuf^,OBufSize);

    OutStream.Write(OutSpBuf^,OSpBufSize);
end;

label l1;

{----}

begin
  GetMem(Buf,BufSize);
  GetMem(Temp,BufSize);
  GetMem(OutBuf,BufSize);
  GetMem(OutSpBuf,BufSize);
  try
    BufRead:=1;
    While BufRead<>0 do
    begin
      BufRead:=InStream.Read(Buf^,BufSize);
      TempRead:=UseStream.Read(Temp^,BufSize);
      {--}
      WriteInt(TempRead);
      If (BufRead<4) or (TempRead<4) or (BufRead div 4>TempRead) then
      begin
        WriteByte(0); {block copied flag}
        WriteInt(BufRead);
        if bufread=0 then goto l1;
        WriteInt(CalculateCRC32(Buf^[1],Bufread));
        OutStream.Write(Buf^,BufRead);
      end else
      begin
        WriteByte(1);{block compressed flag}
        WriteInt(CalculateCRC32(Buf^[1],Bufread));
        WriteInt(CalculateCRC32(Temp^[1],Tempread));
        CompressBuf(Buf^,Temp^,BufRead,TempRead,MaxLev);
      end;
      l1:
    end;
  finally
    FreeMem(OutBuf,BufSize);
    FreeMem(OutSpBuf,BufSize);
    FreeMem(Buf,BufSize);
    FreeMem(Temp,BufSize);
  end;
end;

{-------------------------------------------------}

procedure DiffStreamExtract(InStream,UseStream,OutStream:TStream;Notify:TMyProcedure);
Var
   Buf,Temp,OutBuf,OutSpBuf:PByteArray;
   curoutpos,BufRead,TempRead:LongInt;

{----}

Function ReadByte:Byte;
begin
  InStream.Read(Result,1);
end;

{----}

Function ReadInt:LongInt;
begin
  InStream.Read(Result,SizeOF(LongInt));
end;

{----}

procedure ExtractBuf;
Var
  obufsize,ospbufsize:LongInt;
  p:parrayt3word;
  d,er,len,useofs,bufofs,i,psize:LongInt;
begin
    OBufSize:=ReadInt;
    OSpBufSize:=ReadInt;

    InStream.Read(Buf^,OBufSize);
    InStream.Read(OutSpBuf^,OSpBufSize);
    p:=pointer(OutSpBuf);
    psize:=OSpBufSize div sizeof(t3word);
    er:=1;
    curoutpos:=1;
    For i:=0 to PSize-1 do
    begin
      if (i mod 16 = 0) and Assigned(Notify) then
        if (BufSize < UseStream.Size div 2) then
          Notify(UseStream.Position,UseStream.Size)
        else
          Notify(i,PSize);

      len:=p^[i].len;
      useofs:=p^[i].useofs;
      bufofs:=p^[i].bufofs;

      d:=BufOfs-CurOutPos;
      If d<>0 then
      begin
{$IFDEF Win32}
        Move(Buf[er],OutBuf[CurOutPos],d);
{$ELSE}
        if d > 0 then
          Move(Buf^[er],OutBuf^[CurOutPos],d);
{$ENDIF}
        inc(er,d);
        inc(CurOutPos,d);
      end;
{$IFDEF Win32}
      Move(Temp[UseOFs],OutBuf[CurOutPos],Len);
{$ELSE}
      if Len > 0 then
        Move(Temp^[UseOFs],OutBuf^[CurOutPos],Len);
{$ENDIF}
      inc(CurOutPos,len);
    end;
end;
{----}

Var CRC,BufCRC:LongInt;
label l1;
begin
  try
    GetMem(Buf,BufSize);
    GetMem(Temp,BufSize);
    GetMem(OutBuf,BufSize);
    GetMem(OutSpBuf,BufSize);
    BufRead:=1;
    While BufRead<>0 do
    begin
       TempRead:=ReadInt;
       UseStream.Read(Temp^,Tempread);
       Case ReadByte of
         0: begin {copy}
              BufRead:=ReadInt;
              If bufread=0 then goto l1;
              CRC:=ReadInt;
              InStream.Read(Buf^,Bufread);
              If CRC<>CalculateCRC32(Buf^[1],Bufread) then
                raise Exception.Create('CRC Error');
              OutStream.Write(Buf^,BufRead);
            end;
         1: begin {extract}
              BufCRC:=ReadInt;
              CRC:=ReadInt;{tempcrc}
              if CRC<>CalculateCRC32(Temp^[1],Tempread) then
                raise Exception.Create('CRC Error');
              ExtractBuf;
              If BufCRC<>CalculateCRC32(OutBuf^[1],CurOutPos-1) then
                raise Exception.Create('CRC Error');
              OutStream.Write(OutBuf^,CurOutPos-1);
            end;
         else raise Exception.Create('CRC Error');
       end;
    l1:
    end;
  finally
    FreeMem(OutBuf,BufSize);
    FreeMem(OutSpBuf,BufSize);
    FreeMem(Buf,BufSize);
    FreeMem(Temp,BufSize);
  end;
end;

{-------------------------------------------------}

Function CalcHash(a,b,c:LongInt):LongInt;
begin
  Result:=(a shl 7) xor (b shl 4) xor c;
end;

{-------------------------------------------------}
end.
