{  Main form for Update

  Copyright (c) 1998 Gregory L. Bullock (bullock@tsppd.com).
  Freeware: May be freely distributed and modified. Use at your own risk.
  This program draws heavily on

    - the aDiff unit, Copyright (c) 1997 S.Kurinny & S.Kostinsky

    - the Lh5Unit unit, which had various contributers, as noted in its
      source code

  History:
   14-12-99 Added ability to copy over any existing "old" file without
            first verifying that it passes the CRC version checking. This
            is equivalent to deleting the old file then adding the new one.

   18-11-99 Thanks to Jouko Tolonen for the following changes (adapted by
            Greg Bullock):
            Initialized OpenDialog.InitialDir more intelligently in
            BrowseChangesFileClick.
            Disabled GoBtn by default, enabling only when ChangesFile has
            the .Upd extension.

     4-5-99 Added option to update-all-or-nothing in case of failure.

    21-4-99 Thanks to Kurt Senfer for improving the organization of
            ApplyUpdateFile and for making changes to enable an auto-updating
            system, where some Auto-Updating applications on start-up test if
            there are pending updates (one or more), and prompt the user to
            say Yes or No to run an automatic update.  See the Help file for
            more information on using auto-update.

     3-4-99 Retired support for 16-bit compilation; it was getting too
            troublesome.
            Set the date/time of added and updated files to match the original.
            Add ability to add new files or delete obsolete files.
            Use the file sizes in addition to the CRCs to help identify files.
            Show progress bar for all files in addition to progress bar for
            the current file.

            Thanks to Jens Liebermann for figuring out how to maintain D2
            compatibility.

   28-10-98 Made Progress dialog get updated more frequently under 32-bits.

     3-7-98 Added a CRC for the *compressed* differences to better detect
            whether an .Upd is corrupted.

    16-5-98 Modified to compile under D3 (32-bits) as well as D1 (16-bits).

            Added a new compiler directive, MAKE16AND32COMPATIBLE, which
            will ensure that the *.Upd file is compatible independent
            of the platform (16- or 32-bit) which creates it or uses it.
            On the one test case I ran, I found that using MAKE16AND32COMPATIBLE
            increased the size of the *.Upd file.  The file sizes I got were
              29304  for the 32-bit .Upd file
              30746  for the 16-bit .Upd file
              30759  for the compatible .Upd file

            Improved one of the log messages and corrected the help file.

            Thanks to Jeremy Coulter for making changes so Update runs
            automatically when the user double clicks on a .Upd file in the
            Windows Explorer (provided Update is associated with the .Upd
            extension).

            Thanks to Massimiliano Orso, Kurt Senfer, Jeremy Coulter, Mavarik,
            Holger Dors, and Fabrice Avaux for reporting bugs and bug fixes.

    23-4-98 Initial version.

  If you fix any bugs or make significant enhancements, I ask you to send
  me your modifications.

  For example, at present, these programs support an auto-updating system over
  a LAN or WAN, but not over the WEB.  Perhaps a future version of these
  programs will enable Update to support auto-updating system over the WEB.

  If you make any changes to the structure of the Update File,
  change the UpdateFileHeader in the Common Unit so older versions
  of Update won't try to read an Update File that they won't understand.
}

unit UpdateFm;

interface

uses
  SysUtils, Windows, Graphics, Controls, Classes, Dialogs, StdCtrls,
  FileCtrl, Buttons, Forms, About, DoUpdate, UpdateGlobals;

type
  TUpdateForm = class(TForm)
    GoBtn: TBitBtn;
    CancelBtn: TBitBtn;
    OpenDialog: TOpenDialog;
    GroupBox1: TGroupBox;
    TargetFile: TLabel;
    TargetDirectoryListBox: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    GroupBox2: TGroupBox;
    ChangesFile: TEdit;
    BrowseChangesFile: TButton;
    AboutBtn: TBitBtn;
    procedure BrowseChangesFileClick(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure GoBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ChangesFileChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  UpdateForm: TUpdateForm;

implementation

{$R *.DFM}


procedure TUpdateForm.BrowseChangesFileClick(Sender: TObject);
begin
  if ChangesFile.Text = '' then
    OpenDialog.InitialDir := ExtractFileDir(Application.ExeName)
  else
  begin
    OpenDialog.FileName := ExtractFileName(ChangesFile.Text);
    OpenDialog.InitialDir := ExtractFileDir(ChangesFile.Text);
  end;

  if OpenDialog.Execute then
    ChangesFile.Text := AnsiLowerCase(OpenDialog.FileName);
end;

procedure TUpdateForm.AboutBtnClick(Sender: TObject);
begin
  AboutBox := TAboutBox.Create(Self);
  AboutBox.ShowModal;
  AboutBox.Free;
  AboutBox := nil;
end;

procedure TUpdateForm.GoBtnClick(Sender: TObject);
begin
	Targetdir := AnsiLowerCase(TargetDirectoryListBox.Directory);

	if Targetdir = ''
		then begin
  		TargetDir := GetCurrentDir;
  		TargetDirectoryListBox.Directory := Targetdir;
  	end;
  if Targetdir[Length(Targetdir)] <> '\'
    then Targetdir := Targetdir + '\';

  ApplyUpdateFile(ChangesFile.Text);
end;

procedure TUpdateForm.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TUpdateForm.FormShow(Sender: TObject);
begin
  Show;
  //KS obsolete under win32 -> Application.ProcessMessages;
  if ParamStr(1) > '' then
  begin
    ApplyUpdateFile(ParamStr(1));
    Application.Terminate;
  end;
end;

procedure TUpdateForm.ChangesFileChange(Sender: TObject);
begin
  GoBtn.Enabled := AnsiCompareText(ExtractFileExt(ChangesFile.Text), '.'+OpenDialog.DefaultExt) = 0;
end;

end.
