unit Progress;

interface

uses Windows, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Gauges, ExtCtrls;

type
  TProgressDlg = class(TForm)
    Bevel1: TBevel;
    ProgressBar: TGauge;
    Label1: TLabel;
    FileNameLabel: TLabel;
    Label2: TLabel;
    GeneralProgressBar: TGauge;
  private
    { Private declarations }
    FCurrentCompleted,
    FCompleted,
    FTotal      : LongInt;
    procedure SetCompleted(Value: LongInt);
    procedure SetTotal(Value: LongInt);
    procedure SetCurrentCompleted(Value: LongInt);
  public
    { Public declarations }
    CurrentTotal  : longint;
  published
    property CurrentCompleted  : LongInt read FCurrentCompleted write SetCurrentCompleted;
    property Completed  : LongInt read FCompleted write SetCompleted;
    property Total      : LongInt read FTotal write SetTotal;
  end;

procedure UpdateCurrentProgress(Completed, Total: LongInt); far;

var
  ProgressDlg: TProgressDlg;

implementation

{$R *.DFM}

procedure UpdateCurrentProgress(Completed, Total: LongInt);
begin
  ProgressDlg.CurrentTotal := Total;
  ProgressDlg.CurrentCompleted := Completed;
end;

procedure TProgressDlg.SetCurrentCompleted(Value: LongInt);
begin
  FCurrentCompleted := Value;
  if CurrentTotal > 0 then
    ProgressDlg.ProgressBar.Progress := MulDiv(FCurrentCompleted,100,CurrentTotal);
  if FTotal > 0 then
    GeneralProgressBar.Progress := MulDiv(FCompleted + FCurrentCompleted,100,FTotal);
  Application.ProcessMessages;
end;

procedure TProgressDlg.SetCompleted(Value: LongInt);
begin
  FCompleted := Value;
  if FTotal > 0 then
    GeneralProgressBar.Progress := MulDiv(FCompleted + FCurrentCompleted,100,FTotal);
  Application.ProcessMessages;
end;

procedure TProgressDlg.SetTotal(Value: LongInt);
begin
  FTotal := Value;
  if FTotal > 0 then
    GeneralProgressBar.Progress := MulDiv(FCompleted,100,FTotal);
end;

end.
