{  Main unit fore Auto Updating

  1999 Kurt Senfer  (ks@siemens.dk).
  Freeware: May be freely distributed and modified. Use at your own risk.

  History:

  19-04-99 Initial version.

  This unit contains some code snipers that I have found on the web over the years,
  but I haven't kept track of who wrote them - but I only use code that is freeware.
  	SearchForFiles
     fileExec
     regParsePath
     regWriteString
     regReadString

    -----------------------

  Fore some years I have managed a lot of files and applications that all together
  form a quality-management- and information system I a company with about 1000 employees.

  All the files is placed on a WAN, and everyone vas using the files directly on the
  WAN-fileservers - but then there came a lot of notebook-PC's and home-working PC's.
  I had to come up wit a solution to let people download those parts of the system that
  they needed in there daily work - but on the other hand also be absolutely sure that they
  used the newest version of everything.

  Luckily I found Greg's MakeUpd applications on the web, and wit this as a starting point
  it was quick and easy to lay out the AutoUpdate systematic.
}


unit KSAutoUpdate;

interface
uses
  Windows, SysUtils, Classes, aCRC32, common, LH5unit,ADiff, Progress,
  LogForm, Forms, Controls, UpdateGlobals, Dialogs, FileCtrl, Registry;

Function AutoUpdate: boolean;

Procedure AutoUpdateFinish(ChangesFileName: string);

implementation
uses
  DoUpdate, UpdateFm;

var
  ExeFil     : string;
  WriteLogFile : boolean = True;  

{*************************************************************************}

procedure SearchForFiles(path, mask: AnsiString; var Value: TStringList; Recurse: Boolean);
//path = rootdir
//fileMask = *.db, *.*, ....osv
//value = stringlist to recive the result of the search
//Recurse = True -> recursing of folders beneath path
var
srRes : TSearchRec;
iFound : Integer;
begin
if (Recurse) // First, we must search the directories
  then begin
    if path[Length(path)] <> '\' then path := path +'\';
      iFound := FindFirst(path + '*.*', faAnyfile, srRes);
      while iFound = 0 
       do begin
          if (srRes.Name <> '.') and (srRes.Name <> '..')
             then if srRes.Attr and faDirectory > 0
                then SearchForFiles(path + srRes.Name, mask, Value, Recurse);//recurse folder
          iFound := FindNext(srRes);
        end;
    FindClose(srRes);
  end;

// Now, we don't treat the directories anymore

if path[Length(path)] <> '\' then path := path +'\';

iFound := FindFirst(path + mask, faAnyFile-faDirectory, srRes);
while iFound = 0
  do begin
    if (srRes.Name <> '.') and (srRes.Name <> '..') and (srRes.Name <> '')
       then Value.Add(path + srRes.Name);
      iFound := FindNext(srRes);
  end;

FindClose(srRes);

end;

{*************************************************************************}
function fileExec(const aCmdLine: String; aHide, aWait,bWait: Boolean): Boolean;
//Executes a file and waits as specified
//aWait = wait for InputIdle, bWait = wait for the program to stop
var
  StartupInfo : TStartupInfo;
  ProcessInfo : TProcessInformation;
begin
  {setup the startup information for the application }
  FillChar(StartupInfo, SizeOf(TStartupInfo), 0);
  with StartupInfo do
  begin
    cb:= SizeOf(TStartupInfo);
    dwFlags:= STARTF_USESHOWWINDOW or STARTF_FORCEONFEEDBACK;
    if aHide then wShowWindow:= SW_HIDE
             else wShowWindow:= SW_SHOWNORMAL;
  end;

  Result := CreateProcess(nil,PChar(aCmdLine), nil, nil, False,
               NORMAL_PRIORITY_CLASS, nil, nil, StartupInfo, ProcessInfo);

  if aWait and Result
    then begin
      WaitForInputIdle(ProcessInfo.hProcess, INFINITE);
         if bWait
          then WaitForSingleObject(ProcessInfo.hProcess, INFINITE);end;

end;



{*************************************************************************}

function strPadZeroL(const S: String; Len: Integer): String;
//Fills leading Zeroes into a string up to a specified length
begin
  Result:=Trim(S);

  while Length(Result) < Len do
    Result:='0' + Result;

end;

{*************************************************************************}

procedure regParsePath(const Path: String; var aPath, aValue: String);
begin
  aPath:=Path;
  aValue:= '';
  while (Length(aPath)>0) and (aPath[Length(aPath)]<>'\') do
    begin
        aValue:=aPath[Length(aPath)]+aValue;
        if Length(aPath) > 0
          then Delete(aPath,Length(aPath),1);
    end;
end;

{*************************************************************************}

Function regWriteString(aKey: HKEY; const Path,Value: String):Boolean;
var
  aRegistry : TRegistry;
  aPath     : String;
  aValue    : String;
begin
  aRegistry:=TRegistry.Create;//HKEY_CURRENT_USER is default
  try
    with aRegistry do
    begin
      if aKey <> 0 then RootKey:=aKey;
      regParsePath(Path, aPath, aValue);
      Result := OpenKey(aPath,True);
      WriteString(aValue,Value);
    end;
  finally
    aRegistry.Free;
  end;
end;

{*************************************************************************}


function regReadString(aKey: HKEY; const Path: String): String;
//NB remember the default value is read through a path with a trailing '\'
var
  aRegistry : TRegistry;
  aPath     : String;
  aValue    : String;
begin
  aRegistry:=TRegistry.Create;//HKEY_CURRENT_USER is default
  try
    with aRegistry do
    begin
      if aKey <> 0 then RootKey:=aKey;
      regParsePath(Path, aPath, aValue);
      OpenKey(aPath,True);
      Result:=ReadString(aValue);
    end;
  finally
    aRegistry.Free;
  end;
end;


{*************************************************************************}

Function AutoUpdate: boolean;
var
  UpdFil, RegKey, RegKeyValue, UpdFilesPath, StartOfUpdFil, ActualUpdFile: string;
  I, ParamNr, StringListPointer, UpdFilNumber: integer;
  FileList: TStringList;
  MoreFiles: boolean;
  ParamError: boolean;
begin

{Update.exe can be called with up to 4 params
 param 1 = Upd-file for example, [FilePath]\Telefon???.upd
 param 2 = TargetDir -> directory in which files are to be processed
 param 3 = Registry key to ???-upd-files
 param 4 = exe-fil to execute after Update.exe is finished - normally the calling program}

Result := False; //presume - not an auto update call

if paramCount < 2 //Auto Update uses at least 2 params
  then exit;

Result := True; //it is an auto Update call
itsAutoUpdate := True;


UpdFil := ParamStr(1);
if '.UPD' <> upperCase(ExtractFileExt(UpdFil))
  then begin
    MessageDlg('The first parameter:'+#10#13+UpdFil+#10#13+'is not an .Upd-file.', mtError, [mbOK], 0);
    ParamError := True; //continue and look for a re-exe-fil
  end
  else begin
     UpdFilesPath := ExtractFilePath(UpdFil);
     UpdFil := ExtractFileName(UpdFil);
  end;


TargetDir := ParamStr(2); //targetDir is a global var
if (Length(Targetdir) > 0) and (Targetdir[Length(Targetdir)] <> '\')
  then Targetdir := Targetdir + '\';

if not DirectoryExists(TargetDir)
  then begin
    MessageDlg('TargetDir:'+#10#13+TargetDir+#10#13+'does not exist.', mtError, [mbOK], 0);
    ParamError := True; //continue to look for a re-exe-fil
  end;

ParamNr := 3;


I := pos('???', UpdFil);
if I > 0
  then begin // then we must also get a registry key
    RegKey := ParamStr(ParamNr);
     inc(ParamNr);
    RegKeyValue := RegReadString(HKEY_LOCAL_MACHINE, RegKey);
    If (RegKeyValue <> '') and (length(RegKeyValue) <> 3)
      then begin
           MessageDlg('RegKeyValue:'+#10#13+RegKeyValue+#10#13+'does not contain a three-digit number', mtError,[mbOK], 0);
        ParamError := True; //continue and look for an re-exe-fil
        end
        else begin
          StartOfUpdFil := copy(UpdFil, 1, I-1); //part of filename before ???
           val(RegKeyValue, UpdFilNumber, I) ; //RegKeyValue to integer -> UpdFilNumber
           inc(UpdFilNumber); //we shall use the next number in the row evt. 001
           ActualUpdFile := StartOfUpdFil + strPadZeroL(IntToStr(UpdFilNumber), 3)+'.upd';
           if not FileExists(UpdFilesPath + ActualUpdFile)
             then begin // there doesn't exist an upd-fil with a higher number than the regKey
                if UpdFilNumber = 1
                   then begin
                      MessageDlg('The file:'+#10#13+UpdFilesPath + ActualUpdFile+#10#13+'doesn''t exist (anymore)',mtError, [mbOK], 0);
                       ParamError := True; //continue and look for an re-exe-fil
                    end
                    else MessageDlg('There is no newer .Upd-file than:'+#10#13+UpdFilesPath+ StartOfUpdFil + RegKeyValue+'.Upd', mtError, [mbOK], 0);
            ParamError := True;  //continue and look for an re-exe-fil
             end;
           MoreFiles := true;
        end;
  end
  else ActualUpdFile := UpdFil;


if ParamCount >= ParamNr //presumably we have an exe-file to execute after Update.exe is finished
  then begin
    ExeFil := ParamStr(ParamNr);
     if not FileExists(ExeFil)
      then begin
           MessageDlg('The EXE-file:'+#10#13+ExeFil+#10#13+'doesn''t exist', mtError, [mbOK], 0);
        ParamError := True;
        end;
  end;

if ParamError  //we can't do an update
  then exit;


//we now have all necessary information to apply the upd-file

ProgressDlg.Caption := 'Updating files in: '+ Targetdir;

if not MoreFiles
  //the upd-file is an exact defined file (no ???)
  then ApplyUpdateFile(UpdFilesPath + ActualUpdFile) //Do the Updating

  else begin //it is an upd-fil with a running number
    //Find upd-fil with succeeding number
    FileList := TStringList.Create;
    try
       //find all files with the mask "UpdFil" and put them into FileList
      SearchForFiles(UpdFilesPath, UpdFil, FileList, false);
        if FileList.Count = 0
        then begin //ther is no upd-fil with the right mask
              MessageDlg('There are no .Upd-files that match the mask:'+#10#13+UpdFil, mtError, [mbOK], 0);
              Exit;
           end
           else begin
           FileList.Sort;//Now the highest version of "updatefil"???.upd is last in list

              //find ActualUpdFile in the stringlist -> we know it exists from "I := pos('???', UpdFil);"
              if not FileList.Find(UpdFilesPath + ActualUpdFile, StringListPointer) // StringListPointer points to ActualUpdFile if it exists
                then begin //it should be there ??
                    MessageDlg('Internal error:'+#10#13+ ActualUpdFile+#10#13+ 'is not in stringlist', mtError, [mbOK], 0);
                  Exit;
                 end;

              // ActualUpdFile is pointed to from "StringListPointer"
          while StringListPointer < FileList.Count do  //the last string is in FileList.Count-1
                 begin //as long as we have a succeeding number in the row of upd-files, then apply upd-file
                    //check if the next succeeding number of the upd-files exists
                    if  AnsiUpperCase(UpdFilesPath + ActualUpdFile) <> AnsiUpperCase(FileList.Strings[StringListPointer])
                      then begin //the file doesn't exists
                          MessageDlg('There is an missing file in the row of .Upd-files'+#10#13+'The file:'+#10#13+ActualUpdFile+#10#13+ 'doesn''t exists', mtError, [mbOK], 0);
                      Exit;
                       end;

                   ApplyUpdateFile(UpdFilesPath + ActualUpdFile); //aply the upd-file
                   if UpdateError  then exit;

                   //register the used upd-file number in the registry
                    RegWriteString(HKEY_LOCAL_MACHINE, RegKey, strPadZeroL(IntToStr(UpdFilNumber), 3));

                    inc(UpdFilNumber);
                 	ActualUpdFile := StartOfUpdFil + strPadZeroL(IntToStr(UpdFilNumber), 3) +'.upd';

                    //next succeeding number of upd-files
                    inc(StringListPointer);
              end; //while

        end; //if FileList.Count = 0

    finally
      FileList.Free;
    end;
  end; //if not MoreFiles


  UpdLogForm.Hide;

  if ExeFil <> ''
    then begin
       chdir(ExtractFileDir(Exefil));
        fileExec(Exefil, False, False, False);
     end;

end;


{*************************************************************************}

Procedure AutoUpdateFinish(ChangesFileName: string);
var
  S: string;
begin
  //write to log-fil
  S := ExTractFileName(ChangesFileName);
  if not UpdateError
    then begin //Updating was done succesfully
       if WriteLogFile
          then UpdLogForm.LogMessage.Lines.SaveToFile(Targetdir + ChangeFileExt(S, '.log'))
     end
     else begin //Updating has caused an error
       if WriteLogFile
          then UpdLogForm.LogMessage.Lines.SaveToFile(Targetdir + ChangeFileExt(S, '.err'));

        UpdLogForm.Caption := 'Error in Update !';
        UpdLogForm.ShowModal;
     end;

end;


{*************************************************************************}


end.
