unit LZBitmap;
{*************************************************************************}
{   Borland Delphi 2.0 Unit "LZBitmap" permits you to reduce disk space   }
{     needed for your application, by using BMP files compressed with     }
{             Microsoft Compress.exe, or compatible utility.              }
{                                                                         }
{            Author: Arkadiusz Pawlik arpawlik@poczta.onet.pl;            }
{                      Version 1.00; 2005.02.20.                          }
{*************************************************************************
Class TLZBitmap using Windows LZexpand routines decompress to memory BMP file,
which is compressed with MS "Compress.exe" or compatible utility.
You can download the Compress.exe file from the Microsoft FTP-site
(please read the legal notice when doing so):
ftp://ftp.microsoft.com/Softlib/MSLFILES/CP0982.EXE
Example of compression command: Compress.exe -r file.bmp
In memory are created HBitmap and HPalete objects (encapsulated as Handle and
Palette fields). You can draw created TLZBitmap object in window your application,
or to copy him to TBitmap Object.

Public fields of TLZBitmap class:
---------------------------------

Handle:HBitmap;   //HBitmap Object handle
Palette:HPalette; //HPalette Object handle
Width,            //Width of the Bitmap
Height:integer;   //Height of the Bitmap
Empty:boolean;    //is Bitmap empty?

Public methods of TLZBitmap class:
----------------------------------

//Creating Object
Constructor Create;
//Loading bitmap from archive and creating HBitmap and HPalette
procedure LoadFromFile(const FileName:String); virtual;
//Drawing HBitmap in device context
procedure Draw(DC:hdC;x,y:integer); virtual;
//Transferring Handles to TBitmap object, and calling Destructor
procedure CopyToTBitmapAndSelfFree(ABitmap:TBitmap); virtual;
//Destroying Object
Destructor Destroy; override;

How to use LZBitmap unit:
------------------------

Example 1:
----------

uses LZBitmap;
(...)
var
   MyLZBitmap:TLZBitmap;
   MyBitmap:TBitmap;
(...)
begin
MyLZBitmap:=TLZBitmap.Create;
MyBitmap:=TBitmap.Create;
MyLZBitmap.LoadFromFile('file.bm_');
MyLZBitmap.CopyToTBitmapAndSelfFree(MyBitmap);
Form1.Image1.Picture:=MyBitmap;
end;
(...)
MyLZBitmap.Free; //Error: Access violation!!!- MyLZBitmap was removed from memory by CopyToTBitmapAndSelfFree.
MyBitmap.Free;
(...)

Example 2:
----------

uses LZBitmap;
(...)
var MyLZBitmap:TLZBitmap;
(...)
begin
MyLZBitmap:=TLZBitmap.Create;
MyLZBitmap.LoadFromFile('file.bm_');
MyLZBitmap.Draw(Form1.Canvas.Handle,10,10);
MyLZBitmap.Free;
end;
(...)

Example 3:
----------

uses LZBitmap;
(...)
var MyLZBitmap:TLZBitmap;
    LZDC:HDC;
(...)
begin
LZDC:=CreateCompatibleDC(Canvas.Handle);
MyLZBitmap:=TLZBitmap.Create;
MyLZBitmap.LoadFromFile('file.bm_');
SelectObject(LZDC,MyLZBitmap.Handle);
BitBlt(Canvas.Handle,20,20,LZBitmapa.Width,LZBitmapa.Height,LZDC,0,0,SRCCOPY);
DeleteDC(LZDC);
end;
(...)
MyLZBitmap.Free;

You can use following code on your own risk.
!!!Warn copyright: Do not distribute compress.exe utility with your programm!!!
You can freely modify following code, but describe here all changes.}
{*************************************************************************}


interface
uses LZExpand,Windows,SysUtils,Graphics;


Type TLZBitmap=class(TObject)
private
LZOutputBuffer:Pointer;
ScreenDC:hDC;
LZFileName:Array[0..255] of char;
LZFileHandle:integer;
//lz file characteristics
LZOfStruct:TOfStruct;
//buffer for decompressed data
LZOutputBufferSize:integer;
//BmpFile decompressed to LZOutputBuffer
BmpMemoryFileSize:integer;
BmpMemoryFileHeader:PBitmapFileHeader;
MemoryBitmapInfoHeader:PBitmapInfoHeader;
MemoryLogPalette:PLogPalette;
MemoryBitmapInfo:PBitmapInfo;
PreviousPalette:HPalette;
//szerokosc mapy DIB
DibMapSize:Longint;
HowManyColors:integer;
WasCopiedHandle:boolean;
Pixels:Pointer;
public
//DDB handle
Handle:HBitmap;
//Palette Handle
Palette:HPalette;
Width,Height:integer;
Empty:boolean;
private
function SetLZOutputBuffer(Size:DWORD):integer; virtual;
procedure UnSetLZOutputBuffer; virtual;
function CheckLZFile(LZFHandle:integer):DWORD; virtual;
public
Constructor Create;  
procedure LoadFromFile(const FileName:String); virtual;
procedure Draw(DC:hdC;x,y:integer); virtual;
procedure CopyToTBitmapAndSelfFree(ABitmap:TBitmap); virtual;
Destructor Destroy; override;
end;

implementation

Constructor TLZBitmap.Create;
begin
inherited Create;
end;

//setting lz buffer
function TLZBitmap.SetLZOutputBuffer(Size:integer):integer;
begin
LZOutputBuffer:=nil;
GetMem(LZOutputBuffer,Size);
if LZOutputBuffer=nil then Result:=0 else Result:=Size;
end;
//deleting lz buffer
procedure TLZBitmap.UnSetLZOutputBuffer;
begin
if (LZOutputBuffer<>nil) then
try
Freemem(LZOutputBuffer,LZOutputBufferSize);
finally
end;{try}
end;

//Is compressed BMP?  & get uncompressed filesize
function TLZBitmap.CheckLZFile(LZFHandle:integer):DWORD;
var TempBitmapFileHeader:TBitmapFileHeader;
    Readed:integer;
begin
if LZFHandle>0 then
begin
if LZSeek(LZFHandle,0,0)=0 then
begin
Readed:=LZRead(LZFileHandle,@TempBitmapFileHeader,SizeOf(TBitmapFileHeader));
if Readed=SizeOf(TBitmapFileHeader) then
begin
if TempBitmapFileHeader.bfType=makeWord(Byte('B'),Byte('M')) then
begin
LZSeek(LZFHandle,0,0);
Result:=TempBitmapFileHeader.bfSize;
end else Result:=0;
end else Result:=0;
end else Result:=0;
end else Result:=0;{if}
end;

//Creating bitmap in memory
procedure TLZBitmap.LoadFromFile(const FileName:String);
var TempbiClrImportant:DWORD;//temporary for create palette
label error,goend;
begin
if Handle>0 then Exit;
StrPCopy(LZFileName,FileName);
LZFileHandle:=LZOpenFile(LZFileName,LZOfStruct,OF_READ);
if LZFileHandle<0 then goto error;
//Getting size for LZbuffer 
LZOutputBufferSize:=CheckLZFile(LZFileHandle);
if LZOutputBufferSize=0 then
begin
LZClose(LZFileHandle);
goto error;
end;{if}
if LZOutputBuffer=nil then if SetLZOutputBuffer(LZOutputBufferSize)=0 then goto error;
//readind lz data
BmpMemoryFileSize:=LZRead(LZFileHandle,LZOutputBuffer,LZOutputBufferSize);
//close lz file
LZClose(LZFileHandle);
if BmpMemoryFileSize<=0 then goto error;
//Processing BMP file in memory
BmpMemoryFileHeader:=ptr(DWORD(LZOutputBuffer));
//evaluating Dib map Size
DibMapSize:=BmpMemoryFileHeader^.bfSize-SizeOf(TBitmapFileHeader);
//setting Dib Map
MemoryBitmapInfoHeader:=ptr(DWORD(LZOutputBuffer)+SizeOf(TBitmapFileHeader));
//Compressed Bitmap? - goto error
if MemoryBitmapInfoHeader^.biCompression<>BI_RGB then goto error;
DWORD(MemoryBitmapInfo):=DWORD(MemoryBitmapInfoHeader);
//reading Dib
Width:=MemoryBitmapInfoHeader^.biWidth;
Height:=MemoryBitmapInfoHeader^.biHeight;
//HowManyColors?
if MemoryBitmapInfoHeader^.biClrUsed<>0 then HowManyColors:=MemoryBitmapInfoHeader^.biClrUsed else
Case MemoryBitmapInfoHeader^.biBitCount of
1:HowManyColors:=2;
4:HowManyColors:=16;
8:HowManyColors:=256;
else
HowManyColors:=0;//24-bit
end;{Case}
//Setting palette of colors
if Palette<>0 then
begin
DeleteObject(Palette);
Palette:=0;
end;{if}
if HowManyColors>0 then
begin
//LogPalette begins Dword before first paletteentry
TempbiClrImportant:=MemoryBitmapInfoHeader^.biClrImportant;
MemoryLogPalette:=Ptr(DWORD(LZOutputBuffer)+SizeOf(TBitmapFileHeader)+
SizeOf(TBitmapInfoHeader)-SizeOf(DWORD)); //SizeOf(biClrImportant);
MemoryLogPalette^.palVersion:=$300;  //0x300
MemoryLogPalette^.palNumEntries:=HowManyColors;
Palette:=CreatePalette(MemoryLogPalette^);
//returning old value
MemoryBitmapInfoHeader^.biClrImportant:=TempbiClrImportant;
end;{if}
//create DDB map
if Handle<>0 then DeleteObject(Handle);
Pixels:=Ptr(DWORD(LZOutputBuffer)+SizeOf(TBitmapFileHeader)+
SizeOf(TBitmapInfoHeader)+(SizeOf(TRGBQUAD)*HowManyColors));
PreviousPalette:=0;
//realizing new palette
ScreenDC:=CreateDC('DISPLAY',nil,nil,nil);
if Palette>0 then
begin
PreviousPalette:=SelectPalette(ScreenDC,Palette,FALSE);
RealizePalette(ScreenDC);
end;{if}
//DDB
if Handle<>0 then
begin
DeleteObject(Handle);
Handle:=0;
end;{if}
Handle:=CreateDiBitmap(ScreenDC,MemoryBitmapInfoHeader^,CBM_INIT,Pixels,
MemoryBitmapInfo^,DIB_RGB_COLORS);
if Handle=0 then goto Error;
//returning old palette;
if PreviousPalette>0 then SelectPalette(ScreenDC,PreviousPalette,FALSE);
DeleteDC(ScreenDC);
//free output lz buffer
UnSetLZOutputBuffer;
goto goend;
error:
//MessageDlg('Error: '+inttostr(GetLastError),mtError,[mbok],0);
UnSetLZOutputBuffer;
Empty:=true;
exit;
goend:
end;

//drawing bitmap in specified device context
procedure TLZBitmap.Draw(DC:hdC;x,y:integer);
var BitmapDC:hDC;
    PS:TPaintStruct;
begin
if Handle=0 then exit;
BitmapDC:=CreateCompatibleDC(DC);
SelectObject(BitmapDC,Handle);
PreviousPalette:=0;
if Palette>0 then
begin
PreviousPalette:=SelectPalette(DC,Palette,FALSE);
RealizePalette(DC);
end;{if}
//draw bitmap
BitBlt(DC,x,y,Width,Height,BitmapDC,0,0,SRCCOPY);
if PreviousPalette>0 then SelectPalette(DC,PreviousPalette,FALSE);
DeleteDC(BitmapDC);
end;

//transferring handles to Tbitmap object and calling destructor
procedure TLZBitmap.CopyToTBitmapAndSelfFree(ABitmap:TBitmap);
begin
if ABitmap<>nil then
begin
if Handle<>0 then
begin
if ABitmap.Handle<>0 then DeleteObject(ABitmap.ReleaseHandle);
if ABitmap.Palette<>0 then DeleteObject(ABitmap.ReleasePalette);
//transferring handles to TBitmap Object
ABitmap.Width:=Width;
Abitmap.Height:=Height;
ABitmap.Handle:=Handle;
ABitmap.Palette:=Palette;
//Preventing for deleting Objects in Destructor
WasCopiedHandle:=true;
end;{if}
end;{if}
if Self<>nil then Destroy;
end;

//deleting bitmap and palette objects and destroying TLZBitmap
Destructor TLZBitmap.Destroy;
begin
if WasCopiedHandle=false then
begin
if Handle>0 then
begin
DeleteObject(Handle);
Handle:=0;
end;
if Palette>0 then
begin
DeleteObject(Palette);
Palette:=0;
end;{if}
end else{if WasCopied}
begin
Handle:=0;
Palette:=0;
end;{else}
inherited Destroy;
end;

end.
