{

  See readme.txt for some info

}

unit LogMemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TLogMemo = class(TMemo)
  private
    Timer : TTimer;
    UseFile : boolean;
    f : text;

    FMaxLines : integer;
    FCheckTimeout : integer;
    FFileName : string;
    FFileAppend : boolean;

    procedure SetMaxLines(ml : integer);

    procedure LogMemoOnTimer(Sender : TObject);

  protected

  public
    constructor Create(AOWner : TComponent); override;
    procedure Start;
    procedure Stop;
    procedure AddLine(const S : string);

  published
    property MaxLines : integer read FMaxLines write SetMaxLines;
    property CheckTimeout : integer read FCheckTimeout write FCheckTimeout;
    property FileName : string read FFileName write FFileName;
    property FileAppend : boolean read FFileAppend write FFileAppend;

  end;

procedure Register;

implementation

{$R logmemo.dcr}

procedure Register;
begin
  RegisterComponents('ZP Comps', [TLogMemo]);
end;

constructor TLogMemo.Create;
begin
  inherited Create(AOwner);
  Color := clInactiveBorder;
  ReadOnly := TRUE;
  FMaxLines := 100;
  FCheckTimeout := 200;
  FFileName := '';
  FFileAppend := TRUE;
  Timer := TTimer.Create(Self);
  Timer.Enabled := FALSE;
  Timer.OnTimer := LogMemoOnTimer;
end;

procedure TLogMemo.SetMaxLines;
begin
  if ml > 0
    then FMaxLines := ml
    else FMaxLines := 100;
end;

procedure TLogMemo.LogMemoOnTimer;
var
  i, d : integer;
begin
  if Lines.Count > FMaxLines
    then begin
      Lines.BeginUpdate;
      d := Lines.Count - FMaxLines;
      for i := 1 to d do
        Lines.Delete(0);
      Lines.EndUpdate;
    end;
end;

procedure TLogMemo.Start;
begin
  if FFileName <> ''
    then begin
      UseFile := TRUE;
      AssignFile(f, FFileName);
      if FFileAppend and FileExists(FFileName)
        then Append(f)
        else Rewrite(f);
    end
    else UseFile := FALSE;

  Timer.Interval := FCheckTimeout;
  Timer.Enabled := TRUE;
end;

procedure TLogMemo.Stop;
begin
  Timer.Enabled := FALSE;
  if UseFile
    then CloseFile(f);
end;

procedure TLogMemo.AddLine;
begin
  Lines.Add(S);
  if UseFile
    then Writeln(f, S);
end;

end.
