{
  FileIO.pas

  Written by Frank Plagge
  Copyright (c) 1998 by Frank Plagge, Elsterweg 39, 38446 Wolfsburg, Germany
  All rights reserved

  Please send comments to plagge@positiv.escape.de

  V 1.01 - don't know the date
           first implementation, never trust a version 1.00 :-)

  *****************************************************************************
  Permission to use, copy,  modify, and distribute this software and its
  documentation without fee for any purpose is hereby granted, provided that
  the above copyright notice appears on all copies and that both that copyright
  notice and this permission notice appear in all supporting documentation.

  NO REPRESENTATIONS ARE MADE ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
  PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
  NEITHER FRANK PLAGGE OR ANY OTHER PERSON SHALL BE LIABLE FOR ANY DAMAGES
  SUFFERED BY THE USE OF THIS SOFTWARE.
  *****************************************************************************

   description:

   sorry, no description available. there are only some poor german comment.
   complete documentation will come as soon as possible

}

unit FileIO;

interface

const
  BufferSize    = 8192;

type
  TFile = class
          private
            FileHandle: file;
            Filename: string;
            Buffer: array[0..BufferSize-1] of Byte;
            BufferMin, BufferMax: LongInt;
            BufferPos: LongInt;
            function  ByteAvailable: Boolean;
            function  ByteInBuffer: LongInt;
            procedure ReadBuffer;
            procedure SkipData( DataByte: Byte );
          public
            constructor Open( aFilename: string );
            destructor  Close;
            procedure BlockRead( var ResultBuffer; ReadSize: Integer; var Transfered: Integer );
            function  Eof: Boolean;
            function  FilePos: LongInt;
            function  FileSize: LongInt;
            function  NextCh: Char;
            procedure ReadCh( var ch: Char );
            procedure ReadLn( var Line: string );
            procedure Seek( Position: LongInt );
          end;

implementation

uses SysUtils;

constructor TFile.Open( aFilename: string );
begin
  inherited Create;
  Filename := aFilename;
  System.Assign( FileHandle, aFileName );
  System.Reset( FileHandle, 1 );
  ReadBuffer;
end;

destructor TFile.Close;
begin
  System.Close( FileHandle );
  inherited Destroy;
end;

procedure TFile.BlockRead( var ResultBuffer; ReadSize: Integer; var Transfered: Integer );
var RestReadSize: Integer;
    BufferAsChar: ^Char;
    RecurseRead:  Integer;
begin
  { sind keine Daten mehr vorhanden, so mu ist nichts zu tun}
  if not ByteAvailable then begin
    Transfered := 0;
    Exit;
  end;
  { alle angeforderten Zeichen sind noch im Cachebuffer }
  if ByteInBuffer >= ReadSize then begin
    { kopiere die Anzahl anfegorderter Daten in den Ergebnisspeicher }
    Move( Buffer[BufferPos], ResultBuffer, ReadSize );
    { erhhe die akuelle Position im Cachebuffer }
    Inc( BufferPos, ReadSize );
    { es ist die angeforderte Anzahl Daten bertragen worden }
    Transfered := ReadSize;
  end else begin
    { berechne wieviele Daten fehlen }
    RestReadSize := ReadSize - ByteInBuffer;
    { kopiere die noch vorhandenen Daten in den Ergebnisspeicher }
    Move( Buffer[BufferPos], ResultBuffer, ByteInBuffer );
    { es wurden zumindest schon die vorhandenen Daten gelesen }
    Transfered := ByteInBuffer;
    { erhhe die aktuelle Position im Cachebuffer }
    Inc( BufferPos, ByteInBuffer );
    { es mssen Daten nachgeladen werden }
    ReadBuffer;
    { sind neue daten vorhanden, so wird rekusiv weitergelesen }
    if ByteInBuffer > 0 then begin
      { Zeiger innerhalb des Ergebnisspeichers fr den rekusiven Aufruf erzeugen }
      BufferAsChar := @ResultBuffer;
      { Zeiger entsprechend der bereits gelesenen Daten erhhen }
      Inc( BufferAsChar, Transfered );
      { Anzahl noch bentigter Daten lesen }
      BlockRead( BufferAsChar^, RestReadSize, RecurseRead );
      { Anzahl der gelesenen Zeichen des rekusiven Aufrufs addieren }
      Inc( Transfered, RecurseRead );
    end;
  end;
end;

function TFile.ByteAvailable: Boolean;
begin
  Result := not (ByteInBuffer = 0);
  { sind keine Daten mehr vorhanden, so mu nachgeladen werden }
  if not Result then begin
    ReadBuffer;
    { sind jetzt noch immer keine Daten vorhanden, so gibt es keine mehr }
    Result := not (ByteInBuffer = 0);
  end;
end;

function TFile.ByteInBuffer: LongInt;
begin
  Result := (BufferMax-BufferMin-BufferPos);
end;

function TFile.Eof: Boolean;
begin
  { das Dateiende ist erreicht, falls keine Daten mehr im Cachebuffer sind
    und das Ende der Datei erreicht ist }
  Result := (ByteInBuffer = 0) and (System.Eof(FileHandle));
end;

function TFile.FilePos: LongInt;
begin
  Result := BufferMin+BufferPos;
end;

function TFile.FileSize: LongInt;
begin
  Result := System.FileSize( FileHandle );
end;

function TFile.NextCh: Char;
begin
  Result := #0;
  if not ByteAvailAble then begin
    Exit;
  end else begin
    Result := Chr(Buffer[BufferPos]);
  end;
end;

procedure TFile.ReadBuffer;
var BlockResult: Integer;
begin
  if not System.Eof( FileHandle) then begin
    BufferMin := System.FilePos(FileHandle);
    System.BlockRead( FileHandle, Buffer, BufferSize, BlockResult );
    BufferMax := BufferMin+BlockResult;
    BufferPos := 0;
  end;
end;

procedure TFile.ReadCh( var ch: Char );
var Transfered: Integer;
begin
  BlockRead( ch, 1, Transfered );
  if Transfered = 0 then
    ch := #0;
end;

procedure TFile.ReadLn( var Line: string );
var First:       Integer;
    LineBuffer:  array[0..1024] of char;
begin
  Line := '';
  if not ByteAvailable then
    Exit;

  First := BufferPos;
  while not (Buffer[BufferPos] in [10,13]) do begin
    Inc( BufferPos, 1 );
    if ByteInBuffer = 0 then begin
      Move( Buffer[First], LineBuffer, BufferPos-First );
      LineBuffer[BufferPos-First] := #0;
      Line := Line + StrPas( LineBuffer );
      ReadBuffer;
      First := BufferPos;
      if Eof then
        Exit;
    end;
  end;
  Move( Buffer[First], LineBuffer, BufferPos-First );
  LineBuffer[BufferPos-First] := #0;
  Line := Line + StrPas( LineBuffer );
  case Buffer[BufferPos] of
    10 : begin
           SkipData( 10 );
           SkipData( 13 );
         end;
    13 : begin
           SkipData( 13 );
           SkipData( 10 );
         end;
  end;
end;

procedure TFile.Seek( Position: LongInt );
var CachePosition: LongInt;
begin
  CachePosition := BufferSize * (Position DIV BufferSize);
  System.Seek( FileHandle, CachePosition );
  ReadBuffer;
  BufferPos := Position-CachePosition;
end;

procedure TFile.SkipData( DataByte: Byte );
begin
  { sind keine Daten vorhanden, ist nicht zu tun }
  if not ByteAvailable then
    Exit;
  { nur wenn in der Eingabe das Vergleichszeichen steht ist etwas zu tun }
  if Buffer[BufferPos] = DataByte then begin
    { einfach den Zeiger innerhalb des Cachebuffers erhhen }
    Inc( BufferPos, 1 );
    { wurde dadurch der Cachebuffer leer, so wird nachgeladen }
    if ByteInBuffer = 0 then
      ReadBuffer;
  end;
end;


end.
