{
  ExampleMainform.pas

  Written by Frank Plagge
  Copyright (c) 1998 by Frank Plagge, Elsterweg 39, 38446 Wolfsburg, Germany
  All rights reserved

  Please send comments to plagge@positiv.escape.de

  V 1.01 - Jan 3rd, 1998
           first implementation, never trust a version 1.00 :-)

  *****************************************************************************
  Permission to use, copy,  modify, and distribute this software and its
  documentation without fee for any purpose is hereby granted, provided that
  the above copyright notice appears on all copies and that both that copyright
  notice and this permission notice appear in all supporting documentation.

  NO REPRESENTATIONS ARE MADE ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
  PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
  NEITHER FRANK PLAGGE OR ANY OTHER PERSON SHALL BE LIABLE FOR ANY DAMAGES
  SUFFERED BY THE USE OF THIS SOFTWARE.
  *****************************************************************************

   description:
   this is an example program for the usage of the TScanner component. it is
   possible to open and analyze a source file. the results are shown in the
   editor window
}

unit ExampleMainform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ToolWin, ComCtrls, StdCtrls, Scanner, Menus;

type
  TExampleForm = class(TForm)
    MainMenu: TMainMenu;
    Example1: TMenuItem;
    Load1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Scanner: TScanner;
    RichEdit: TRichEdit;
    ToolBar1: TToolBar;
    SpeedButton1: TSpeedButton;
    OpenDialog: TOpenDialog;
    procedure Load1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  ExampleForm: TExampleForm;

implementation

{$R *.DFM}

// this is the main method
procedure TExampleForm.Load1Click(Sender: TObject);
var i:         Integer; // counter for the number of read token
    ThisToken: TToken;  // working token
    ThisLine:  string;  // line for the editor
    RowStr:    string;  // row of a token as string
    ColStr:    string;  // column of a token as string
    TokenStr:  string;  // type of token as string
begin
  OpenDialog.Filename := '';                  // delete the filename
  if OpenDialog.Execute then begin            // if the dialog is closed with Ok button
    Scanner.Filename := OpenDialog.Filename;  // get the filename
    Scanner.Analyze;                          // analyze the file, that's all!!
    RichEdit.Lines.Clear;                     // clear the edit component
    for i := 1 to Scanner.Count do begin      // for all available token
      ThisToken := Scanner.Token[i-1];        // get the token at counter index
      ColStr := IntToStr(ThisToken.Column);   // convert the row to a string
      while Length(ColStr) < 5 do             // format the string to length 5
        ColStr := ' ' + ColStr;
      RowStr := IntToStr(ThisToken.Row);      // convert the column to a string
      while Length(RowStr) < 5 do             // format the string to length 5
        RowStr := ' ' + RowStr;
      case ThisToken.Token of                 // convert the token type to string
        ttComment     : TokenStr := 'comment     ';
        ttEof         : TokenStr := 'end of file ';
        ttError       : TokenStr := 'error       ';
        ttHexDecimal  : TokenStr := 'hex number  ';
        ttIdentifier  : TokenStr := 'identifier  ';
        ttInteger     : TokenStr := 'integer     ';
        ttKeyword     : TokenStr := 'keyword     ';
        ttReal        : TokenStr := 'real        ';
        ttSpecialChar : TokenStr := 'special char';
        ttString      : TokenStr := 'string      ';
      end;
      ThisLine := ColStr + ' ' + RowStr + ' ' + TokenStr + ' ' + ThisToken.Text;
      RichEdit.Lines.Add( ThisLine );         // add the line to the editor component
    end;
  end;
end;

// every time the eyes are using the programm too. a speedbutton is alway nice.
procedure TExampleForm.SpeedButton1Click(Sender: TObject);
begin
  Load1Click(Sender);
end;

end.
