unit WLblButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TWLblButton = class(TCustomLabel)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property Caption;
    Property Hint;
    Property ShowHint;
    procedure Paint; override;
    procedure DrawTextState(Style:boolean);
    property Font;
    Property Color;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
      procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
      Property OnClick;
    property Enabled;
    Property Visible;
  end;
{$R *.DCR}
procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('WAISS', [TWLblButton]);
end;

//------------------------------------------------------------------------------

 procedure TWLblButton.Paint;
 var v:integer;
 begin
 with canvas do
  begin

  brush.style:=bsClear;
  font.name:=self.Font.Name;
  font.size:=self.Font.size;
  font.style:=self.Font.Style;
  v:= TextHeight(caption)+6;
  if enabled = false then
  begin
  textout(2,2,caption);
  exit;
  end;
 if height < v then height := v;
 v:= TextWidth(caption)+6;
 if  width < v then width := v;
 drawtextstate(true);
 end;
 end;

 //------------------------------------------------------------------------------
 procedure Twlblbutton.drawtextstate(Style:Boolean);
 var
 top1,top2,central,bot1,bot2:TColor;

 Begin
  with canvas do
  begin
  brush.style:=bsClear;
  font.name:=self.Font.Name;
  font.size:=self.Font.size;
  font.style:=self.Font.Style;

  case style of
  True:
  begin
  font.color:= clSilver;
  textout(1,1,caption);
  font.color := clBlack;
  textout(5,5,caption);
  font.color:=clWhite;
  textout(2,2,caption);
  font.Color := clGray;
  textout(4,4,Caption);
  font.color :=clSilver;
  textout(3,3,caption);
     end;
  False:
     Begin
  font.color:= clgray;
  textout(1,1,caption);
  font.color := clsilver;
  textout(5,5,caption);
  font.Color := clWhite;
  textout(4,4,Caption);
  font.color:=clblack;
  textout(2,2,caption);
  font.color :=clSilver;
  textout(3,3,caption);
  end;
  end;
end;
 End;

//------------------------------------------------------------------------------
procedure TWlblButton.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
 begin
 drawtextstate(false);
 end;

//------------------------------------------------------------------------------
procedure Twlblbutton.Mouseup(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
 begin
 drawtextstate(true);
 inherited click;
 end;
 end.
