{***********************************************************
*          Label3dBorder version 1.0 - 32 bit               *
*     Copyright (C) April 22, 1997 Steen Hjelmstrand        *
*                                                           *
 ***********************************************************
* Label with possibility of setting 5 different kinds       *
*	of 3-dimensional borders and an option of vertical        *
* alignment of the caption.                                 *
*                                                           *
* Border:                                                   *
* Set "BorderStyle"-property in the ObjectInspector.        *
*                                                           *
* Vertical alignment of caption:                            *
* Set "VerticalAlign"-property in the ObjectInspector.      *
*                                                           *
* NOTICE:                                                   *
*	1) If you set the vertical alignment to "vaCenter" or     *
* "vaBottom" then wordwrapping is not possible. If Wordwrap *
* is set to "True" the setting will be ignored.             *
*                                                           *
* 2) This label has no "AutoSize"-property. I never use the *
* "AutoSize"-property myself, as I don't find it reliable,  *
* so I didn't want to waste my time implementing it.        *
* Sorry about that, if you happen to be an incarnated       *
* Autosize-user :-)                                         *
*                                                           *
* If you have comments or find bugs please email me:        *
* stone@image.dk                                            *
* Updates and other Delphi-stuff on                         *
* http://www.image.dk/~stone/delphi/                        *
*************************************************************}

unit Label3dB;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ExtCtrls;

type
  TBorderStyle = (bsNone, bsLight, bsMedium, bsHeavy, bsFrame, bsRaisedFrame);
  TVerticalAlign = (vaTop, vaCenter, vaBottom);

  TLabel3DBorder = class(TCustomLabel)
  private
		FVerticalAlign : TVerticalAlign;
		FBorderStyle : TBorderStyle;
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetVerticalAlign(Value: TVerticalAlign);
		procedure DoDrawText(var Rect: TRect; Flags: Word);
    { Private declarations }
  protected
    procedure Paint; override;

    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
    { Public declarations }
  published
    { new properties}
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle default bsNone;
    property VerticalAlign: TVerticalAlign read FVerticalAlign write SetVerticalAlign default vaTop;

    {  inherited properties }
    property Align;
    property Alignment;
    property Caption;
    property Color;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Visible;
    property WordWrap;

    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    { Published declarations }
  end;

procedure Register;

implementation

constructor TLabel3dBorder.Create;
begin
  inherited Create(AOwner);
	FBorderStyle := bsNone;
  AutoSize := False;
  Height := 21;
  Width := 84;
end;

procedure TLabel3dBorder.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
  WordWraps: array[Boolean] of Word = (0, DT_WORDBREAK);
  VerAlign: array[TVerticalAlign] of Word	=
  	(0, DT_VCENTER or DT_SINGLELINE, DT_BOTTOM or DT_SINGLELINE);
var
  Rect: TRect;
begin
  with Canvas do begin
    if not Transparent then begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
    Brush.Style := bsClear;
    Rect := ClientRect;
    case Ord(FBorderStyle) of
    	0:with Rect do InflateRect(Rect, -2, -2);
      1:begin
        Frame3D(Canvas, Rect, clBtnShadow, clBtnHighlight, 1);
        with Rect do InflateRect(Rect, -1, -1);
      end;
      2:begin
        Frame3D(Canvas, Rect, clBlack, clBtnHighlight, 1);
        with Rect do InflateRect(Rect, -1, -1);
   	  end;
      3:begin
     	  Frame3D(Canvas, Rect, clBtnShadow, clBtnHighlight, 1);
		  	Frame3D(Canvas, Rect, clBlack, clBtnFace, 1);
	    end;
      4:begin
        Frame3D(Canvas, Rect, clBtnShadow, clBtnHighlight, 1);
				Frame3D(Canvas, Rect, clBtnHighlight, clBtnShadow, 1);
      end;
      5:begin
				Frame3D(Canvas, Rect, clBtnHighlight, clBtnShadow, 1);
        Frame3D(Canvas, Rect, clBtnShadow, clBtnHighlight, 1);
      end;
    end;
    with Rect do InflateRect(Rect, -1, -1);
    DoDrawText(Rect, DT_EXPANDTABS or WordWraps[WordWrap] or
      Alignments[Alignment] or VerAlign[FVerticalAlign]);
  end;
end;

procedure TLabel3dBorder.DoDrawText(var Rect: TRect; Flags: Word);
var
  Text: string;
begin
  Text := GetLabelText;
  if (Flags and DT_CALCRECT <> 0) and ((Text = '') or ShowAccelChar and
    (Text[1] = '&') and (Text[2] = #0)) then Text := Text + ' ';
  if not ShowAccelChar then Flags := Flags or DT_NOPREFIX;
  Canvas.Font := Font;
  if not Enabled then Canvas.Font.Color := clGrayText;
  DrawText(Canvas.Handle, PChar(Text), Length(Text), Rect, Flags);
end;

procedure TLabel3dBorder.SetBorderStyle(Value: TBorderStyle);
begin
  if FBorderStyle <> Value then begin
		FBorderStyle := Value;
    Invalidate;
  end;
end;

procedure TLabel3dBorder.SetVerticalAlign(Value: TVerticalAlign);
begin
  if FVerticalAlign <> Value then begin
	  FVerticalAlign := Value;
    Invalidate;
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TLabel3DBorder]);
end;

end.
