
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{       TDSPanel                                        }
{                                                       }
{       Copyright (c) 1996,99 Iiraiida Koocklina        }
{                                                       }
{       Written by:                                     }
{         Iiraiida Koocklina                            }
{         KukVar LTD, Moscow, Russia                    }
{         e-mail: kukmeet@caravan.ru                    }
{         personal home page:                           }
{           http://www.caravan.ru/~kukmeet/index.html   }
{                                                       }
{*******************************************************}

unit DSPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DB, dbctrls;

type
 TDSPanel = class;

 TDBDSPanelLink = class(TDataLink)
 private
   FDSPanel: TDSPanel;
 public
   constructor Create(DSPanel: TDSPanel);
 end;

  TDSPanel = class(TPanel)
  private
    { Private declarations }
    FDataLink: TDBDSPanelLink;
    function GetDataSource: TDataSource;
    procedure SetDataSource(Value: TDataSource);
    procedure UpdateDataLinks(Control: TControl; Inserting: Boolean);
    procedure CMControlListChange(var Message: TCMControlListChange); message CM_CONTROLLISTCHANGE;
  protected
    { Protected declarations }
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property DataSource: TDataSource read GetDataSource write SetDataSource;
  end;

implementation

{ TDSPanel }

destructor TDSPanel.Destroy;
begin
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

procedure TDSPanel.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
  UpdateDataLinks(Self, True);
end;

procedure TDSPanel.UpdateDataLinks(Control: TControl; Inserting: Boolean);
var
  I: Integer;
  DataLink: TDataLink;
begin
  DataLink := TDataLink(Control.Perform(CM_GETDATALINK, 0, 0));
  if DataLink <> nil then
  begin
    DataLink.DataSourceFixed := False;
    if Inserting then
    begin
      DataLink.DataSource := DataSource;
      DataLink.DataSourceFixed := True;
    end;
  end;
  if Control is TWinControl then
    with TWinControl(Control) do
      for I := 0 to ControlCount - 1 do
        UpdateDataLinks(Controls[I], Inserting);
end;

procedure TDSPanel.CMControlListChange(var Message: TCMControlListChange);
begin
  UpdateDataLinks(Message.Control, Message.Inserting);
end;

constructor TDSPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FDataLink := TDBDSPanelLink.Create(Self);
  Width := 100;
  Height := 150;
end;

function TDSPanel.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TDSPanel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

{ TDBDSPanelLink }

constructor TDBDSPanelLink.Create(DSPanel: TDSPanel);
begin
  inherited Create;
  FDSPanel:=DSPanel;
end;

end.
