
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{       TDBSpinEdit                                     }
{                                                       }
{       Copyright (c) 1996,99 Iiraiida Koockliina       }
{                                                       }
{       Written by:                                     }
{         Iiraiida Koockliina                           }
{         KukVar LTD, Moscow, Russia                    }
{         e-mail: kukmeet@caravan.ru                    }
{         personal home page:                           }
{           http://www.caravan.ru/~kukmeet/index.html   }
{                                                       }
{*******************************************************}

unit DBSpinEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MSpinEdit, db, dbctrls;

type
  TDBSpinEdit = class(TCustomMSpinEdit)
  private
    { Private declarations }
    FFocused: Boolean;
    fDataLink: TFieldDataLink;
    fUpdatingData: Boolean;
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure SetReadOnly(ReadOnly: Boolean);
    procedure SetDataField(const Field: string);
    procedure SetDataSource(DataSource: TDataSource);
    procedure SetFocused(Value: Boolean);
    procedure DataChange(Sender: TObject);
    procedure UpdateData(Sender: TObject);
    procedure EditingChange(Sender: TObject);
  protected
    { Protected declarations }
    procedure Change; override;
    function EditCanModify: Boolean; override;
    procedure Loaded; override;
    procedure Notification(Component: TComponent; Operation: TOperation); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure UpClick (Sender: TObject); override;
    procedure DownClick (Sender: TObject); override;
//{$ifndef VER80}
    procedure CmGetDataLink(var Msg: TMessage); message Cm_GetDataLink;
//{$endif}
    procedure Reset; override;
    procedure WmPaste(var Msg: TMessage); message Wm_Paste;
    procedure WmCut(var Msg: TMessage); message Wm_Cut;
    procedure CMEnter(var Message: TCMEnter);  message Cm_Enter;
    procedure CmExit(var Msg: TCMExit); message Cm_Exit;
    property UpdatingData: Boolean read fUpdatingData;
  public
    { Public declarations }
    constructor Create(Owner: TComponent); override;
    destructor Destroy; override;
    function UseRightToLeftAlignment: Boolean; override;
    property Field: TField read GetField;
  published
    { Published declarations }
    property Anchors;
    property AutoSelect;
    property AutoSize;
    property BiDiMode;
    property CharCase;
    property Color;
    property Constraints;
    property Ctl3D;
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property Font;
    property ImeMode;
    property ImeName;
    property MaxLength;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PasswordChar;
    property PopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

//procedure Register;

implementation
  {
procedure Register;
begin
  RegisterComponents('KUKGroup', [TDBSpinEdit]);
end;
   }
{ TDBSpinEdit }

procedure TDBSpinEdit.Change;
begin
  if (fDataLink <> nil) 
  then try
       fDataLink.Modified;
       except
       end;
  inherited Change;
end;

function TDBSpinEdit.EditCanModify: Boolean;
begin
  Result := FDataLink.Edit;
end;

procedure TDBSpinEdit.CmExit(var Msg: TCMExit);
begin
  try
    fDataLink.UpdateRecord;
  except
    SelectAll;
    SetFocus;
    raise;
  end;
  inherited;
  SetFocused(False);
  CheckCursor;
  DoExit;
end;

//{$ifndef VER80}
procedure TDBSpinEdit.CmGetDataLink(var Msg: TMessage);
begin
  Msg.Result:= LongInt(fDataLink);
end;
//{$endif}

constructor TDBSpinEdit.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  inherited ReadOnly := True;
  EditorEnabled := false;
  fdataLink:= TFieldDataLink.Create;
  fDataLink.Control:= Self;
  fDataLink.OnDataChange:= DataChange;
  fDataLink.OnUpdateData:= UpdateData;
  fDataLink.OnEditingChange:= EditingChange;
end;

procedure TDBSpinEdit.Loaded;
begin
  inherited Loaded;
  if (csDesigning in ComponentState) then DataChange(Self);
end;

procedure TDBSpinEdit.CMEnter(var Message: TCMEnter);
begin
  SetFocused(True);
  inherited;
  if SysLocale.FarEast and FDataLink.CanModify then
    inherited ReadOnly := False;
end;

procedure TDBSpinEdit.DataChange(Sender: TObject);
begin
  if (FDataLink.Field <> nil) and (FDataLink.Field is TIntegerField) then
  begin
    EditMask := FDataLink.Field.EditMask;
    MinValue:=  (FDataLink.Field as TIntegerField).MinValue;
    MaxValue:=  (FDataLink.Field as TIntegerField).MaxValue;
    if FFocused and FDataLink.CanModify then
      Text := FDataLink.Field.Text
    else
    begin
      EditText := FDataLink.Field.DisplayText;
      if FDataLink.Editing and FDataLink.DataSet.Modified then
        Modified := True;
    end;     //
  end else
  begin
    EditMask := '';
    if csDesigning in ComponentState then
      EditText := Name else
      EditText := '';
  end;
end;

destructor TDBSpinEdit.Destroy;
begin
  fDataLink.Free;
  inherited Destroy;
end;

procedure TDBSpinEdit.DownClick(Sender: TObject);
begin
  if not ReadOnly then fDataLink.Edit;
  inherited DownClick(Sender);
end;

procedure TDBSpinEdit.EditingChange(Sender: TObject);
begin
  inherited ReadOnly:= not (fDataLink.Editing);
end;

function TDBSpinEdit.GetDataField: string;
begin
  Result:= fDataLink.FieldName;
end;

function TDBSpinEdit.GetDataSource: TDataSource;
begin
  Result:= fDataLink.DataSource;
end;

function TDBSpinEdit.GetReadOnly: Boolean;
begin
  Result:= fDataLink.ReadOnly;
end;

procedure TDBSpinEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key,Shift);
  if Key in [vk_Delete,vk_Back,vk_Clear] then fDataLink.Edit
  else Key:=0;
end;

procedure TDBSpinEdit.KeyPress(var Key: Char);
begin
  if (fDataLink.Field <> nil) then
    begin
      if Key = #27 then
        begin
          fDataLink.Reset;
          SelectAll;
          Key:= #0;
        end
      else if IsValidChar(Key) then fDataLink.Edit;
    end;
  inherited KeyPress(Key);
end;

procedure TDBSpinEdit.Notification(Component: TComponent;
  Operation: TOperation);
begin
  inherited Notification(Component,Operation);
  if (fDataLink <> nil) and
     (Component = DataSource) and
     (Operation = opRemove)
  then DataSource:= nil;
end;

procedure TDBSpinEdit.SetDataField(const Field: string);
begin
  fDataLink.FieldName:= Field
end;

procedure TDBSpinEdit.SetDataSource(DataSource: TDataSource);
begin
  if not (FDataLink.DataSourceFixed and (csLoading in ComponentState)) then
    FDataLink.DataSource := DataSource;
  if DataSource <> nil then DataSource.FreeNotification(Self);
end;

procedure TDBSpinEdit.SetFocused(Value: Boolean);
begin
  if FFocused <> Value then
  begin
    FFocused := Value;
    if not IsMasked then Invalidate;
    FDataLink.Reset;
  end;
end;

procedure TDBSpinEdit.SetReadOnly(ReadOnly: Boolean);
begin
  fDataLink.ReadOnly:= ReadOnly;
end;

procedure TDBSpinEdit.UpClick(Sender: TObject);
begin
  if not ReadOnly then fDataLink.Edit;
  inherited UpClick(Sender);
end;

procedure TDBSpinEdit.UpdateData(Sender: TObject);
begin
  ValidateEdit;
  FDataLink.Field.Text := Text;
end;

procedure TDBSpinEdit.WmCut(var Msg: TMessage);
begin
  fDataLink.Edit;
  inherited;
end;

procedure TDBSpinEdit.WmPaste(var Msg: TMessage);
begin
  fDataLink.Edit;
  inherited;
end;
                   
procedure TDBSpinEdit.Reset;
begin
  FDataLink.Reset;
  SelectAll;
end;

function TDBSpinEdit.UseRightToLeftAlignment: Boolean;
begin
  Result := DBUseRightToLeftAlignment(Self, Field);
end;

function TDBSpinEdit.GetField: TField;
begin
  Result := FDataLink.Field;
end;

end.
