
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{       TDBPicker                                     }
{                                                       }
{       Copyright (c) 1996,99 Iiraiida Koockliina       }
{                                                       }
{       Written by:                                     }
{         Iiraiida Koockliina                           }
{         KukVar LTD, Moscow, Russia                    }
{         e-mail: kukmeet@caravan.ru                    }
{         personal home page:                           }
{           http://www.caravan.ru/~kukmeet/index.html   }
{                                                       }
{*******************************************************}

unit DBPicker;

interface

uses
  Windows, Messages, SysUtils, CommCtrl, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, db, dbctrls;

type
  TDBPicker = class(TDateTimePicker)
  private
    { Private declarations }
    fDataLink: TFieldDataLink;
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure SetDataField(const Field: string);
    procedure SetDataSource(Value: TDataSource);
    procedure SetReadOnly(Value: Boolean);
    procedure UpdateData(Sender: TObject);
    procedure CmGetDataLink(var Msg: TMessage); message Cm_GetDataLink;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
  protected
    { Protected declarations }
    procedure Change; override;
    procedure Loaded; override;
    procedure Notification(Component: TComponent; Operation: TOperation); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
  public
    { Public declarations }
    constructor Create(Owner: TComponent); override;
    destructor Destroy; override;
    property Field: TField read GetField;
  published
    { Published declarations }
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;    
  end;

//procedure Register;

implementation
  {
procedure Register;
begin
  RegisterComponents('KUKGroup', [TDBPicker]);
end;
   }
{ TDBPicker }

procedure TDBPicker.Change;
begin
  fDataLink.Edit;
  inherited Change;
  if fDataLink.Editing then fDataLink.Modified;
end;

procedure TDBPicker.CMExit(var Message: TCMExit);
begin
  try
    FDataLink.UpdateRecord;
  except
    SetFocus;
    raise;
  end;
  inherited;
end;

procedure TDBPicker.CmGetDataLink(var Msg: TMessage);
begin
  Msg.Result := Integer(FDataLink);
end;

procedure TDBPicker.CNNotify(var Message: TWMNotify);
begin   
  with Message, NMHdr^ do
  begin
    Result := 0;
    case code of
      DTN_CLOSEUP:
        begin
          inherited;
          if not (fDataLink.Editing or FDataLink.DataSource.AutoEdit)
          then DataChange(Self);
        end
    else inherited
    end;
  end;
end;

constructor TDBPicker.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  fDataLink:= TFieldDataLink.Create;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
  fDataLink.Control:= Self;
end;

procedure TDBPicker.DataChange(Sender: TObject);
begin
  if (fDataLink.Field <> nil) then
  begin
    DateTime:= Field.AsDateTime;     
  end
  else if csDesigning in ComponentState then Date:= now;
end;

destructor TDBPicker.Destroy;
begin
  fDataLink.Free;
  fDataLink:= nil;
  inherited Destroy;
end;

function TDBPicker.GetDataField: string;
begin
  Result:= fDataLink.FieldName;
end;

function TDBPicker.GetDataSource: TDataSource;
begin
  Result:= fDataLink.DataSource;
end;

function TDBPicker.GetField: TField;
begin
  Result := fDataLink.Field;
end;

function TDBPicker.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;

procedure TDBPicker.KeyDown(var Key: Word; Shift: TShiftState);
begin
 inherited KeyDown(Key, Shift);
  if Key in [VK_BACK, VK_DELETE, VK_UP, VK_DOWN, 32..255] then
  begin
    if not FDataLink.Edit
       and ((Key in [VK_UP, VK_DOWN])
             or ((Key in [VK_LEFT,VK_RIGHT]) and DroppedDown)) then
      Key := 0;
  end;
end;

procedure TDBPicker.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  if (Key in [#32..#255]) and (FDataLink.Field <> nil) and
    not FDataLink.Field.IsValidChar(Key) then
  begin
    MessageBeep(0);
    Key := #0;
  end;
  case Key of
    ^H, ^V, ^X, #32..#255:
      FDataLink.Edit;
    #27:
      begin
        FDataLink.Reset;
        SetFocus;
      end;
  end;
end;

procedure TDBPicker.Loaded;
begin
   inherited Loaded;
   if (csDesigning in ComponentState) then DataChange(Self);
end;

procedure TDBPicker.Notification(Component: TComponent;
  Operation: TOperation);
begin
  inherited Notification(Component,Operation);
  if (fDataLink <> nil) and
     (Component = DataSource) and
     (Operation = opRemove)
  then
    DataSource:= nil;
end;

procedure TDBPicker.SetDataField(const Field: string);
begin
  fDataLink.FieldName:= Field;
end;

procedure TDBPicker.SetDataSource(Value: TDataSource);
begin
  if not (fDataLink.DataSourceFixed and (csLoading in ComponentState)) then
    fDataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

procedure TDBPicker.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;

procedure TDBPicker.UpdateData(Sender: TObject);
begin
  fDataLink.Field.AsDateTime:= DateTime;
end;

end.
