unit DBPickFldEd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBPicker, DsgnIntf, DB, dbctrls;

type
  TDBPickerDataFieldEditor = class(TStringProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc); override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(String), TDBPicker, 'DataField',
    TDBPickerDataFieldEditor);
end;

function TDBPickerDataFieldEditor.GetAttributes : TPropertyAttributes;
begin
  Result := [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TDBPickerDataFieldEditor.GetValues(Proc : TGetStrProc);
var
  s : TStringList;
  c : TDBPicker;
  i : Integer;
  f : TField;
begin
  s := TStringList.Create;
  try
    c := GetComponent(0) as TDBPicker;
    if Assigned(c.DataSource) and Assigned(c.DataSource.DataSet) then
    begin
      c.DataSource.DataSet.GetFieldNames(s);
      for i := 0 to s.Count - 1 do
      begin
        if c.DataSource.DataSet.Active then
          f := c.DataSource.DataSet.Fields[i]
        else
          f := c.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil, nil, '',
true);
        if ((f.DataType = ftDate) or (f.DataType = ftDateTime)) then
          Proc(s.Strings[i]);
        if not c.DataSource.DataSet.Active then
          f.Free;
      end;
    end;
  finally
    s.Free;
  end;
end;

end.
