
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{       TCustomLineContr                                      }
{                                                       }
{       Copyright (c) 1996,99 Iiraiida Koocklina        }
{                                                       }
{       Written by:                                     }
{         Iiraiida Koocklina                            }
{         KukVar LTD, Moscow, Russia                    }
{         e-mail: kukmeet@caravan.ru                    }
{         personal home page:                           }
{           http://www.caravan.ru/~kukmeet/index.html   }
{                                                       }
{*******************************************************}

unit CustomLineContr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type

  TCustomLineContr = class(TGraphicControl)
  private
    { Private declarations }
    FPen: TPen;
    FBrush: TBrush;
    Rgn  : HRgn;
    FRevert: Boolean;
    procedure SetBrush(Value: TBrush);
    procedure SetPen(Value: TPen);    
    procedure Paint; override;
    procedure CMHitTest(var Message: TCMHitTest); message CM_HitTest;
    function  ControlAtPos(const Pos: TPoint): TControl;
    procedure SetRevert(const Value: Boolean);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;    
  published
    { Published declarations }
    procedure StyleChanged(Sender: TObject);
    property Align;
    property Anchors;
    property Brush: TBrush read FBrush write SetBrush;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property Constraints;
    property Revert: Boolean read FRevert write SetRevert;
    property ParentShowHint;
    property Pen: TPen read FPen write SetPen;
    property ShowHint;
    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;    
  end;

//procedure Register;

implementation

const
  Hand = 15;
  Hand2 = 12;
  {
procedure Register;
begin
  RegisterComponents('KUKGroup', [TCustomLineContr]);
end;
   }
{ TCustomLineContr }

procedure TCustomLineContr.CMHitTest(var Message: TCMHitTest);
begin
  if PtInRegion(Rgn,Message.XPos,Message.YPos) then
    Message.Result:=1;
end;

function TCustomLineContr.ControlAtPos(const Pos: TPoint): TControl;
var
  I      : integer;
  scrnP,
  P      : TPoint;
begin
  scrnP:=ClientToScreen(Pos);
  for I:=Parent.ControlCount-1 downto 0 do
  begin
    Result:=Parent.Controls[I];
    if (Result is TCustomLineContr) and (Result<>Self) then
      with Result do
      begin
        P := Result.ScreenToClient(scrnP);
        if Perform(CM_HITTEST,0,integer(PointToSmallPoint(P)))<>0 then
          Exit;
      end;
    end;
  Result := nil;
end;

constructor TCustomLineContr.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle:=ControlStyle+[csReplicatable];
  Width:=105;
  Height:=105;
  FPen := TPen.Create;
  FPen.OnChange := StyleChanged;
  FBrush := TBrush.Create;
  FBrush.OnChange := StyleChanged;
  Rgn:=CreateRectRgn(0,0,Hand,Hand);
end;

destructor TCustomLineContr.Destroy;
begin
  DeleteObject(Rgn);
  FPen.Free;
  FBrush.Free;
  inherited Destroy;
end;

procedure TCustomLineContr.Paint;
var
  X1,X2,
  Y1,Y2    : integer;
  ArrRgn: array [1..4] of TPoint;
  pntArray : array [1..2] of TPoint;
  ArrCnt   : integer;
  r        : TRect;
begin
  with Canvas do
  begin
    Pen := FPen;
    Brush := FBrush;
    if (Width>Hand2) and (Height>Hand) then
      begin
        if not FRevert then
        begin
        pntArray[1].X:={Hand2;//}0;
        pntArray[1].Y:={Hand2 div 2;//}0;
        pntArray[2].X:={Width-Hand2;//}Width;
        pntArray[2].Y:={Height-Hand2 div 2;//}Height;
      {  pntArray[3].X:=Width-Hand;
        pntArray[3].Y:=Height-Hand div 2;
        pntArray[4].X:=Width;
        pntArray[4].Y:=Height-Hand div 2; }
        ArrRgn[1].X:=pntArray[1].X+5;
        ArrRgn[1].Y:=pntArray[1].Y-5;
        ArrRgn[2].X:=pntArray[1].X-5;
        ArrRgn[2].Y:=pntArray[1].Y+5;
        ArrRgn[3].X:=pntArray[2].X-5;
        ArrRgn[3].Y:=pntArray[2].Y+5;
        ArrRgn[4].X:=pntArray[2].X+5;
        ArrRgn[4].Y:=pntArray[2].Y-5;
        end
        else
        begin
        pntArray[1].X:=Width;
        pntArray[1].Y:=0;
        pntArray[2].X:=0;
        pntArray[2].Y:=Height;           
        ArrRgn[1].X:=pntArray[1].X-5;
        ArrRgn[1].Y:=pntArray[1].Y-5;
        ArrRgn[2].X:=pntArray[1].X+5;
        ArrRgn[2].Y:=pntArray[1].Y+5;
        ArrRgn[3].X:=pntArray[2].X+5;
        ArrRgn[3].Y:=pntArray[2].Y+5;
        ArrRgn[4].X:=pntArray[2].X-5;
        ArrRgn[4].Y:=pntArray[2].Y-5;
        end;
      end
    else
    begin
      if (Width <= Hand2) then
      begin
        pntArray[1].X:=Hand2 div 2;
        pntArray[1].Y:=0;
        pntArray[2].X:=Hand2 div 2;
        pntArray[2].Y:=Height;
          {pntArray[3].X:=Width-Hand2;
          pntArray[3].Y:=Height-Hand div 2;
          pntArray[4].X:=0;
          pntArray[4].Y:=Height-Hand div 2;}
        ArrRgn[1].X:=pntArray[1].X+5;
        ArrRgn[1].Y:=pntArray[1].Y-5;
        ArrRgn[2].X:=pntArray[1].X-5;
        ArrRgn[2].Y:=pntArray[1].Y+5;
        ArrRgn[3].X:=pntArray[2].X-5;
        ArrRgn[3].Y:=pntArray[2].Y+5;
        ArrRgn[4].X:=pntArray[2].X+5;
        ArrRgn[4].Y:=pntArray[2].Y-5;
      end;
      if (Height <= Hand) then
      begin
        pntArray[1].X:=0;
        pntArray[1].Y:=Hand div 2;
        pntArray[2].X:=Width;
        pntArray[2].Y:=Hand div 2;
          {pntArray[3].X:=Width-Hand2;
          pntArray[3].Y:=Height-Hand div 2;
          pntArray[4].X:=0;
          pntArray[4].Y:=Height-Hand div 2;}
        ArrRgn[1].X:=pntArray[1].X+5;
        ArrRgn[1].Y:=pntArray[1].Y-5;
        ArrRgn[2].X:=pntArray[1].X-5;
        ArrRgn[2].Y:=pntArray[1].Y+5;
        ArrRgn[3].X:=pntArray[2].X-5;
        ArrRgn[3].Y:=pntArray[2].Y+5;
        ArrRgn[4].X:=pntArray[2].X+5;
        ArrRgn[4].Y:=pntArray[2].Y-5;
      end;
    end;
  end;
  Canvas.PolyLine(pntArray);
  Canvas.Brush:=Parent.Brush;
  DeleteObject(Rgn);
  ArrCnt:=4;
  Rgn:=CreatePolygonRgn(ArrRgn,ArrCnt,ALTERNATE);
end;

procedure TCustomLineContr.SetBrush(Value: TBrush);
begin
  FBrush.Assign(Value);
end;

procedure TCustomLineContr.SetPen(Value: TPen);
begin
  FPen.Assign(Value);
end;

procedure TCustomLineContr.SetRevert(const Value: Boolean);
begin
  FRevert := Value;
  Invalidate;
end;

procedure TCustomLineContr.StyleChanged(Sender: TObject);
begin
  Invalidate;
end;

end.
