
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{       TCustomEllipsControl                                      }
{                                                       }
{       Copyright (c) 1996,99 Iiraiida Koocklina        }
{                                                       }
{       Written by:                                     }
{         Iiraiida Koocklina                            }
{         KukVar LTD, Moscow, Russia                    }
{         e-mail: kukmeet@caravan.ru                    }
{         personal home page:                           }
{           http://www.caravan.ru/~kukmeet/index.html   }
{                                                       }
{*******************************************************}

unit CustomEllipsControl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TCustomEllipsControl = class(TGraphicControl)
  private
    { Private declarations }
    FPen: TPen;
    FBrush: TBrush;
    Rgn  : HRgn;
    procedure SetBrush(Value: TBrush);
    procedure SetPen(Value: TPen);    
    procedure Paint; override;
    procedure CMHitTest(var Message: TCMHitTest); message CM_HitTest;
    function  ControlAtPos(const Pos: TPoint): TControl;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;      
  published
    { Published declarations }
    procedure StyleChanged(Sender: TObject);
    property Align;
    property Anchors;
    property Brush: TBrush read FBrush write SetBrush;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property Constraints;
    property ParentShowHint;
    property Pen: TPen read FPen write SetPen;
    property ShowHint;
    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;    
  end;

//procedure Register;

implementation

const
  Hand = 15;
  Hand2 = 12;
  {
procedure Register;
begin
  RegisterComponents('KUKGroup', [TCustomEllipsControl]);
end;
   }
{ TCustomLineContr }

procedure TCustomEllipsControl.CMHitTest(var Message: TCMHitTest);
begin
  if PtInRegion(Rgn,Message.XPos,Message.YPos) then
    Message.Result:=1;
end;

function TCustomEllipsControl.ControlAtPos(const Pos: TPoint): TControl;
var
  I      : integer;
  scrnP,
  P      : TPoint;
begin
  scrnP:=ClientToScreen(Pos);
  for I:=Parent.ControlCount-1 downto 0 do
  begin
    Result:=Parent.Controls[I];
    if (Result is TCustomEllipsControl) and (Result<>Self) then
      with Result do
      begin
        P := Result.ScreenToClient(scrnP);
        if Perform(CM_HITTEST,0,integer(PointToSmallPoint(P)))<>0 then
          Exit;
      end;
    end;
  Result := nil;
end;

constructor TCustomEllipsControl.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle:=ControlStyle+[csReplicatable];
  Width:=105;
  Height:=105;
  FPen := TPen.Create;
  FPen.OnChange := StyleChanged;
  FBrush := TBrush.Create;
  FBrush.OnChange := StyleChanged;
  Rgn:=CreateRectRgn(0,0,Hand,Hand);
end;

destructor TCustomEllipsControl.Destroy;
begin
  DeleteObject(Rgn);
  FPen.Free;
  FBrush.Free;
  inherited Destroy;
end;

procedure TCustomEllipsControl.Paint;
var
  X, Y, W, H, S: Integer;
begin
  with Canvas do
  begin
    Pen := FPen;
    Brush := FBrush;
    X := Pen.Width div 2;
    Y := X;
    W := Width - Pen.Width + 1;
    H := Height - Pen.Width + 1;
    if Pen.Width = 0 then
    begin
      Dec(W);
      Dec(H);
    end;
    if W < H then S := W else S := H;
        Ellipse(X, Y, X + W, Y + H);
  end;
  DeleteObject(Rgn);
  Rgn:=CreateEllipticRgn(X, Y, X + W, Y + H);
end;

procedure TCustomEllipsControl.SetBrush(Value: TBrush);
begin
  FBrush.Assign(Value);
end;

procedure TCustomEllipsControl.SetPen(Value: TPen);
begin
  FPen.Assign(Value);
end;

procedure TCustomEllipsControl.StyleChanged(Sender: TObject);
begin
  Invalidate;
end;

end.
