unit JPGComment;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  bytefile = file of byte;
  TJPGComment = class(TComponent)
  private
         fname : string;
         fcomment : string;
         infile, outfile : file of byte;
         procedure setfilename (name : string);
         procedure setcomment (name : string);
         function getbyte ( var f : bytefile) : byte;
  protected
  public
  published
  property FileName : string read fname write setfilename;
  property Comment : string read fcomment write setcomment;
  procedure ReadComment;
  procedure WriteCommentTo (nameoffile : string);
  procedure WriteComment;
  end;

procedure Register;

implementation

procedure tjpgcomment.setfilename( name : string);
begin
     fname:=name;
end;

procedure tjpgcomment.setcomment( name : string);
begin
     fcomment:=name;
end;

function tjpgcomment.getbyte( var f : bytefile) : byte;
var a : byte;
begin
     read(f,a);
     getbyte:=a;
end;

procedure tjpgcomment.readcomment;
var f : bytefile;
    a,s1,s2,l1,l2 : byte;
    i : longint;
    s,r : string;
begin
     r:=''; s:='';
     assignfile(f, fname);
     filemode:=0;
     reset(F);
     a:=getbyte(f); a:=getbyte(f);
     repeat
     repeat until getbyte(f)=$ff;
           s1:=$ff; s2:=getbyte(F);
           l1:=getbyte(F); l2:=getbyte(F);
           s:='';
           for i:=1 to (256*l1+l2)-2 do if not eof(f) then begin
                             s:=concat(s,chr(getbyte(F)));
                             end;
           if s2=$FE then r:=s;
     until eof(F) or (s2=$da);
     closefile(F);
     setcomment(r);
end;
procedure tjpgcomment.writecommentto ( nameoffile : string );
var f,ff : bytefile;
    p,pp : file;
    a,s1,s2,l1,l2 : byte;
    i,ii,ss : longint;
    s,r : string;
    notyet : boolean;
    buf : array[1..1000000] of byte;
begin
     r:=''; s:='';
     notyet:=true;
     assignfile(f, fname);
     assignfile(ff,nameoffile);
     reset(F); rewrite(FF);
     a:=getbyte(f); write(FF,a);
     a:=getbyte(f); write(FF,a);
     repeat
     repeat until getbyte(f)=$ff;
           s1:=$ff; s2:=getbyte(F);
           l1:=getbyte(F); l2:=getbyte(F);
           s:='';
           for i:=1 to (256*l1+l2)-2 do if not eof(f) then begin
                             s:=concat(s,chr(getbyte(F)));
                             end;
           if ((s2 and $F0)=$C0) and notyet and (fcomment<>'') then begin
                                      a:=$FF; write(ff,a);
                                      a:=$FE; write(ff,a);
                                      a:=(length(comment)+2) div 256;
                                      write(ff,a);
                                      a:=(length(comment)+2) mod 256;
                                      write(ff,a);
                                      for i:=1 to length(comment) do begin
                                                                     a:=ord(comment[i]);
                                                                     write(FF,a);
                                                                     end;
                                      notyet:=false;
                                      end;
           if s2<>$FE then begin
                                  write(ff,s1,s2,l1,l2);
                          for i:=1 to length(s) do begin
                                                        a:=ord(s[i]);
                                                        write(FF,a);
                                                        end;
                          end;
     until eof(F) or (s2=$da);
     i:=filepos(f);
     ii:=filepos(ff);
     ss:=filesize(F);
     closefile(F);
     closefile(FF);
     assignfile(p, fname);
     assignfile(pp,nameoffile);
     reset(p,1);
     filemode:=2;
     reset(pp,1);
     seek(p,i); seek(pp,ii);
     blockread(p,buf,ss-i);
     blockwrite(pp,buf,ss-i);
     closefile(p); closefile(pp);
end;

procedure tjpgcomment.writecomment;
begin
     writecommentto('~tmppig.jpg');
     deletefile(fname);
     renamefile('~tmppig.jpg',fname);
end;

procedure Register;
begin
  RegisterComponents('Samples', [TJPGComment]);
end;

end.
