unit JpegActn;
{$I jconfig.inc}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Transupp, extctrls, JPeg, DsgnIntf;

type
  TJpegAction = class(TComponent)
  private
    { Private-Deklarationen }
    FImage : TImage;
    FAction : JXForm_Code;
    FFilename : TFileName;
    FProgressive : Boolean;
    FGray : Boolean;
    FTrim : Boolean;
    FOptimizeCoding : Boolean;
    Procedure SetImage(Value : TImage);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    Function Execute : Integer;
  published
    { Published-Deklarationen }
    property Image : TImage read FImage write SetImage;
    property Action : JXForm_Code read FAction write FAction;
    Property SaveToFilename : TFileName read FFilename Write FFilename;
    property progressive : Boolean read FProgressive write FProgressive default False;
    property ForceGrayScale : Boolean read FGray write FGray default false;
    property OptimizeCoding : Boolean read FOptimizeCoding write FOptimizeCoding default false;
    property Trim_off_partial_edge_MCUs : Boolean read FTrim write FTrim default false;
  end;

  TSaveFileProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation
uses jdeferr, jdtrans, jctrans, jerror, jmorecfg, jpeglib, cdjpeg, jdatasrc,
     JDatadst, JdAPImin, JcAPImin,JcParam;

procedure Register;
begin
  RegisterComponents('Samples', [TJpegAction]);
  RegisterPropertyEditor(TypeInfo(TFileName), TJPEGAction, 'SaveToFileName', TSaveFileProperty);
end;

function TSaveFileProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect, paAutoUpdate];
end;

procedure TSaveFileProperty.Edit;
begin
  with TSaveDialog.Create(nil) do
  begin
    DefaultExt := 'jpg';
    Filter     := 'JPeg Files (*.jpg)|*.jpg|All Files (*.*)|*.*';
    Options    := [ofHideReadOnly,ofPathMustExist,ofFileMustExist];
    FileName   := GetStrValue;
    Title      := 'Save JPeg-Image as';
    if Execute
    then SetStrValue(FileName);
    Free;
  end;
end;

Procedure TJpegAction.SetImage(Value : TImage);
Begin
  If Assigned(Value) and
     ((Value.Picture.Graphic) is TJPegImage)
  Then FImage := Value
  Else Begin
    FImage := Nil;
    ShowMessage(Value.Name+' is not a JPeg-Image');
  End;
End;

Function TJpegAction.Execute : Integer;
Var
  InputStream     : TMemoryStream;
  OutputStream    : TStream;
  FileStream      : TFileStream;
  srcinfo         : jpeg_decompress_struct;
  dstinfo         : jpeg_compress_struct;
  jsrcerr         : jpeg_error_mgr;
  jdsterr         : jpeg_error_mgr;
  src_coef_arrays : jvirt_barray_tbl_ptr;
  dst_coef_arrays : jvirt_barray_tbl_ptr;
  copyoption      : JCOPY_OPTION;        { -copy switch }
  transformoption : jpeg_transform_info; { image transformation options }
Begin
  Screen.Cursor := crHourglass;
  If Assigned(Image)
  Then try
    InputStream   := TMemoryStream.Create;
    OutputStream  := TMemoryStream.Create;
    // Save Image to InputStream
    Image.Picture.Graphic.SaveToStream(InputStream);
    InputStream.seek(0,0);

    // Initialize the JPEG decompression object with default error handling.
    srcinfo.err := jpeg_std_error(jsrcerr);

    jpeg_create_decompress(@srcinfo);
    // Initialize the JPEG compression object with default error handling.
    dstinfo.err := jpeg_std_error(jdsterr);
    jpeg_create_compress(@dstinfo);

  { Now safe to enable signal catcher.
    Note: we assume only the decompression object will have virtual arrays. }

  {$ifdef NEED_SIGNAL_CATCHER}
    enable_signal_catcher(j_common_ptr(@srcinfo));
  {$endif}

    DstInfo.optimize_coding   := OptimizeCoding;
    TransFormOption.Trim      := Trim_off_partial_edge_MCUs;
    TransFormOption.Transform := FAction;
    TransFormOption.force_grayscale := ForceGrayScale;

    jsrcerr.trace_level := jdsterr.trace_level;
    srcinfo.mem^.max_memory_to_use := dstinfo.mem^.max_memory_to_use;

    // Specify data source for decompression
    jpeg_stdio_src(@srcinfo, InputStream);

    // Enable saving of extra markers that we want to copy
    jcopy_markers_setup(@srcinfo, copyoption);

    // Read file header
    jpeg_read_header(@srcinfo, TRUE);

    { Any space needed by a transform option must be requested before
      jpeg_read_coefficients so that memory allocation will be done right. }

    {$ifdef TRANSFORMS_SUPPORTED}
    jtransform_request_workspace(@srcinfo, transformoption);
    {$endif}

    // Read source file as DCT coefficients
    src_coef_arrays := jpeg_read_coefficients(@srcinfo);

    // Initialize destination compression parameters from source values
    jpeg_copy_critical_parameters(@srcinfo, @dstinfo);

    // Adjust destination parameters if required by transform options;
    // also find out which set of coefficient arrays will hold the output.

    {$ifdef TRANSFORMS_SUPPORTED}
    dst_coef_arrays := jtransform_adjust_parameters(@srcinfo, @dstinfo,
                                                     src_coef_arrays,
                                                     transformoption);
    {$else}
    dst_coef_arrays := src_coef_arrays;
    {$endif}
    dstinfo.jpeg_Color_space := SrcInfo.jpeg_color_space;

    If Progressive
    Then jpeg_simple_progression(@dstInfo);

    // Specify data destination for compression
    jpeg_stdio_dest(@dstinfo, OutputStream);

    // Start compressor (note no image data is actually written here)
    jpeg_write_coefficients(@dstinfo, dst_coef_arrays);

    // Copy to the output file any extra markers that we want to preserve
    jcopy_markers_execute(@srcinfo, @dstinfo, copyoption);

    // Execute image transformation, if any
    {$ifdef TRANSFORMS_SUPPORTED}
    jtransform_execute_transformation(@srcinfo, @dstinfo,
                                      src_coef_arrays,
                                      transformoption);
    {$endif}

    // Finish compression and release memory }
    jpeg_finish_compress(@dstinfo);
    jpeg_destroy_compress(@dstinfo);
    jpeg_finish_decompress(@srcinfo);
    jpeg_destroy_decompress(@srcinfo);

    // save to file if autosave is true
    If SaveToFilename <> ''
    Then Try
      FileStream := TFileStream.Create(FFileName,fmCreate);
      OutputStream.Seek(0,0);
      FileStream.CopyFrom(OutputStream, OutputStream.Size);
      FileStream.Seek(0,0);
      FileStream.Free;
    Except
      ShowMessage('Can not save JPegImage to '+FFilename);
    End;
    OutputStream.Seek(0,0);
    // write back transformed JPG-File to Image Component
    Image.Picture.Graphic.LoadFromStream(OutputStream);
  Finally
    OutputStream.Free;
    InputStream.Free;
    Screen.Cursor := crDefault;
  End;
  Result := jsrcerr.num_warnings;
End;

end.
