unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IconCtls;

type
  TIconDlg = class(TForm)
    IconListBox: TIconListBox;
    IconFileName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    OKbtn: TButton;
    CancelBtn: TButton;
    BrowseBtn: TButton;
    OpenDialog1: TOpenDialog;
    procedure BrowseBtnClick(Sender: TObject);
    procedure IconFileNameChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure IconListBoxDblClick(Sender: TObject);
    procedure IconListBoxFileChange(Sender: TObject);
    procedure IconFileNameKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
	IconDlg: TIconDlg;

implementation

{$R *.DFM}

procedure TIconDlg.BrowseBtnClick(Sender: TObject);
begin
//openDialog1.FileName := '*.*';
if IconFileName.text <> '' then
   openDialog1.InitialDir := extractFilePath(IconFileName.text)
else
   openDialog1.InitialDir := 'c:\';

if openDialog1.execute then
 begin
  IconFileName.text := openDialog1.FileName;
  IconListBox.itemIndex := 0;
 end;

end;

procedure TIconDlg.IconFileNameChange(Sender: TObject);
begin
     IconListBox.FileName := IconFileName.text;
end;

procedure TIconDlg.FormShow(Sender: TObject);
begin
     IconFileName.text := IconListBox.FileName;
end;

procedure TIconDlg.IconListBoxDblClick(Sender: TObject);
begin
     OKbtn.click;
end;

procedure TIconDlg.IconListBoxFileChange(Sender: TObject);
begin
 {if not fileExists(IconListBox.FileName) then
  begin
    MessageDlg('Impossible de trouver le fichier ' + IconFileName.text + '.', mtWarning,[mbOk], 0);
    //IconFileName.text := IconListBox.FileName;
   end;}
end;

procedure TIconDlg.IconFileNameKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
{if key = VK_RETURN then
   IconListBox.FileName := IconFileName.text;}
end;

end.
