unit iplUnit;
{
 *  INTEL Image Processing Library sample app
 *  main module
 *  Peter G.Darakhvelidze
 *  E-mail:     petr@p-media.spb.ru
 *
 *  Source: ipl.h,iplmisc.h,iplerror.h Revision: 31 $
 *  Date: 8.02.98 15:49 $
 *  Original comments included
 }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtDlgs, ExtCtrls, StdCtrls, Buttons, Menus, Ipl2, iplfunc2;

type
  TMainForm = class(TForm)
    ScrollBox1: TScrollBox;
    Image1: TImage;
    OpenPictureDialog1: TOpenPictureDialog;
    ScrollBox2: TScrollBox;
    Image2: TImage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N2: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    Processing1Item: TMenuItem;
    Filtering1: TMenuItem;
    BlurItem: TMenuItem;
    MinFilterItem: TMenuItem;
    MaxFilterItem: TMenuItem;
    MedianFilterItem: TMenuItem;
    PointOperationsItem: TMenuItem;
    EqualizeItem: TMenuItem;
    ThresholdItem: TMenuItem;
    ArithmeticItem: TMenuItem;
    AddItem: TMenuItem;
    Splitter1: TSplitter;
    N3: TMenuItem;
    LaplasItem: TMenuItem;
    NegativeItem: TMenuItem;
    LogItem: TMenuItem;
    ExpItem: TMenuItem;
    SobelItem: TMenuItem;
    N4: TMenuItem;
    HyperbItem: TMenuItem;
    IntensItem: TMenuItem;
    SharpItem: TMenuItem;
    SavePictureDialog1: TSavePictureDialog;
    LinearMenu: TMenuItem;
    Gauss5Item: TMenuItem;
    Gauss3Item: TMenuItem;
    Hi3Item: TMenuItem;
    Hi5Item: TMenuItem;
    MorphMenu: TMenuItem;
    ErodeItem: TMenuItem;
    DilatItem: TMenuItem;
    OpeningItem: TMenuItem;
    ClosingItem: TMenuItem;
    GeomMenu: TMenuItem;
    AffineItem: TMenuItem;
    ShearItem: TMenuItem;
    HelpMenu: TMenuItem;
    AboutItem: TMenuItem;
    ZoomItem: TMenuItem;
    DecimateItem: TMenuItem;
    SubItem: TMenuItem;
    OrItem: TMenuItem;
    XorItem: TMenuItem;
    BilinearItem: TMenuItem;
    PerspectiveItem: TMenuItem;
    AssignItem: TMenuItem;
    procedure BlurItemClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure AddItemClick(Sender: TObject);
    procedure LaplasItemClick(Sender: TObject);
    procedure EqualizeItemClick(Sender: TObject);
    procedure ThresholdItemClick(Sender: TObject);
    procedure NegativeItemClick(Sender: TObject);
    procedure LogItemClick(Sender: TObject);
    procedure ExpItemClick(Sender: TObject);
    procedure MedianFilterItemClick(Sender: TObject);
    procedure MinFilterItemClick(Sender: TObject);
    procedure MaxFilterItemClick(Sender: TObject);
    procedure SobelItemClick(Sender: TObject);
    procedure HyperbItemClick(Sender: TObject);
    procedure SharpItemClick(Sender: TObject);
    procedure IntensItemClick(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Gauss3ItemClick(Sender: TObject);
    procedure Gauss5ItemClick(Sender: TObject);
    procedure Hi3ItemClick(Sender: TObject);
    procedure Hi5ItemClick(Sender: TObject);
    procedure ErodeItemClick(Sender: TObject);
    procedure DilatItemClick(Sender: TObject);
    procedure OpeningItemClick(Sender: TObject);
    procedure ClosingItemClick(Sender: TObject);
    procedure AffineItemClick(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure ShearItemClick(Sender: TObject);
    procedure AboutItemClick(Sender: TObject);
    procedure ZoomItemClick(Sender: TObject);
    procedure DecimateItemClick(Sender: TObject);
    procedure SubItemClick(Sender: TObject);
    procedure OrItemClick(Sender: TObject);
    procedure XorItemClick(Sender: TObject);
    procedure BilinearItemClick(Sender: TObject);
    procedure PerspectiveItemClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure AssignItemClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Process(fun : TProcessingFunction2);
    procedure ProcessWithResizing(ProcFun : TProcessingFunction2;SizeFunc:TSizingFunction);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
uses InputPrm, About, ipldib, jpeg;

var CurrentFileName : string;

{typical processing procedure; size of in & out images are equal}
procedure TMainForm.Process(fun : TProcessingFunction2);
var SrcImage,DstImage : pIplImage;i: Integer;b : boolean;
ms : TMemoryStream;
bmih : pBitmapInfoHeader;
ABitmap : TBitmap;
p : pointer;
TmpCursor : TCursor;
begin
 if not Assigned(Image1.Picture.Graphic) then Exit;
 TmpCursor := Screen.Cursor;
 Screen.Cursor := crHourGlass;
 ms := TMemoryStream.Create;
 if (Image1.Picture.Graphic is TJPEGImage) then
  begin
  ABitmap := TBitmap.Create;
  ABitmap.Assign(Image1.Picture.Graphic);
  end
 else
  begin
  Image1.Picture.Bitmap.HandleType := bmDIB;
  ABitmap := Image1.Picture.Bitmap;
  end;

 ABitmap.SaveToStream(ms);
 if (Image1.Picture.Graphic is TJPEGImage) then ABitmap.Free;

 bmih := @(pbyteArray(ms.Memory)^[SizeOf(TBitmapFileHeader)]);
 b:=True;
 srcImage := IplTranslateDIB(bmih, b);
 dstImage := IplCloneImage(srcImage);
 IplSet(dstImage, 0);
 p := pointer(Cardinal(ms.Memory) + pBitmapFileHeader(ms.Memory)^.bfOffBits);

 if (Assigned(srcImage)) and (Assigned(dstImage))
   then  fun(srcImage, dstImage);

 Move(dstImage^.ImageData^, p^, BMIH^.biSizeImage);

 if not Assigned(Image2.Picture.Bitmap) then Image2.Picture.Bitmap := TBitmap.Create;

 IplDeallocateImage(srcImage);
 IplDeallocateImage(dstImage);
 ms.Position := 0;
 Image2.Picture.Bitmap.LoadFromStream(ms);
 ms.Free;
 Screen.Cursor := TmpCursor;
 Image2.Refresh;
end;

{processing procedure; size of in & out images are not equal, or this images
must not share memory}
procedure TMainForm.ProcessWithResizing(ProcFun : TProcessingFunction2;SizeFunc:TSizingFunction);
var SrcImage,DstImage : pIplImage;
 i,NewX,NewY: Integer;b : boolean;
 ms : TMemoryStream;
 bmih : pBitmapInfoHeader;
 ABitmap : TBitmap;
 TmpCursor : TCursor;
begin
 if not Assigned(Image1.Picture.Graphic) then Exit;
 if (Image1.Picture.Graphic is TJPEGImage) then
  begin
  ABitmap := TBitmap.Create;
  ABitmap.Assign(Image1.Picture.Graphic);
  end
 else
  begin
  Image1.Picture.Bitmap.HandleType := bmDIB;
  ABitmap := Image1.Picture.Bitmap;
  end;

 try
  TmpCursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  ms := TMemoryStream.Create;
  ABitmap.SaveToStream(ms);
  if (Image1.Picture.Graphic is TJPEGImage) then ABitmap.Free;

  bmih := @(pbyteArray(ms.Memory)^[SizeOf(TBitmapFileHeader)]);
  b:=True;
  srcImage := IplTranslateDIB(bmih, b);
  SizeFunc(srcImage, NewX, NewY);
  dstImage := iplCreateImageHeader(srcImage.nChannels,srcImage.alphaChannel,
   srcImage.Depth,srcImage.colorModel,srcImage.channelSeq,srcImage.dataOrder,srcImage.origin,
   srcImage.align,NewX,NewY,
   NIL,NIL,NIL,NIL);

  iplAllocateImage(dstImage,1,255);
  if dstImage.imageData = nil then
   begin
    ShowMessage('Cannot allocate enough memory');
    raise EAbort.Create('');
   end;

  if (Assigned(srcImage)) and (Assigned(dstImage))
   then  ProcFun(srcImage, dstImage);

  IplDeallocateImage(srcImage);
  i := bmih^.biClrUsed;
  if i=0 then i:=1 shl bmih^.biBitCount;
  NewX := ((dstImage^.width * bmih^.biBitCount + 31) and (not 31)) div 8;//aligned width
  NewY := dstImage^.height;

  ms.SetSize(SizeOf(TBitmapFileHeader)+SizeOf(TBitmapInfoHeader)+i+NewX*NewY);
  bmih := @(pbyteArray(ms.Memory)^[SizeOf(TBitmapFileHeader)]);
  bmih^.biWidth := dstImage^.width;
  bmih^.biHeight := dstImage^.height;
  bmih^.biSizeImage := NewX*NewY;
  //IplConvertToDIB(dstImage, bmih, IPL_DITHER_NONE, IPL_PALCONV_NONE); is too slow
  Move(dstImage^.ImageData^,
  pbyteArray(ms.Memory)^[pBitmapFileHeader(ms.Memory)^.bfOffBits], BMIH^.biSizeImage);

  if not Assigned(Image2.Picture.Bitmap) then Image2.Picture.Bitmap := TBitmap.Create;

  ms.Position := 0;
  Image2.Picture.Bitmap.LoadFromStream(ms);
 finally
  IplDeallocateImage(dstImage);
  ms.Free;
  Screen.Cursor := TmpCursor;
  Image2.Refresh;
 end; 
end;

procedure TMainForm.AssignItemClick(Sender: TObject);
begin
 if Assigned(Image1.Picture.Bitmap) then
  begin
  Image1.Picture.Assign(Image2.Picture.Bitmap);
//  Image1.Refresh;
  end;
end;

procedure TMainForm.New1Click(Sender: TObject);
var Image : pIplImage;
dib : pBitmapFileHeader;
ms : TMemoryStream;
begin
 Image := IplCreateImageJaehne(8,256,256);
 dib := IplImageToDIB(Image);
 IplDeallocateImage(Image);
 ms := TMemoryStream.Create;
 ms.Size:=dib^.bfSize;
 Move(dib^,ms.Memory^,ms.Size);
 Image1.Picture.Bitmap := TBitmap.Create;
 Image1.Picture.Bitmap.LoadFromStream(ms);
 ms.Free;
 FreeMem(dib,dib^.bfSize);
 Image1.Refresh;
end;

procedure TMainForm.Open1Click(Sender: TObject);
begin
 if OpenPictureDialog1.Execute then
  begin
  CurrentFileName := OpenPictureDialog1.FileName;
  Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
  end;
end;

procedure TMainForm.Save1Click(Sender: TObject);
begin
 if Assigned(Image2.Picture) and (CurrentFileName<>'') then
  Image2.Picture.SaveToFile(CurrentFileName);
end;

procedure TMainForm.SaveAs1Click(Sender: TObject);
begin
 if SavePictureDialog1.Execute then
  begin
  CurrentFileName := SavePictureDialog1.FileName;
  Save1Click(Sender);
  end;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.AboutItemClick(Sender: TObject);
begin
 With TAboutBox.Create(Self) do
  begin
  ShowModal;
  Free;
  end;
end;

procedure TMainForm.BlurItemClick(Sender: TObject);
begin
 Process(Blur);
end;
procedure TMainForm.NegativeItemClick(Sender: TObject);
begin
 Process(Negative);
end;
procedure TMainForm.LogItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Log. power:',pInteger(Coeff)^)
 then Process(Log);
end;
procedure TMainForm.ExpItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Power of exponent:',pInteger(Coeff)^)
 then Process(Exponent);
end;
procedure TMainForm.AddItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Constant:',pInteger(Coeff)^)
 then Process(AddS);
end;
procedure TMainForm.SubItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Constant:',pInteger(Coeff)^)
 then Process(SubS);
end;
procedure TMainForm.OrItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Constant:',pInteger(Coeff)^)
 then Process(OrS);
end;
procedure TMainForm.XorItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Constant:',pInteger(Coeff)^)
 then Process(XorS);
end;
procedure TMainForm.LaplasItemClick(Sender: TObject);
begin
 Process(Laplas);
end;
procedure TMainForm.EqualizeItemClick(Sender: TObject);
begin
 Process(Equalize);
end;
procedure TMainForm.IntensItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Power of intensification (0-99):',pInteger(Coeff)^)
 then Process(Intens);
end;
procedure TMainForm.ThresholdItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Threshold value:',pInteger(Coeff)^)
 then Process(Threshold);
end;
procedure TMainForm.MedianFilterItemClick(Sender: TObject);
begin
 Process(Median);
end;
procedure TMainForm.MinFilterItemClick(Sender: TObject);
begin
 Process(MinFilter);
end;
procedure TMainForm.MaxFilterItemClick(Sender: TObject);
begin
 Process(MaxFilter);
end;
procedure TMainForm.SobelItemClick(Sender: TObject);
begin
 Process(Sobel);
end;
procedure TMainForm.HyperbItemClick(Sender: TObject);
begin
 Process(Hyperb);
end;
procedure TMainForm.SharpItemClick(Sender: TObject);
begin
 Process(Hilight);
end;

procedure TMainForm.Gauss3ItemClick(Sender: TObject);
begin
 Process(Gaussian3x3);
end;

procedure TMainForm.Gauss5ItemClick(Sender: TObject);
begin
 Process(Gaussian5x5);
end;

procedure TMainForm.Hi3ItemClick(Sender: TObject);
begin
 Process(HiPass3x3);
end;

procedure TMainForm.Hi5ItemClick(Sender: TObject);
begin
 Process(HiPass5x5);
end;

procedure TMainForm.ErodeItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Number of iterations:',pInteger(Coeff)^)
 then Process(Erode);
end;

procedure TMainForm.DilatItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Number of iterations:',pInteger(Coeff)^)
 then Process(Dilate);
end;

procedure TMainForm.OpeningItemClick(Sender: TObject);
begin
 if InputInteger('Input parameter','Number of iterations:',pInteger(Coeff)^)
 then Process(Opening);
end;

procedure TMainForm.ClosingItemClick(Sender: TObject);
begin
  if InputInteger('Input parameter','Number of iterations:',pInteger(Coeff)^)
  then Process(Closing);
end;
//~~~~~~~~~~~~~~~~calculate the size of new image~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function DummySizing(srcImage: pIplImage;var NewX, NewY: Integer):boolean;
begin
 NewX := pIntegerArray(Coeff)^[0];
 NewY := pIntegerArray(Coeff)^[1];
end;

function ZoomSizing(srcImage: pIplImage;var NewX, NewY: Integer):boolean;
begin
 NewX := Round(srcImage^.width * (pIntegerArray(Coeff)^[2]/pIntegerArray(Coeff)^[0]));
 NewY := Round(srcImage^.height * (pIntegerArray(Coeff)^[3]/pIntegerArray(Coeff)^[1]));
end;
function ShearSizing(srcImage: pIplImage;var NewX, NewY: Integer):boolean;
 var ac : TAffineCoeffs;
     ar : TAffineRect;
 begin
  ac[0,0] := 1;
  ac[0,1] := pSingleArray(Coeff)^[0];
  ac[0,2] := 0;
  ac[1,0] := pSingleArray(Coeff)^[1];
  ac[1,1] := 1;
  ac[1,2] := 0;
  iplGetAffineBound(srcImage, ac, ar);

  NewX := Round(ar[1,0]-ar[0,0]);
  NewY := Round(ar[1,1]-ar[0,1]);
end;

function AffineSizing(srcImage: pIplImage;var NewX, NewY: Integer):boolean;
 var ac : TAffineCoeffs;
     ar : TAffineRect;
 begin
  ac[0,0] := pSingleArray(Coeff)^[0];
  ac[0,1] := pSingleArray(Coeff)^[1];
  ac[0,2] := 0;
  ac[1,0] := pSingleArray(Coeff)^[2];
  ac[1,1] := pSingleArray(Coeff)^[3];
  ac[1,2] := 0;
  iplGetAffineBound(srcImage, ac, ar);

  NewX := Round(ar[1,0]-ar[0,0]);
  NewY := Round(ar[1,1]-ar[0,1]);
end;

function BilinearSizing(srcImage: pIplImage;var NewX, NewY: Integer):boolean;
 var bc : TBilinearCoeffs;
     ar : TAffineRect;
 begin
  bc[0,0] := pSingleArray(Coeff)^[0];
  bc[0,1] := pSingleArray(Coeff)^[1];
  bc[0,2] := pSingleArray(Coeff)^[2];
  bc[0,3] := 0;
  bc[1,0] := pSingleArray(Coeff)^[3];
  bc[1,1] := pSingleArray(Coeff)^[4];
  bc[1,2] := pSingleArray(Coeff)^[5];
  bc[1,3] := 0;
  iplGetBilinearBound(srcImage, bc, ar);
  NewX := Round(ar[1,0]-ar[0,0]);
  NewY := Round(ar[1,1]-ar[0,1]);
end;
function PerspectiveSizing(srcImage: pIplImage;var NewX, NewY: Integer):boolean;
 var pc : TPerspectiveCoeffs;
     ar : TAffineRect;
 begin
  pc[0,0] := pSingleArray(Coeff)^[0];
  pc[0,1] := pSingleArray(Coeff)^[1];
  pc[0,2] := pSingleArray(Coeff)^[2];
  pc[1,0] := pSingleArray(Coeff)^[3];
  pc[1,1] := pSingleArray(Coeff)^[4];
  pc[1,2] := pSingleArray(Coeff)^[5];
  pc[2,0] := pSingleArray(Coeff)^[6];
  pc[2,1] := pSingleArray(Coeff)^[7];
  pc[2,2] := pSingleArray(Coeff)^[8];
  iplGetPerspectiveBound(srcImage, pc, ar);
  NewX := Round(ar[1,0]-ar[0,0]);
  NewY := Round(ar[1,1]-ar[0,1]);
end;


//[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]-[]
procedure TMainForm.ShearItemClick(Sender: TObject);
begin
 pSingleArray(Coeff)^[0]:=2;
 pSingleArray(Coeff)^[1]:=2;
 pSingleArray(Coeff)^[2]:=10;
 pSingleArray(Coeff)^[3]:=10;
 if InputShearParams(pSingleArray(Coeff)^[0],pSingleArray(Coeff)^[1],
 pSingleArray(Coeff)^[2],pSingleArray(Coeff)^[3],Interpolation)
 then ProcessWithResizing(Shear,ShearSizing);
end;


procedure TMainForm.ZoomItemClick(Sender: TObject);
begin
 pIntegerArray(Coeff)^[0]:=1;
 pIntegerArray(Coeff)^[1]:=1;
 pIntegerArray(Coeff)^[2]:=2;
 pIntegerArray(Coeff)^[3]:=2;
 if InputZoomParams(pIntegerArray(Coeff)^[0],pIntegerArray(Coeff)^[1],
    pIntegerArray(Coeff)^[2],pIntegerArray(Coeff)^[3],Interpolation)
 and (pIntegerArray(Coeff)^[2]>pIntegerArray(Coeff)^[0]) //new x > old x
 and (pIntegerArray(Coeff)^[3]>pIntegerArray(Coeff)^[1]) //new y > old y
 then ProcessWithResizing(Zoom,ZoomSizing);
end;

procedure TMainForm.DecimateItemClick(Sender: TObject);
begin
 pIntegerArray(Coeff)^[0]:=2;
 pIntegerArray(Coeff)^[1]:=2;
 pIntegerArray(Coeff)^[2]:=1;
 pIntegerArray(Coeff)^[3]:=1;
 if InputZoomParams(pIntegerArray(Coeff)^[0],pIntegerArray(Coeff)^[1],
    pIntegerArray(Coeff)^[2],pIntegerArray(Coeff)^[3],Interpolation)
 and (pIntegerArray(Coeff)^[2]<pIntegerArray(Coeff)^[0]) //new x < old x
 and (pIntegerArray(Coeff)^[3]<pIntegerArray(Coeff)^[1]) //new y < old y
 then ProcessWithResizing(Decimate,ZoomSizing);
end;

procedure TMainForm.AffineItemClick(Sender: TObject);
begin
 pSingleArray(Coeff)^[0]:=0.7;
 pSingleArray(Coeff)^[1]:=0.7;
 pSingleArray(Coeff)^[2]:=-0.7;
 pSingleArray(Coeff)^[3]:=0.7;
 if InputAffineParams(pSingleArray(Coeff)^[0],pSingleArray(Coeff)^[1],
 pSingleArray(Coeff)^[2],pSingleArray(Coeff)^[3],Interpolation)
 then
   ProcessWithResizing(WarpAffine,AffineSizing);
end;

procedure TMainForm.BilinearItemClick(Sender: TObject);
begin
 pSingleArray(Coeff)^[0]:=0.001;
 pSingleArray(Coeff)^[1]:=0.7;
 pSingleArray(Coeff)^[2]:=0.7;
 pSingleArray(Coeff)^[3]:=0.001;
 pSingleArray(Coeff)^[4]:=-0.7;
 pSingleArray(Coeff)^[5]:=0.7;
 if InputBilinearParams(pSingleArray(Coeff)^[0],pSingleArray(Coeff)^[1],
 pSingleArray(Coeff)^[2],pSingleArray(Coeff)^[3],
 pSingleArray(Coeff)^[4],pSingleArray(Coeff)^[5],Interpolation)
 then
   ProcessWithResizing(WarpBilinear,BilinearSizing);
end;


procedure TMainForm.PerspectiveItemClick(Sender: TObject);
begin
 pSingleArray(Coeff)^[0]:=0.7;
 pSingleArray(Coeff)^[1]:=0.7;
 pSingleArray(Coeff)^[2]:=0;
 pSingleArray(Coeff)^[3]:=-0.7;
 pSingleArray(Coeff)^[4]:=0.7;
 pSingleArray(Coeff)^[5]:=0;
 pSingleArray(Coeff)^[6]:=0.001;
 pSingleArray(Coeff)^[7]:=0.001;
 pSingleArray(Coeff)^[8]:=1;
 if InputPerspectiveParams(pSingleArray(Coeff)^[0],pSingleArray(Coeff)^[1], pSingleArray(Coeff)^[2],
 pSingleArray(Coeff)^[3], pSingleArray(Coeff)^[4],pSingleArray(Coeff)^[5],
 pSingleArray(Coeff)^[6], pSingleArray(Coeff)^[7],pSingleArray(Coeff)^[8],Interpolation)
 then
   ProcessWithResizing(WarpPerspective,PerspectiveSizing);

end;


end.
