unit iplfunc2;
{
 *  INTEL Image Processing Library sample app
 *  image processing functions
 *  Peter G.Darakhvelidze
 *  E-mail:     petr@p-media.spb.ru
 *
}
interface
uses ipl2,jpeg;

 type TFillingProcedure = procedure(v: pIntegerArray;len: Integer);

Type

 TProcessingFunction2 = function(srcImage, dstImage: pIplImage):boolean;
 TSizingFunction = function (srcImage: pIplImage;var NewX, NewY: Integer):boolean;

 var FillingProcedure : TFillingProcedure;
     Coeff : pointer; // shared memory for processing params
 const  Interpolation : Integer = 0;

 function AddS(srcImage, dstImage: pIplImage):boolean;
 function SubS(srcImage, dstImage: pIplImage):boolean;
 function OrS(srcImage, dstImage: pIplImage):boolean;
 function XorS(srcImage, dstImage: pIplImage):boolean;
 function Threshold(srcImage, dstImage: pIplImage):boolean;

 function Blur(srcImage, dstImage: pIplImage):boolean;
 function Laplas(srcImage, dstImage: pIplImage):boolean;
 function Sharp(srcImage, dstImage: pIplImage):boolean;
 function Hilight(srcImage, dstImage: pIplImage):boolean;
 function Average(srcImage, dstImage: pIplImage):boolean;
 function Emboss(srcImage, dstImage: pIplImage):boolean;

 function Sobel(srcImage, dstImage: pIplImage):boolean;
 function Sharpen3x3(srcImage, dstImage: pIplImage):boolean;
 function HiPass3x3(srcImage, dstImage: pIplImage):boolean;
 function HiPass5x5(srcImage, dstImage: pIplImage):boolean;
 function Gaussian3x3(srcImage, dstImage: pIplImage):boolean;
 function Gaussian5x5(srcImage, dstImage: pIplImage):boolean;
 //
 function Median(srcImage, dstImage: pIplImage):boolean;
 function MaxFilter(srcImage, dstImage: pIplImage):boolean;
 function MinFilter(srcImage, dstImage: pIplImage):boolean;

 function Linear(srcImage, dstImage: pIplImage):boolean;
 function Negative(srcImage, dstImage: pIplImage):boolean;
 function Log(srcImage, dstImage: pIplImage):boolean;
 function Exponent(srcImage, dstImage: pIplImage):boolean;
 function Equalize(srcImage, dstImage: pIplImage):boolean;
 function Hyperb(srcImage, dstImage: pIplImage):boolean;
 function Intens(srcImage, dstImage: pIplImage):boolean;

 function Erode(srcImage, dstImage: pIplImage):boolean;
 function Dilate(srcImage, dstImage: pIplImage):boolean;
 function Opening(srcImage, dstImage: pIplImage):boolean;
 function Closing(srcImage, dstImage: pIplImage):boolean;

 function Shear(srcImage, dstImage: pIplImage):boolean;
 function Zoom(srcImage, dstImage: pIplImage):boolean;
 function Decimate(srcImage, dstImage: pIplImage):boolean;
 function WarpAffine(srcImage, dstImage: pIplImage):boolean;
 function WarpBilinear(srcImage, dstImage: pIplImage):boolean;
 function WarpPerspective(srcImage, dstImage: pIplImage):boolean;

implementation

 function AddS(srcImage, dstImage: pIplImage):boolean;
 begin
  IplAddS(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function SubS(srcImage, dstImage: pIplImage):boolean;
 begin
  IplSubtractS(srcImage, dstImage, pInteger(Coeff)^,False);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function OrS(srcImage, dstImage: pIplImage):boolean;
 begin
  IplOrS(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function XorS(srcImage, dstImage: pIplImage):boolean;
 begin
  IplXorS(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Threshold(srcImage, dstImage: pIplImage):boolean;
 begin
  IplThreshold(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Blur(srcImage, dstImage: pIplImage):boolean;
 begin
  IplBlur(srcImage, dstImage, 3, 3, 1,1);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Median(srcImage, dstImage: pIplImage):boolean;
 begin
  IplMedianFilter(srcImage, dstImage, 3, 3, 1,1);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function MaxFilter(srcImage, dstImage: pIplImage):boolean;
 begin
  IplMaxFilter(srcImage, dstImage, 3, 3, 1,1);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function MinFilter(srcImage, dstImage: pIplImage):boolean;
 begin
  IplMinFilter(srcImage, dstImage, 3, 3, 1,1);
  Result := iplGetErrStatus=IPL_StsOk;
 end;

 type

   p2DFilter = ^ T2DFilter;
   T2DFilter = record
   sx,sy : word;
   shrval : word;
   absflag : boolean;
   shift: integer;
   coeff : pShortintArray;
   end;

const
 fLaplas : array[0..8] of shortint = (0,-1,0,-1,4,-1,0,-1,0);
 fSobel1 : array[0..8] of shortint = (1,2,1,0,0,0,-1,-2,-1);
 fSobel2 : array[0..8] of shortint = (1,0,-1,2,0,-2,1,0,-1);

 fAverage : array[0..8] of shortint = (0,102,0,102,104,102,0,102,0);
 fBlur : array[0..8] of shortint = (64,64,64,64,0,64,64,64,64);
 fEdgPoint : array[0..8] of shortint = (30,-60,30,-60,120,-60,30,-60,30);
 fEmbossN : array[0..8] of shortint =  (0,-64,0,0,0,0,0,64,0);
 fEmbossS : array[0..8] of shortint = (0,64,0,0,0,0,0,-64,0);
 fEmbossW : array[0..8] of shortint = (0,0,0,64,0,-64,0,0,0);
 fEmbossE : array[0..8] of shortint = (0,0,0,-64,0,64,0,0,0);
 fHilight : array[0..8] of shortint = (0,-4,0,-4,24,-4,0,-4,0);
 fSharp : array[0..8] of shortint = (-8,-8,-8,-8,127,-8,-8,-8,-8);
 fSmooth : array[0..8] of shortint = (19,19,19,19,104,19,19,19,19);

  AverageFilter : T2DFilter =
  (sx:3;sy:3;shrval:9;absflag:FALSE;shift:0; coeff:@fAverage);
  BlurFilter : T2DFilter =
  (sx:3;sy:3;shrval:9;absflag:FALSE;shift:0; coeff:@fBlur);
  EdgPointFilter : T2DFilter =
  (sx:3;sy:3;shrval:8;absflag:TRUE;shift:0; coeff:@fEdgPoint);
  EmbossNFilter : T2DFilter =
  (sx:3;sy:3;shrval:6;absflag:FALSE;shift:128; coeff: @fEmbossN);
  EmbossSFilter : T2DFilter =
  (sx:3;sy:3;shrval:6;absflag:FALSE;shift:128; coeff:@fEmbossS);
  EmbossWFilter : T2DFilter =
  (sx:3;sy:3;shrval:6;absflag:FALSE;shift:128; coeff:@fEmbossW);
  EmbossEFilter : T2DFilter =
  (sx:3;sy:3;shrval:6;absflag:FALSE;shift:128; coeff:@fEmbossE);
  SharpFilter : T2DFilter =
  (sx:3;sy:3;shrval:6;absflag:FALSE;shift:0; coeff:@fSharp);
  SmoothFilter : T2DFilter =
  (sx:3;sy:3;shrval:8;absflag:FALSE;shift:0; coeff:@fSmooth);
  HilightFilter : T2DFilter =
  (sx:3;sy:3;shrval:3;absflag:FALSE;shift:0; coeff:@fHilight);
  LaplasFilter : T2DFilter =
  (sx:3;sy:3;shrval:3;absflag:FALSE;shift:0; coeff:@fLaplas);

 function SingleFilter(srcImage, dstImage: pIplImage;var Filter: T2DFilter):boolean;
 var Kernel : pIplConvKernel;
 begin
  with Filter do
   begin
   Kernel := IplCreateConvKernelChar(sx,sy,sx div 2,sy div 2,pChar(coeff),shrval);
   if not Assigned(Kernel) then Exit;
   IplConvolve2D(srcImage, dstImage, @Kernel, 1, IPL_SUM);
   IplDeleteConvKernel(Kernel);
   Result := iplGetErrStatus=IPL_StsOk;
   end;
 end;

 function Laplas(srcImage, dstImage: pIplImage):boolean;
 begin
   IplFixedFilter(srcImage, dstImage,IPL_LAPLACIAN_3x3);
   Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Sharp(srcImage, dstImage: pIplImage):boolean;
 begin
  SingleFilter(srcImage, dstImage, SharpFilter);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Hilight(srcImage, dstImage: pIplImage):boolean;
 begin
  SingleFilter(srcImage, dstImage, HilightFilter);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Average(srcImage, dstImage: pIplImage):boolean;
 begin
  SingleFilter(srcImage, dstImage, AverageFilter);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Emboss(srcImage, dstImage: pIplImage):boolean;
 begin
  case pInteger(Coeff)^ of
  1: SingleFilter(srcImage, dstImage, EmbossSFilter);
  2: SingleFilter(srcImage, dstImage, EmbossWFilter);
  3: SingleFilter(srcImage, dstImage, EmbossEFilter);
  else SingleFilter(srcImage, dstImage, EmbossNFilter);
  end;//caSE
  Result := iplGetErrStatus=IPL_StsOk;
 end;

 function Sobel(srcImage, dstImage: pIplImage):boolean;
 var Kernels : array [0..1] of pIplConvKernel;
 begin
  Kernels[0] := IplCreateConvKernelChar(3,3,1,1,@fSobel1,0);
  Kernels[1] := IplCreateConvKernelChar(3,3,1,1,@fSobel2,0);
  if not Assigned(Kernels[0]) then Exit;
  IplConvolve2D(srcImage, dstImage, @Kernels, 2, IPL_SUMSQROOT);
  IplDeleteConvKernel(Kernels[1]);
  IplDeleteConvKernel(Kernels[0]);
  Result := iplGetErrStatus=IPL_StsOk;
 end;

 function Sharpen3x3(srcImage, dstImage: pIplImage):boolean;
 begin
  IplFixedFilter(srcImage, dstImage,IPL_SHARPEN_3x3);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function HiPass3x3(srcImage, dstImage: pIplImage):boolean;
 begin
  IplFixedFilter(srcImage, dstImage,IPL_HIPASS_3x3);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function HiPass5x5(srcImage, dstImage: pIplImage):boolean;
 begin
  IplFixedFilter(srcImage, dstImage,IPL_HIPASS_5x5);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Gaussian3x3(srcImage, dstImage: pIplImage):boolean;
 begin
  IplFixedFilter(srcImage, dstImage,IPL_Gaussian_3x3);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Gaussian5x5(srcImage, dstImage: pIplImage):boolean;
 begin
  IplFixedFilter(srcImage, dstImage,IPL_Gaussian_5x5);
  Result := iplGetErrStatus=IPL_StsOk;
 end;


//______________point operations_____________________//
 procedure FillNeg(v: pIntegerArray;len: Integer);
 var i: Integer;
 begin
 for i:=0 to len-1 do
  v^[i]:= len-1-i;
 end;

 procedure FillLog(v: pIntegerArray;len: Integer);
 var i: Integer;e,f:extended;
 begin
  f:= len-1;
  if pInteger(Coeff)^<>0 then e:=Exp(1/pInteger(Coeff)^) else e:=exp(1);
  for i:=0 to len-1 do
   v^[i]:= Round(Ln((i/f*pInteger(Coeff)^)*(e-1.0)+1.0)*f);
 end;

 procedure FillExp(v: pIntegerArray;len: Integer);
 var i: Integer;e,f:extended;
 begin
  f:= len-1;
  e:=Exp(pInteger(Coeff)^);
  for i:=0 to len-1 do
   v^[i]:= Round((Exp(i/f*pInteger(Coeff)^)-1.0)*f/(e-1.0));
 end;

 function Linear(srcImage, dstImage: pIplImage):boolean;
 var LUT : TIplLut;
  key, value, factor : pIntegerArray;
  luts : array[0..6] of pIplLut;
  i,len : Integer;
 begin
  len := (1 shl srcImage^.depth);
  GetMem(key,len*SizeOf(Integer));
  GetMem(value,len*SizeOf(Integer));
  GetMem(factor,len*SizeOf(Integer));
  for i:=0 to len-1 do
  begin
   key^[i]:=i;value^[i]:=i;Factor^[i]:=0;
  end;
  if Assigned(FillingProcedure) then FillingProcedure(Value,len);

  LUT.key := key;
  LUT.Value := Value;
  LUT.Factor := Factor;
  LUT.num := len;
  LUT.InterpolateType := IPL_LUT_LOOKUP;
  for i:=0 to srcImage^.nChannels do luts[i] := @LUT;
  IplContrastStretch(srcImage, dstImage,@luts);
  Result := iplGetErrStatus=IPL_StsOk;
  FreeMem(factor,len*SizeOf(Integer));
  FreeMem(value,len*SizeOf(Integer));
  FreeMem(key, len*SizeOf(Integer));
 end;

 function Negative(srcImage, dstImage: pIplImage):boolean;
 begin
  FillingProcedure := FillNeg;
  Result := Linear(srcImage, dstImage);
 end;
 function Exponent(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pInteger(Coeff)^ in [1..10] then pInteger(Coeff)^ := 1;
  FillingProcedure := FillExp;
  Result := Linear(srcImage, dstImage);
 end;
 function Log(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pInteger(Coeff)^ in [1..10] then pInteger(Coeff)^ := 1;
  FillingProcedure := FillLog;
  Result := Linear(srcImage, dstImage);
 end;
//---------------------------------------//
procedure PrepareLUTs(srcImage: pIplImage;var LUTs:array of pIplLUT);
var i,j,len : Integer;
begin
  len := (1 shl srcImage^.depth);
  for i:=0 to srcImage^.nChannels-1 do
    begin
    New(luts[i]);
    luts[i]^.interpolateType := IPL_LUT_LOOKUP;
    luts[i]^.num := len;
    GetMem(luts[i]^.key,len*SizeOf(Integer));
    for j:=0 to len-1 do luts[i]^.key^[j]:=j;
    GetMem(luts[i]^.value,len*SizeOf(Integer));
    FillChar(luts[i]^.value^,len*SizeOf(Integer),0);
    GetMem(luts[i]^.factor,len*SizeOf(Integer));
    FillChar(luts[i]^.factor^,len*SizeOf(Integer),0);
    end;
end;
procedure FreeLUTs(srcImage: pIplImage;var LUTs:array of pIplLUT);
var i,len : Integer;
begin
  len := (1 shl srcImage^.depth);
  for i:=0 to srcImage^.nChannels-1 do
    begin
    FreeMem(luts[i]^.key,len*SizeOf(Integer));
    FreeMem(luts[i]^.value,len*SizeOf(Integer));
    FreeMem(luts[i]^.factor,len*SizeOf(Integer));
    Dispose(luts[i]);
    end;
end;

function Equalize(srcImage, dstImage: pIplImage):boolean;
 var  luts : array[0..6] of pIplLut;
 begin
  PrepareLUTs(srcImage,luts);
  IplComputeHisto(srcImage,@luts);
  IplHistoEqualize(srcImage, dstImage,@luts);
  Result := iplGetErrStatus=IPL_StsOk;
  FreeLUTs(srcImage,luts);
 end;

 const e:float = 2.71818;
 function power(x,y:extended):extended;
 begin
  if x<=1E-8 then power:=0 else
  power:=exp(y*ln(x));
 end;

 function Hyperb(srcImage, dstImage: pIplImage):boolean;
 var
  luts : array[0..6] of pIplLut; //need more?
  i,j,m,len : Integer;
 begin
  PrepareLUTs(srcImage, luts);
  IplComputeHisto(srcImage, @luts);
  len := (1 shl srcImage^.depth);
  for i:=0 to srcImage^.nChannels-1 do with luts[i]^ do
    begin
    factor[0]:=value[0];
    for j:= 1 to len-1 do factor[j]:=factor[j-1]+value[j];
    m := factor[len-1];
    for j:= 1 to len-1 do value[j]:=Round((Exp(factor[j]/m)-1.0)*(len-1)/(e-1.0));
    end;
  IplContrastStretch(srcImage, dstImage, @luts);
  Result := iplGetErrStatus=IPL_StsOk;
  FreeLUTs(srcImage, luts);
 end;

 function Intens(srcImage, dstImage: pIplImage):boolean;
 var
  value, factor : pIntegerArray;
  luts : array[0..6] of pIplLut;
  i,j,m,len : Integer;
  pw : extended;
 begin
  if pInteger(Coeff)^=0 then pw:=0.5 else pw := pInteger(Coeff)^/100;
  PrepareLUTs(srcImage, luts);
  IplComputeHisto(srcImage, @luts);
  len := (1 shl srcImage^.depth);

  for i:=0 to srcImage^.nChannels-1 do with luts[i]^ do
    begin
    factor[0]:=Round(power(value[0],pw));
    for j:= 1 to len-1 do factor[j]:=factor[j-1]+Round(power(value[j],pw));
    m := factor[len-1];
    for j:= 0 to len-1 do value[j]:=Round((factor[j]/m)*(len-1));
    end;
  IplContrastStretch(srcImage, dstImage,@luts);
  Result := iplGetErrStatus=IPL_StsOk;
  FreeLUTs(srcImage,luts);
 end;

 ////
 function Erode(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pInteger(Coeff)^ in [1..11] then pInteger(Coeff)^ := 1;
  IplErode(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Dilate(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pInteger(Coeff)^ in [1..11] then pInteger(Coeff)^ := 1;
  IplDilate(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Opening(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pInteger(Coeff)^ in [1..11] then pInteger(Coeff)^ := 1;
  IplOpen(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function Closing(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pInteger(Coeff)^ in [1..11] then pInteger(Coeff)^ := 1;
  IplClose(srcImage, dstImage, pInteger(Coeff)^);
  Result := iplGetErrStatus=IPL_StsOk;
 end;

 function Shear(srcImage, dstImage: pIplImage):boolean;
 var xShear, yShear : double;
 begin
  xShear:= pSingleArray(Coeff)^[0];
  yShear:= pSingleArray(Coeff)^[1];
  IplShear(srcImage, dstImage, xShear, yShear,pSingleArray(Coeff)^[2],pSingleArray(Coeff)^[3],Interpolation);
  Result := iplGetErrStatus=IPL_StsOk;
 end;

 function Zoom(srcImage, dstImage: pIplImage):boolean;
 begin
  if not pIntegerArray(Coeff)^[0] in [1..11] then pIntegerArray(Coeff)^[0] := 1;
  if not pIntegerArray(Coeff)^[1] in [1..11] then pIntegerArray(Coeff)^[1] := 1;
  if not pIntegerArray(Coeff)^[2] in [1..11] then pIntegerArray(Coeff)^[2] := 1;
  if not pIntegerArray(Coeff)^[3] in [1..11] then pIntegerArray(Coeff)^[3] := 1;

  IplZoom(srcImage, dstImage, pIntegerArray(Coeff)^[2],pIntegerArray(Coeff)^[0],
     pIntegerArray(Coeff)^[3],pIntegerArray(Coeff)^[1],Interpolation);
  Result := iplGetErrStatus=IPL_StsOk;   
 end;

 function Decimate(srcImage, dstImage: pIplImage):boolean;
 begin
 //if not pInteger(Coeff)^ in [1..11] then pInteger(Coeff)^ := 1;
  if not pIntegerArray(Coeff)^[0] in [1..11] then pIntegerArray(Coeff)^[0] := 1;
  if not pIntegerArray(Coeff)^[1] in [1..11] then pIntegerArray(Coeff)^[1] := 1;
  if not pIntegerArray(Coeff)^[2] in [1..11] then pIntegerArray(Coeff)^[2] := 1;
  if not pIntegerArray(Coeff)^[3] in [1..11] then pIntegerArray(Coeff)^[3] := 1;
  IplDecimate(srcImage, dstImage, pIntegerArray(Coeff)^[2],pIntegerArray(Coeff)^[0],
     pIntegerArray(Coeff)^[3],pIntegerArray(Coeff)^[1],Interpolation);
  Result := iplGetErrStatus=IPL_StsOk;     
 end;

 function WarpAffine(srcImage, dstImage: pIplImage):boolean;
 var ac : TAffineCoeffs;
 var ar : TAffineRect;
 begin
  ac[0,0] := pSingleArray(Coeff)^[0];
  ac[0,1] := pSingleArray(Coeff)^[1];
  ac[0,2] := 0;
  ac[1,0] := pSingleArray(Coeff)^[2];
  ac[1,1] := pSingleArray(Coeff)^[3];
  ac[1,2] := 0;
  iplGetAffineBound(srcImage, ac, ar);
  ac[0,2] := -ar[0,0];
  ac[1,2] := -ar[0,1];
  IplWarpAffine(srcImage, dstImage, ac,Interpolation);
  Result := iplGetErrStatus=IPL_StsOk;
 end;

 function WarpBilinear(srcImage, dstImage: pIplImage):boolean;
 var bc : TBilinearCoeffs;
 var ar : TAffineRect;
 begin
  bc[0,0] := pSingleArray(Coeff)^[0];
  bc[0,1] := pSingleArray(Coeff)^[1];
  bc[0,2] := pSingleArray(Coeff)^[2];
  bc[0,3] := 0;
  bc[1,0] := pSingleArray(Coeff)^[3];
  bc[1,1] := pSingleArray(Coeff)^[4];
  bc[1,2] := pSingleArray(Coeff)^[5];
  bc[1,3] := 0;
  iplGetBilinearBound(srcImage, bc, ar);
  bc[0,3] := -ar[0,0];
  bc[1,3] := -ar[0,1];
  IplWarpBilinear(srcImage, dstImage, bc,IPL_WARP_R_TO_Q,Interpolation);
  Result := iplGetErrStatus=IPL_StsOk;
 end;
 function WarpPerspective(srcImage, dstImage: pIplImage):boolean;
 var pc : TPerspectiveCoeffs;
   ar : TAffineRect;aq : TAffineQuad;
   i : Integer;
 begin
  pc[0,0] := pSingleArray(Coeff)^[0];
  pc[0,1] := pSingleArray(Coeff)^[1];
  pc[0,2] := pSingleArray(Coeff)^[2];
  pc[1,0] := pSingleArray(Coeff)^[3];
  pc[1,1] := pSingleArray(Coeff)^[4];
  pc[1,2] := pSingleArray(Coeff)^[5];
  pc[2,0] := pSingleArray(Coeff)^[6];
  pc[2,1] := pSingleArray(Coeff)^[7];
  pc[2,2] := pSingleArray(Coeff)^[8];
  iplGetPerspectiveBound(srcImage, pc, ar);
  iplGetPerspectiveQuad(srcImage, pc, aq);
  if ar[0,0]<0 then for i:=0 to 3 do aq[i,0]:=aq[i,0] - ar[0,0];
  if ar[0,1]<0 then for i:=0 to 3 do aq[i,1]:=aq[i,1] - ar[0,1];
  IplWarpPerspectiveQ(srcImage, dstImage, aq,IPL_WARP_R_TO_Q,Interpolation);
  Result := iplGetErrStatus=IPL_StsOk;
 end;

initialization
GetMem(Coeff,32*SizeOF(double));
finalization
 //if Assigned(Coeff) then FreeMem(Coeff,32*SizeOF(double));
end.
