unit iplDIB;

interface
uses SysUtils, Windows, Graphics, ipl2;
function iplImageToDib(image: pIplImage):pBITMAPFILEHEADER;
function allocateDib(header: pBITMAPINFOHEADER):pBITMAPFILEHEADER;

implementation

function iplImageToDib(image: pIplImage):pBITMAPFILEHEADER;
var     bmp : TBITMAPINFOHEADER ;
        DIB : PBITMAPINFOHEADER ;
begin
    bmp.biSize:=sizeof(TBITMAPINFOHEADER);
    bmp.biWidth:=image.width;
    bmp.biHeight:=image.height;
    bmp.biPlanes:=1;
    case image.nChannels of
    1: bmp.biBitCount := 8;
    3: bmp.biBitCount := 24;
    4: bmp.biBitCount := 32;
    else bmp.biBitCount := 0;
    end;//case
    bmp.biCompression:=BI_RGB;
    bmp.biSizeImage:=0;
    bmp.biXPelsPerMeter:=0;
    bmp.biYPelsPerMeter:=0;
    if Image.nChannels=1  then bmp.biClrUsed:=1 shl bmp.biBitCount else bmp.biClrUsed:=0;
    bmp.biClrImportant:=0;
    if (bmp.biBitCount = 0) then
    begin
     raise EAbort.Create('');
    end;
    Result := allocateDib(@bmp);
    DIB := @(pByteArray(Result)^[SizeOF(TBitmapFileHeader)]);
    iplConvertToDIB(image,dib,IPL_DITHER_NONE, IPL_PALCONV_POPULATE);
end;

function allocateDib(header: pBITMAPINFOHEADER):pBITMAPFILEHEADER;
var
    memsize: Integer;
    dib :pBitmapInfoHeader;
    i:Integer;
    b : byte;
begin
    memsize := SizeOF(TBitmapFileHeader) + header.biSize +
        (( ((header.biWidth * header.biBitCount) + 31) div 32 ) *4) *
        header.biHeight;
    if (Header^.biClrUsed>0) then Inc(MemSize,256 * sizeof(TRGBQUAD) );
    GetMem(Result,memsize);
    if (Result=nil) then Exit;
    Result.bfType := $4D42;
    Result.bfSize := memsize;
    Result.bfOffBits := memsize
    - (( ((header.biWidth * header.biBitCount) + 31) div 32 ) *4) *
        header.biHeight;
    dib := @(pByteArray(Result)^[SizeOF(TBitmapFileHeader)]);
    dib^ := header^;
    if (dib^.biClrUsed>0) then begin
        for i := 0 to dib^.biClrUsed-1 do begin
            b := Round((i*255)/(dib^.biClrUsed-1));
            pBitmapInfo(dib).bmiColors[i].rgbRed := b;
            pBitmapInfo(dib).bmiColors[i].rgbGreen := b;
            pBitmapInfo(dib).bmiColors[i].rgbBlue := b;
        end;
    end;
end;

end.
