unit InputPrm;

interface

uses
  Sharemem, SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, Grids;

type
  TGeomParamsForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    StringGrid1: TStringGrid;
    Label1: TLabel;
    InterpRadioGroup: TRadioGroup;
  end;


 function InputZoomParams(var xSrc,ySrc,xDst,yDst: Integer;Interpolation : Integer):boolean;
 function InputShearParams(var xSrc,ySrc,xCenter,yCenter: single;Interpolation : Integer):boolean;
 function InputAffineParams(var a11,a12,a21,a22: single;Interpolation : Integer):boolean;
 function InputBilinearParams(var a11,a12,a13,a21,a22,a23: single;Interpolation : Integer):boolean;
 function InputPerspectiveParams(var a11,a12,a13,a21,a22,a23,a31,a32,a33: single;Interpolation : Integer):boolean;
 //
 function InputInteger(ACaption, APrompt: string;var I:Integer):boolean;


implementation

{$R *.DFM}
 uses Dialogs;

  type
  pSingleArray = ^TSingleArray;
  TSingleArray = Array[0..1023] of Single;

procedure CorrectGridColumns(Grid: TStringGrid);
var i,tw,cw : Integer;coeff: Single;
begin
 tw := 0;
 for i:=0 to Grid.ColCount-1 do Inc(tw,Grid.ColWidths[i]+Ord(goVertLine in Grid.Options));
 Coeff := tw/(Grid.Width {-GetSystemMetrics(SM_CXVSCROLL) }  - 1);
 if Coeff < 1.2 then
 for i:=0 to Grid.ColCount-1 do Grid.ColWidths[i]:=Trunc(Grid.ColWidths[i]/Coeff);

 tw := 0;
 for i:=0 to Grid.RowCount-1 do Inc(tw,Grid.RowHeights[i]+Ord(goHorzLine in Grid.Options));
 Coeff := tw/(Grid.Height{-GetSystemMetrics(SM_CYHSCROLL)} - 1);
 if Coeff < 1.2 then
 for i:=0 to Grid.RowCount-1 do Grid.RowHeights[i]:=Trunc(Grid.RowHeights[i]/Coeff);
end;

 function ShowForm(Title: string;HTitles,VTitles: array of string;data:pointer;Interpolation : Integer): boolean;//;data: pointer
 var i,j,k : Integer;
  GeomParamsForm: TGeomParamsForm;
 begin
  GeomParamsForm:= TGeomParamsForm.Create(Application);
  with GeomParamsForm do
  begin
  Label1.Caption := Title;
  with StringGrid1 do
   begin
   ColCount := High(HTitles) - Low(HTitles) + FixedCols + 1;
   RowCount := High(VTitles) - Low(VTitles) + FixedRows + 1;
   for i:= Low(VTitles) to High(VTitles) do Cells[0,i+1]:=VTitles[i];
   for j:= Low(HTitles) to High(HTitles) do Cells[j+1,0]:=HTitles[j];
   k:=0;
   for i:= Low(VTitles) to High(VTitles) do
   for j:= Low(HTitles) to High(HTitles) do
      try
      Cells[j+1,i+1]:=FloatToStrF(pSingleArray(Data)^[k],ffFixed,7,3);
      Inc(k);
      except
       on EConvertError do  Cells[j+1,i+1]:='0';
      end;
   end;
   CorrectGridColumns(StringGrid1);
   Result := ShowModal=mrOk;
  if Result then with StringGrid1 do
   begin
    k:=0;
    for i:= Low(VTitles) to High(VTitles) do
    for j:= Low(HTitles) to High(HTitles) do
      try
      pSingleArray(Data)^[k] := StrToFloat(Cells[j+1,i+1]);
      Inc(k);
      except
       on EConvertError do  pSingleArray(Data)^[k] := 0;
      end;
   end;
  Interpolation := InterpRadioGroup.ItemIndex;
  Free;
  end;
 end;

 function InputZoomParams;
 var data : array[0..3] of single;
 begin
   data[0] := xsrc;  data[1] := ysrc;
   data[2] := xdst;  data[3] := ydst;
   Result :=  ShowForm('Zoom',['X','Y'],['Src','Dst'],@data,Interpolation);
   if Result then
   begin
    xSrc := Round(data[0]);   xDst := Round(data[2]);
    ySrc := Round(data[1]);   yDst := Round(data[3]);
   end;
 end;

 function InputShearParams;
 var data : array[0..3] of single;
 begin
   data[0] := xsrc;  data[1] := ysrc;
   data[2] := xCenter; data[3] := yCenter;
   Result :=  ShowForm('Shear transform',['X','Y'],['Shear','Center'],@data,Interpolation);
   if Result then
   begin
    xSrc := data[0];  ySrc := data[1];
    xCenter:= data[2];  yCenter:= data[3];
   end;
 end;
 function InputAffineParams;
 var data : array[0..3] of single;
 begin
   data[0] := a11;  data[1] := a12;
   data[2] := a21;  data[3] := a22;
   Result :=  ShowForm('Affine Transform',['*X','*Y'],['X''=','Y''='],@data,Interpolation);
   if Result then
   begin
    a11 := data[0]; a12  := data[1];
    a21 := data[2]; a22  := data[3];
   end;
 end;
function InputBilinearParams;
  var data : array[0..5] of single;
 begin
   data[0] := a11;  data[1] := a12; data[2] := a13;
   data[3] := a21;  data[4] := a22; data[5] := a23;
   Result :=  ShowForm('Bilinear Transform',['*XY','*X','*Y'],['X''=','Y''='],@data,Interpolation);
   if Result then
   begin
    a11 := data[0]; a12  := data[1]; a13  := data[2];
    a21 := data[3]; a22  := data[4]; a23  := data[5];
   end;
 end;
function InputPerspectiveParams;
  var data : array[0..8] of single;
 begin
   data[0] := a11;  data[1] := a12; data[2] := a13;
   data[3] := a21;  data[4] := a22; data[5] := a23;
   data[6] := a31;  data[7] := a32; data[8] := a33;
   Result :=  ShowForm('Perspective Transform',['*X','*Y','+'],['X''=','Y''=','D='],@data,Interpolation);
   if Result then
   begin
    a11 := data[0]; a12  := data[1]; a13  := data[2];
    a21 := data[3]; a22  := data[4]; a23  := data[5];
    a31 := data[6]; a32  := data[7]; a33  := data[8];
   end;
 end;

//
function InputInteger(ACaption, APrompt: string;var I:Integer):boolean;
var s: string;
begin
 Result := InputQuery(ACaption, APrompt, s);
 if not Result then Exit;
 try
  i :=StrToInt(s);
 except
  on EConvertError do
   begin
   Result := False;
   i :=0;
   end;
 end;
end;

end.
