(*
   TIntegerNumber Component Tester
   Main Form Class
*)
unit IntNumTest01;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs, StdCtrls,
  Spin, IntegerNumber;

type
  TMainForm = class(TForm)
    IntegerNumber: TIntegerNumber;
    Label1: TLabel;
    edMin: TSpinEdit;
    Button1: TButton;
    Label2: TLabel;
    edMax: TSpinEdit;
    Button2: TButton;
    Label3: TLabel;
    edValue: TSpinEdit;
    Button3: TButton;
    ListBox: TListBox;
    Button4: TButton;
    cbSilentErrors: TCheckBox;
    cbAutoAdjust: TCheckBox;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure cbSilentErrorsClick(Sender: TObject);
    procedure cbAutoAdjustClick(Sender: TObject);
    procedure IntegerNumberChange(Sender: TObject);
    procedure IntegerNumberChangeQuery(Sender: TObject; NewValue: Integer;
      var CanChange: Boolean);
    procedure IntegerNumberOverflow(Sender: TObject);
    procedure IntegerNumberUnderflow(Sender: TObject);
  private
    procedure RefreshControls;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if key = VK_ESCAPE then close;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  RefreshControls;
end;

procedure TMainForm.RefreshControls;
begin
 with IntegerNumber do
  begin
   edValue.Value := Value;
   edMin.Value := Min;
   edMax.Value := Max;
   cbAutoAdjust.Checked := inAutoAdjust in Options;
   cbSilentErrors.Checked := inSilentErrors in Options;
  end;
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
 ListBox.Clear;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
 try
  IntegerNumber.Min := edMin.Value;
 finally
  refreshControls;
 end;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
 try
  IntegerNumber.Max := edMax.Value;
 finally
  refreshControls;
 end;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
 try
  IntegerNumber.Value := edValue.Value;
 finally
  refreshControls;
 end;
end;

procedure TMainForm.cbSilentErrorsClick(Sender: TObject);
begin
 with IntegerNumber do
 if ( Sender as TCheckBox ).Checked
  then Options := Options + [ inSilentErrors ]
  else Options := Options - [ inSilentErrors ];
end;

procedure TMainForm.cbAutoAdjustClick(Sender: TObject);
begin
 with IntegerNumber do
 if ( Sender as TCheckBox ).Checked
  then Options := Options + [ inAutoAdjust ]
  else Options := Options - [ inAutoAdjust ];
end;

procedure TMainForm.IntegerNumberChange(Sender: TObject);
begin
 ListBox.Items.Add( 'Value changed' );
end;

procedure TMainForm.IntegerNumberChangeQuery(Sender: TObject;
  NewValue: Integer; var CanChange: Boolean);
begin
 ListBox.Items.Add( 'change query' );
 CanChange := MessageDlg( 'Change query (new value - ' +
  IntToStr( NewValue ) + '). Confirm changes?', mtConfirmation,
   [ mbYes, mbNo ], 0 ) = mrYes;
end;

procedure TMainForm.IntegerNumberOverflow(Sender: TObject);
begin
 ListBox.Items.Add( 'Overflow' );
end;

procedure TMainForm.IntegerNumberUnderflow(Sender: TObject);
begin
 ListBox.Items.Add( 'Underflow' );
end;

end.
