unit TestUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  InstallComp, StdCtrls, ShlObj, OLE2;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    InstComp1: TInstComp;

    procedure InstComp1Install(Sender: TObject);
    procedure InstComp1Uninstall(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure InstComp1BeforeUninstall(Sender: TObject; var DoIt: Boolean);
    procedure InstComp1BeforeInstall(Sender: TObject; var DoIt: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure InstComp1AllreadyInstalled(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.InstComp1Install(Sender: TObject);
begin
 // Put code to do other installing tasks here!
 ShowMessage('Installing!');

end;

procedure TForm1.InstComp1Uninstall(Sender: TObject);
begin
 // Put code to do other uninstal tasks here!
 // It is also place to read uninstall parametrs, if they were modified in
 // OnBeforeInstall event handler.
 ShowMessage('Uninstalling!');
end;

procedure TForm1.FormShow(Sender: TObject); // demo routine
var OsVer:TOSVERSIONINFO;
begin
 OsVer.dwOSVersionInfoSize:=sizeof(OsVer);
 if getversionex(osver) then begin
    Label1.Caption:='OS Major version: '+inttostr(OsVer.dwMajorVersion);
    Label2.Caption:='OS Minor version: '+inttostr(OsVer.dwMinorVersion);
    Label3.Caption:='OS Build : '+inttostr(OsVer.dwBuildNumber);
    Label4.Caption:='OS Platform: '+inttostr(OsVer.dwPlatformId);
  end;
end;

procedure TForm1.InstComp1BeforeUninstall(Sender: TObject;
  var DoIt: Boolean);
begin
 // If you customize installation parametrs, you must read them now!
  DoIt:=MessageDlg('Uninstall program?', mtConfirmation, mbOkCancel, 0)=mrOK;
end;



procedure TForm1.InstComp1BeforeInstall(Sender: TObject;
  var DoIt: Boolean);
Var s:String;
    i:integer;
    b:boolean;
begin
 // You can put here some checking routines to avoid installation of program on
 // floppy disk, CD-ROM or other unsuitable place
 s:=UpperCase(ExtractFileDrive(ParamStr(0)));
 if s[1]<>'\' then
  i:=GetDriveType(PChar(s+'\')) else i:=Drive_Remote;
    b:=false;
    case i of
    0..Drive_Removable        : b:=false;
    DRIVE_FIXED,DRIVE_REMOTE  : b:=true;
    DRIVE_CDROM,DRIVE_RAMDISK : b:=false;
    end;
 if b then begin
 // Here you can change installation group, program name and other parametrs,
 // but then you have to record parametrs for uninstall yourself!
 s:=#13#10+'Parametrs: '+#13#10+' Programm group '+InstComp1.ProgrammGroup+#13#10+
       ' Programm name '+InstComp1.ProgrammName+#13#10;
  DoIt:=MessageDlg('Install program?'+s, mtConfirmation, mbOkCancel, 0)=mrOK;
 end else DoIt:=false;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.InstComp1AllreadyInstalled(Sender: TObject);
begin
Showmessage('Already installed!');
end;

end.
