unit Inputdlg;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DsgnIntf, WinTypes, WinProcs,
  Menus;

{-------------------------------- new bit}
type
	TMyDataType = record
	Name : string;
{----------------------------------}
end;

Type
    TInputdlg = class(TComponent)
private
    FAbout:	string; { new bit--------}
    FFormCaption: string;
    FPrompt:	string;
    FInitialText: string;
    FInputText: string;
    FDefaultText: String;
    function GettheInput: Boolean;
    procedure ShowAbout; {----------new bit}

protected
    {procedure CreateWnd ; override;}
public
    textout: String;
    thetext:String;
    constructor Create(AOwner: TComponent); override;
    procedure Execute;
    property Inputtext: String read FInputtext;
    destructor Destroy; override;
published
    property DefaultText: string read FDefaultText write FDefaultText;
{--------------new bit}
    property About: string read FAbout write FAbout stored False;
{--------------------------}
    property Prompt: String read FPrompt write FPrompt;
    property InitialText: string read FInitialText write FInitialText;
    property FormCaption: string read FFormCaption write FFormCaption;
end;

procedure Register;

implementation

{-----------------------------------new bit}
type
    TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

procedure TAboutProperty.Edit;
{Invoke the about dialog when clicking on ... in the Object Inspector}
begin
    TInputdlg(GetComponent(0)).ShowAbout;
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{Make settings for just displaying a string in the ABOUT property in the
Object Inspector}
begin
    GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: String;
{Text in the Object Inspector for the ABOUT property}
begin
    GetValue := '(About)';
end;

procedure TInputdlg.ShowAbout;
var
    msg: string;
const
    carriage_return = chr(13);
    copyright_symbol = chr(169);
begin
    msg := 'Input Dialog Component v2.32';
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'A Freeware component');
    AppendStr(msg, carriage_return);
    {AppendStr(msg, carriage_return);}
    AppendStr(msg, 'Created Nov 1996');
    {AppendStr(msg, copyright_symbol);}
   { AppendStr(msg, ' 1996, 1997');}
    AppendStr(msg, carriage_return);
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'TPS Consulting');
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'RMB 4280 Taminick');
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'Via Glenrowan');
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'Victoria, 3675');
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'Australia');
    AppendStr(msg, carriage_return);
    AppendStr(msg, 'E-mail tps@netc.net.au');
    AppendStr(msg, carriage_return);
    ShowMessage(msg);
end;
{--------------------------new bit}

procedure TInputdlg.Execute;
var
  isday : String;
  Present: TDateTime;
  Year, Month, Day, Hour, Min, Sec, MSec: Word;
begin
 { Present:= Now;
  DecodeDate(Present, Year, Month, Day);
  isday := IntToStr(Day);
   If isday = '1' then
   begin
   Showmessage('Inputdlg Version 2.32' + #13 + #13
   + 'Evaluation Copy Only' + #13 + #13
   + 'Copyright TPS Consulting' + #13
   + 'E-Mail tps@netc.net.au'+ #13);
   end
   else}
    GettheInput;
end;

constructor TInputdlg.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
  FFormCaption := 'My InputBox';
  FInitialText := 'tps@netc.net.au';
  Prompt := 'Enter text';
  if csDesigning in ComponentState then
     MessageDlg('Input Dialog Component v2.32' + #13 + #13
     + 'A Freeware Component' + #13 + #13
     + 'Created Nov, 1996' +#13
     + 'TPS Consulting' + #13 + #13
     + 'E-Mail: tps@netc.net.au', mtInformation, [mbOK], 0) ;
end;

destructor TInputdlg.Destroy;
begin
  inherited Destroy;
end;

function TInputdlg.GettheInput: Boolean;
var
   ClickedOK, ClickedCancel : Boolean;
begin
    if FInputText = '' then
    theText := FInitialText
    else
	theText := FInputText;
  ClickedOK := InputQuery(FormCaption, Prompt, Thetext);
  if ClickedOK then
   begin
   textout := thetext;
   end
   else
   If FDefaultText <> '' then
   textout := FDefaultText
   else
    textout := '';
  end;

procedure Register;
begin
  RegisterComponents('Dialogs', [TInputdlg]);
{---------------------new bit}
  RegisterPropertyEditor(TypeInfo(String), TInputdlg,
  'About', TAboutProperty);
{----------------------------}
end;

initialization

end.
